/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.elements;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ElectronConfiguration {
    private final EnumMap<AtomicOrbital, Integer> configuration = new EnumMap(AtomicOrbital.class);

    public static ElectronConfiguration parseElectronConfigurationFromString(String orbitalsString) {
        String[] splitOrbitals = orbitalsString.toLowerCase().split("-");
        ElectronConfiguration configuration = new ElectronConfiguration();
        for (String orbitalString : splitOrbitals) {
            configuration.getConfiguration().put(AtomicOrbital.getAtomicOrbital(orbitalString.substring(0, 2)), Integer.valueOf(orbitalString.substring(2)));
        }
        return configuration;
    }

    public Map<AtomicOrbital, Integer> getConfiguration() {
        return this.configuration;
    }

    public int getOuterMostShell() {
        return this.configuration.keySet().stream().mapToInt(AtomicOrbital::getShell).max().orElseThrow(() -> new IllegalStateException("The configuration does not contain any orbitals."));
    }

    public Map<AtomicOrbital, Integer> getOrbitalsOfShell(int shell) {
        return this.configuration.entrySet().stream().filter(entry -> ((AtomicOrbital)((Object)((Object)entry.getKey()))).getShell() == shell).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public int getTotalNumberOfElectrons() {
        return this.configuration.values().stream().reduce((v1, v2) -> v1 + v2).orElseThrow(() -> new IllegalStateException("The configuration does not contain any orbitals."));
    }

    public int getNumberOfValenceElectrons() {
        if (this.isTransitionGroup()) {
            Map<AtomicOrbital, Integer> incompleteShells = this.getIncompleteShells();
            Map<AtomicOrbital, Integer> outerShells = this.getOrbitalsOfShell(this.getOuterMostShell());
            HashMap<AtomicOrbital, Integer> distinct = new HashMap<AtomicOrbital, Integer>();
            distinct.putAll(incompleteShells);
            distinct.putAll(outerShells);
            return (Integer)distinct.values().stream().reduce((v1, v2) -> v1 + v2).orElseThrow(() -> new IllegalStateException("The configuration does not contain any orbitals."));
        }
        return this.getNumberOfElectronsInOutermostShell();
    }

    private boolean isTransitionGroup() {
        return this.getIncompleteShells().keySet().stream().anyMatch(orbital -> orbital.getSubShell() == 'd' || orbital.getSubShell() == 'f');
    }

    private int getNumberOfElectronsInOutermostShell() {
        return this.getOrbitalsOfShell(this.getOuterMostShell()).values().stream().reduce((v1, v2) -> v1 + v2).orElseThrow(() -> new IllegalStateException("The configuration does not contain any orbitals."));
    }

    public Map<AtomicOrbital, Integer> getIncompleteShells() {
        return this.configuration.entrySet().stream().filter(entry -> ((AtomicOrbital)((Object)((Object)entry.getKey()))).getMaximalElectrons() - (Integer)entry.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String toString() {
        return this.configuration.entrySet().stream().map(entry -> ((AtomicOrbital)((Object)((Object)entry.getKey()))).toString() + entry.getValue()).collect(Collectors.joining("-"));
    }

    public static enum AtomicOrbital {
        S1('s', 1),
        S2('s', 2),
        P2('p', 2),
        S3('s', 3),
        P3('p', 3),
        D3('d', 3),
        S4('s', 4),
        P4('p', 4),
        D4('d', 4),
        F4('f', 4),
        S5('s', 5),
        P5('p', 5),
        D5('d', 5),
        F5('f', 5),
        S6('s', 6),
        P6('p', 6),
        D6('d', 6),
        S7('s', 7),
        P7('p', 7);

        public static final int MAX_ELECTRONS_S = 2;
        public static final int MAX_ELECTRONS_P = 6;
        public static final int MAX_ELECTRONS_D = 10;
        public static final int MAX_ELECTRONS_F = 14;
        private final int shell;
        private final char subShell;

        private AtomicOrbital(char subShell, int shell) {
            this.shell = shell;
            this.subShell = subShell;
        }

        public static AtomicOrbital getAtomicOrbital(String orbitalString) {
            if (orbitalString.length() == 2) {
                if (Character.isDigit(orbitalString.charAt(0))) {
                    return Arrays.stream(AtomicOrbital.values()).filter(orbital -> orbital.shell == Character.getNumericValue(orbitalString.charAt(0)) && orbital.subShell == orbitalString.charAt(1)).findAny().orElseThrow(() -> new IllegalArgumentException("The orbital " + orbitalString + " is no valid atomic orbital."));
                }
                return Arrays.stream(AtomicOrbital.values()).filter(orbital -> orbital.shell == Character.getNumericValue(orbitalString.charAt(1)) && orbital.subShell == orbitalString.charAt(0)).findAny().orElseThrow(() -> new IllegalArgumentException("The orbital " + orbitalString + " is no valid atomic orbital."));
            }
            throw new IllegalArgumentException("The orbital " + orbitalString + " is no valid atomic orbital.");
        }

        public int getShell() {
            return this.shell;
        }

        public char getSubShell() {
            return this.subShell;
        }

        public int getMaximalElectrons() {
            switch (this.subShell) {
                case 's': {
                    return 2;
                }
                case 'p': {
                    return 6;
                }
                case 'd': {
                    return 10;
                }
                case 'f': {
                    return 14;
                }
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.shell) + this.subShell;
        }
    }
}

