/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.elements;

import de.bioforscher.singa.features.units.UnitProvider;
import de.bioforscher.singa.structure.elements.ElectronConfiguration;
import de.bioforscher.singa.structure.features.molarmass.MolarMass;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import tec.uom.se.quantity.Quantities;

public class Element {
    private final String name;
    private final String symbol;
    private final int protonNumber;
    private final int electronNumber;
    private final int valenceElectronNumber;
    private final int neutronNumber;
    private Quantity<MolarMass> atomicMass;
    private Quantity<Length> vanDerWaalsRadius;

    public Element(String name, String symbol, int protonNumber, Quantity<MolarMass> atomicWeight, String electronConfiguration) {
        this.name = name;
        this.symbol = symbol;
        this.protonNumber = protonNumber;
        this.electronNumber = protonNumber;
        this.valenceElectronNumber = ElectronConfiguration.parseElectronConfigurationFromString(electronConfiguration).getNumberOfValenceElectrons();
        this.neutronNumber = protonNumber;
        this.atomicMass = atomicWeight;
    }

    public Element(String name, String symbol, int protonNumber, double atomicWeight, String electronConfiguration, double vanDerWaalsRadius) {
        this(name, symbol, protonNumber, (Quantity<MolarMass>)Quantities.getQuantity((Number)atomicWeight, MolarMass.GRAM_PER_MOLE), electronConfiguration);
        this.vanDerWaalsRadius = Quantities.getQuantity((Number)vanDerWaalsRadius, (Unit)UnitProvider.ANGSTROEM);
    }

    public Element(String name, String symbol, int protonNumber, double atomicWeight, String electronConfiguration) {
        this(name, symbol, protonNumber, (Quantity<MolarMass>)Quantities.getQuantity((Number)atomicWeight, MolarMass.GRAM_PER_MOLE), electronConfiguration);
    }

    private Element(Element element, int electronNumber, int neutronNumber) {
        this.name = element.getName();
        this.symbol = element.getSymbol();
        this.protonNumber = element.getProtonNumber();
        this.electronNumber = electronNumber;
        this.valenceElectronNumber = element.valenceElectronNumber;
        this.neutronNumber = neutronNumber;
        this.atomicMass = neutronNumber != this.protonNumber ? Quantities.getQuantity((Number)neutronNumber, MolarMass.GRAM_PER_MOLE) : element.getAtomicMass();
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getProtonNumber() {
        return this.protonNumber;
    }

    public Quantity<MolarMass> getAtomicMass() {
        return this.atomicMass;
    }

    public void setAtomicMass(Quantity<MolarMass> atomicMass) {
        this.atomicMass = atomicMass;
    }

    public int getElectronNumber() {
        return this.electronNumber;
    }

    public int getValenceElectronNumber() {
        return this.valenceElectronNumber;
    }

    public int getNumberOfPotentialBonds() {
        if (this.electronNumber <= 2) {
            return 2 - this.electronNumber;
        }
        if (this.valenceElectronNumber <= 4) {
            return this.valenceElectronNumber;
        }
        return 8 - this.valenceElectronNumber;
    }

    public int getNeutronNumber() {
        return this.neutronNumber;
    }

    public Element asIon(int charge) {
        if (charge != 0) {
            return new Element(this, this.electronNumber + charge, this.neutronNumber);
        }
        return this;
    }

    public Element asCation(int numberOfElectronsLost) {
        return this.asIon(-numberOfElectronsLost);
    }

    public Element asAnion(int numberOfElectronsGained) {
        return this.asIon(numberOfElectronsGained);
    }

    public Element asIsotope(int massNumber) {
        int neutronNumber = massNumber - this.protonNumber;
        if (neutronNumber != this.neutronNumber) {
            return new Element(this, this.electronNumber, neutronNumber);
        }
        return this;
    }

    public boolean isIon() {
        return this.electronNumber != this.protonNumber;
    }

    public boolean isAnion() {
        return this.protonNumber < this.electronNumber;
    }

    public boolean isCation() {
        return this.protonNumber > this.electronNumber;
    }

    public int getCharge() {
        return this.electronNumber - this.protonNumber;
    }

    public int getMassNumber() {
        return this.neutronNumber + this.protonNumber;
    }

    public Quantity<Length> getVanDerWaalsRadius() {
        return this.vanDerWaalsRadius;
    }

    public boolean isIsotope() {
        return this.protonNumber != this.neutronNumber;
    }

    public String toString() {
        return (this.neutronNumber != this.protonNumber ? Integer.valueOf(this.getMassNumber()) : "") + this.symbol + (this.getCharge() != 0 ? Integer.valueOf(this.getCharge()) : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Element element = (Element)o;
        if (this.protonNumber != element.protonNumber) {
            return false;
        }
        if (this.electronNumber != element.electronNumber) {
            return false;
        }
        return this.neutronNumber == element.neutronNumber;
    }

    public int hashCode() {
        int result = this.protonNumber;
        result = 31 * result + this.electronNumber;
        result = 31 * result + this.neutronNumber;
        return result;
    }
}

