/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.elements;

import de.bioforscher.singa.structure.elements.Element;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public final class ElementProvider {
    private static final ElementProvider INSTANCE = new ElementProvider();
    public static final Element HYDROGEN = ElementProvider.addElement(new Element("Hydrogen", "H", 1, 1.008, "1s1", 1.1));
    public static final Element DEUTERIUM = ElementProvider.addElement(new Element("Deuterium", "D", 1, 1.008, "1s1", 1.1)).asIsotope(2);
    public static final Element TRITIUM = ElementProvider.addElement(new Element("Tritium", "T", 1, 1.008, "1s1", 1.1)).asIsotope(3);
    public static final Element HELIUM = ElementProvider.addElement(new Element("Helium", "He", 2, 4.002602, "1s2", 1.4));
    public static final Element LITHIUM = ElementProvider.addElement(new Element("Lithium", "Li", 3, 6.94, "1s2-2s1", 1.82));
    public static final Element BERYLLIUM = ElementProvider.addElement(new Element("Beryllium", "Be", 4, 6.94, "1s2-2s2", 1.53));
    public static final Element BORON = ElementProvider.addElement(new Element("Boron", "B", 5, 9.0121831, "1s2-2s2-2p1", 1.92));
    public static final Element CARBON = ElementProvider.addElement(new Element("Carbon", "C", 6, 12.011, "1s2-2s2-2p2", 1.7));
    public static final Element NITROGEN = ElementProvider.addElement(new Element("Nitrogen", "N", 7, 14.007, "1s2-2s2-2p3", 1.55));
    public static final Element OXYGEN = ElementProvider.addElement(new Element("Oxygen", "O", 8, 15.999, "1s2-2s2-2p4", 1.52));
    public static final Element FLUORINE = ElementProvider.addElement(new Element("Fluorine", "F", 9, 18.998403163, "1s2-2s2-2p5", 1.47));
    public static final Element NEON = ElementProvider.addElement(new Element("Neon", "Ne", 10, 20.1797, "1s2-2s2-2p6", 1.54));
    public static final Element SODIUM = ElementProvider.addElement(new Element("Sodium", "Na", 11, 22.98976928, "1s2-2s2-2p6-3s1", 2.27));
    public static final Element MAGNESIUM = ElementProvider.addElement(new Element("Magnesium", "Mg", 12, 24.305, "1s2-2s2-2p6-3s2", 1.73));
    public static final Element ALUMINIUM = ElementProvider.addElement(new Element("Aluminium", "Al", 13, 26.9815385, "1s2-2s2-2p6-3s2-3p1", 1.84));
    public static final Element SILICON = ElementProvider.addElement(new Element("Silicon", "Si", 14, 28.085, "1s2-2s2-2p6-3s2-3p2", 2.1));
    public static final Element PHOSPHORUS = ElementProvider.addElement(new Element("Phosphorus", "P", 15, 30.973761998, "1s2-2s2-2p6-3s2-3p3", 1.8));
    public static final Element SULFUR = ElementProvider.addElement(new Element("Sulfur", "S", 16, 32.06, "1s2-2s2-2p6-3s2-3p4", 1.8));
    public static final Element CHLORINE = ElementProvider.addElement(new Element("Chlorine", "Cl", 17, 35.45, "1s2-2s2-2p6-3s2-3p5", 1.75));
    public static final Element ARGON = ElementProvider.addElement(new Element("Argon", "Ar", 18, 39.948, "1s2-2s2-2p6-3s2-3p6", 1.88));
    public static final Element POTASSIUM = ElementProvider.addElement(new Element("Potassium", "K", 19, 39.948, "1s2-2s2-2p6-3s2-3p6-4s1", 2.75));
    public static final Element CALCIUM = ElementProvider.addElement(new Element("Calcium", "Ca", 20, 40.078, "1s2-2s2-2p6-3s2-3p6-4s2", 2.31));
    public static final Element SCANDIUM = ElementProvider.addElement(new Element("Scandium", "Sc", 21, 44.9559, "1s2-2s2-2p6-3s2-3p6-3d1-4s2"));
    public static final Element TITANIUM = ElementProvider.addElement(new Element("Titanium", "Ti", 22, 47.867, "1s2-2s2-2p6-3s2-3p6-3d2-4s2"));
    public static final Element VANADIUM = ElementProvider.addElement(new Element("Vanadium", "V", 23, 50.9415, "1s2-2s2-2p6-3s2-3p6-3d3-4s2"));
    public static final Element CHROMIUM = ElementProvider.addElement(new Element("Chromium", "Cr", 24, 51.9961, "1s2-2s2-2p6-3s2-3p6-3d5-4s1"));
    public static final Element MANGANESE = ElementProvider.addElement(new Element("Manganese", "Mg", 25, 54.938, "1s2-2s2-2p6-3s2-3p6-3d5-4s2"));
    public static final Element IRON = ElementProvider.addElement(new Element("Iron", "Fe", 26, 55.845, "1s2-2s2-2p6-3s2-3p6-3d6-4s2"));
    public static final Element COBALT = ElementProvider.addElement(new Element("Cobalt", "Co", 27, 58.6934, "1s2-2s2-2p6-3s2-3p6-3d7-4s2"));
    public static final Element NICKEL = ElementProvider.addElement(new Element("Nickel", "Ni", 28, 58.9332, "1s2-2s2-2p6-3s2-3p6-3d8-4s2", 1.63));
    public static final Element COPPER = ElementProvider.addElement(new Element("Copper", "Cu", 29, 63.546, "1s2-2s2-2p6-3s2-3p6-3d10-4s1", 1.4));
    public static final Element ZINC = ElementProvider.addElement(new Element("Zinc", "Zn", 30, 65.39, "1s2-2s2-2p6-3s2-3p6-3d10-4s2", 1.39));
    public static final Element GALLIUM = ElementProvider.addElement(new Element("Gallium", "Ga", 31, 69.723, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p1", 1.87));
    public static final Element GERMANIUM = ElementProvider.addElement(new Element("Germanium", "Ge", 32, 72.64, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p2", 2.11));
    public static final Element ARSENIC = ElementProvider.addElement(new Element("Arsenic", "As", 33, 74.9216, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p3", 1.85));
    public static final Element SELENIUM = ElementProvider.addElement(new Element("Selenium", "Se", 34, 78.96, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p4", 1.9));
    public static final Element BROMINE = ElementProvider.addElement(new Element("Bromine", "Br", 35, 79.904, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p5", 1.85));
    public static final Element KRYPTON = ElementProvider.addElement(new Element("Krypton", "Kr", 36, 83.8, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6", 2.02));
    public static final Element RUBIDIUM = ElementProvider.addElement(new Element("Rubidium", "Rb", 37, 85.4678, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-5s1", 3.03));
    public static final Element STRONTIUM = ElementProvider.addElement(new Element("Strontium", "Sr", 38, 87.62, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-5s2", 2.49));
    public static final Element YTTRIUM = ElementProvider.addElement(new Element("Yttrium", "Y", 39, 88.9059, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d1-5s2"));
    public static final Element ZIRCONIUM = ElementProvider.addElement(new Element("Zirconium", "Zr", 40, 91.224, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d2-5s2"));
    public static final Element NIOBIUM = ElementProvider.addElement(new Element("Niobium", "Nb", 41, 92.9064, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d4-5s1"));
    public static final Element MOLYBDENUM = ElementProvider.addElement(new Element("Molybdenum", "Mo", 42, 95.94, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d5-5s1"));
    public static final Element TECHNETIUM = ElementProvider.addElement(new Element("Technetium", "Tc", 43, 98.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d5-5s2"));
    public static final Element RUTHENIUM = ElementProvider.addElement(new Element("Ruthenium", "Ru", 44, 101.07, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d7-5s1"));
    public static final Element RHODIUM = ElementProvider.addElement(new Element("Rhodium", "Rh", 45, 102.9055, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d8-5s1"));
    public static final Element PALLADIUM = ElementProvider.addElement(new Element("Palladium", "Pd", 46, 106.42, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10", 1.63));
    public static final Element SILVER = ElementProvider.addElement(new Element("Silver", "Ag", 47, 107.8682, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s1", 1.72));
    public static final Element CADMIUM = ElementProvider.addElement(new Element("Cadmium", "Cd", 48, 112.411, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2", 1.58));
    public static final Element INDIUM = ElementProvider.addElement(new Element("Indium", "In", 49, 114.818, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2-5p1", 1.93));
    public static final Element TIN = ElementProvider.addElement(new Element("Tin", "Sn", 50, 118.71, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2-5p2", 2.17));
    public static final Element ANTIMONY = ElementProvider.addElement(new Element("Antimony", "Sb", 51, 121.76, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2-5p3", 2.06));
    public static final Element TELLURIUM = ElementProvider.addElement(new Element("Tellurium", "Te", 52, 127.6, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2-5p4", 2.06));
    public static final Element IODINE = ElementProvider.addElement(new Element("Iodine", "I", 53, 126.9045, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2-5p5", 1.98));
    public static final Element XENON = ElementProvider.addElement(new Element("Xenon", "Xe", 54, 131.293, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2-5p6", 2.16));
    public static final Element CESIUM = ElementProvider.addElement(new Element("Cesium", "Cs", 55, 132.9055, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2-5p6-6s1", 3.43));
    public static final Element BARIUM = ElementProvider.addElement(new Element("Barium", "Ba", 56, 137.327, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2-5p6-6s2", 2.68));
    public static final Element LANTHANUM = ElementProvider.addElement(new Element("Lanthanum", "La", 57, 138.9055, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-5s2-5p6-5d1-6s2"));
    public static final Element CERIUM = ElementProvider.addElement(new Element("Cerium", "Ce", 58, 140.116, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f1-5s2-5p6-5d1-6s2"));
    public static final Element PRASEODYMIUM = ElementProvider.addElement(new Element("Praseodymium", "Pr", 59, 140.9077, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f3-5s2-5p6-6s2"));
    public static final Element NEODYMIUM = ElementProvider.addElement(new Element("Neodymium", "Nd", 60, 144.24, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f4-5s2-5p6-6s2"));
    public static final Element PROMETHIUM = ElementProvider.addElement(new Element("Promethium", "Pm", 61, 145.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f5-5s2-5p6-6s2"));
    public static final Element SAMARIUM = ElementProvider.addElement(new Element("Samarium", "Sm", 62, 150.36, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f6-5s2-5p6-6s2"));
    public static final Element EUROPIUM = ElementProvider.addElement(new Element("Europium", "Eu", 63, 151.964, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f7-5s2-5p6-6s2"));
    public static final Element GADOLINIUM = ElementProvider.addElement(new Element("Gadolinium", "Gd", 64, 157.25, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f7-5s2-5p6-5d1-6s2"));
    public static final Element TERBIUM = ElementProvider.addElement(new Element("Terbium", "Tb", 65, 158.9253, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f9-5s2-5p6-6s2"));
    public static final Element DYSPROSIUM = ElementProvider.addElement(new Element("Dysprosium", "Dy", 66, 162.5, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f10-5s2-5p6-6s2"));
    public static final Element HOLMIUM = ElementProvider.addElement(new Element("Holmium", "Ho", 67, 164.9303, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f11-5s2-5p6-6s2"));
    public static final Element ERBIUM = ElementProvider.addElement(new Element("Erbium", "Er", 68, 167.259, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f12-5s2-5p6-6s2"));
    public static final Element THULIUM = ElementProvider.addElement(new Element("Thulium", "Tm", 69, 168.9342, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f13-5s2-5p6-6s2"));
    public static final Element YTTERBIUM = ElementProvider.addElement(new Element("Ytterbium", "Yb", 70, 173.04, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-6s2"));
    public static final Element LUTETIUM = ElementProvider.addElement(new Element("Lutetium", "Lu", 71, 174.967, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d1-6s2"));
    public static final Element HAFNIUM = ElementProvider.addElement(new Element("Hafnium", "Hf", 72, 178.49, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d2-6s2"));
    public static final Element TANTALUM = ElementProvider.addElement(new Element("Tantalum", "Ta", 73, 180.9479, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d3-6s2"));
    public static final Element TUNGSTEN = ElementProvider.addElement(new Element("Tungsten", "W", 74, 183.84, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d4-6s2"));
    public static final Element RHENIUM = ElementProvider.addElement(new Element("Rhenium", "Re", 75, 186.207, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d5-6s2"));
    public static final Element OSMIUM = ElementProvider.addElement(new Element("Osmium", "Os", 76, 190.23, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d6-6s2"));
    public static final Element IRIDIUM = ElementProvider.addElement(new Element("Iridium", "Ir", 77, 192.217, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d7-6s2"));
    public static final Element PLATINUM = ElementProvider.addElement(new Element("Platinum", "Pt", 78, 195.078, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d9-6s1", 1.75));
    public static final Element GOLD = ElementProvider.addElement(new Element("Gold", "Au", 79, 196.9665, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s1", 1.66));
    public static final Element MERCURY = ElementProvider.addElement(new Element("Mercury", "Hg", 80, 200.59, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2", 1.55));
    public static final Element THALLIUM = ElementProvider.addElement(new Element("Thallium", "Tl", 81, 204.3833, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p1", 1.96));
    public static final Element LEAD = ElementProvider.addElement(new Element("Lead", "Pb", 82, 207.2, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p2", 2.02));
    public static final Element BISMUTH = ElementProvider.addElement(new Element("Bismuth", "Bi", 83, 208.9804, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p3", 2.07));
    public static final Element POLONIUM = ElementProvider.addElement(new Element("Polonium", "Po", 84, 209.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p4", 1.97));
    public static final Element ASTATINE = ElementProvider.addElement(new Element("Astatine", "A ", 85, 210.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p5", 2.02));
    public static final Element RADON = ElementProvider.addElement(new Element("Radon", "Rn", 86, 222.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p6", 2.2));
    public static final Element FRANCIUM = ElementProvider.addElement(new Element("Francium", "Fr", 87, 223.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p6-7s1", 3.48));
    public static final Element RADIUM = ElementProvider.addElement(new Element("Radium", "Ra", 88, 226.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p6-7s2", 22.83));
    public static final Element ACTINIUM = ElementProvider.addElement(new Element("Actinium", "Ac", 89, 227.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p6-6d1-7s2"));
    public static final Element THORIUM = ElementProvider.addElement(new Element("Thorium", "Th", 90, 232.0381, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-6s2-6p6-6d2-7s2"));
    public static final Element PROTACTINIUM = ElementProvider.addElement(new Element("Protactinium", "Pa", 91, 231.0359, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f2-6s2-6p6-6d1-7s2"));
    public static final Element URANIUM = ElementProvider.addElement(new Element("Uranium", "U", 92, 238.0289, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f3-6s2-6p6-6d1-7s2"));
    public static final Element NEPTUNIUM = ElementProvider.addElement(new Element("Neptunium", "Np", 93, 237.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f4-6s2-6p6-6d1-7s2"));
    public static final Element PLUTONIUM = ElementProvider.addElement(new Element("Plutonium", "Pu", 94, 244.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f6-6s2-6p6-7s2"));
    public static final Element AMERICIUM = ElementProvider.addElement(new Element("Americium", "Am", 95, 243.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f7-6s2-6p6-7s2"));
    public static final Element CURIUM = ElementProvider.addElement(new Element("Curium", "Cm", 96, 247.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f7-6s2-6p6-6d1-7s2"));
    public static final Element BERKELIUM = ElementProvider.addElement(new Element("Berkelium", "Bk", 97, 247.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f9-6s2-6p6-7s2"));
    public static final Element CALIFORNIUM = ElementProvider.addElement(new Element("Californium", "Cf", 98, 251.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f10-6s2-6p6-7s2"));
    public static final Element EINSTEINIUM = ElementProvider.addElement(new Element("Einsteinium", "Es", 99, 252.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f11-6s2-6p6-7s2"));
    public static final Element FERMIUM = ElementProvider.addElement(new Element("Fermium", "Fm", 100, 257.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f12-6s2-6p6-7s2"));
    public static final Element MENDELEVIUM = ElementProvider.addElement(new Element("Mendelevium", "Md", 101, 258.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f13-6s2-6p6-7s2"));
    public static final Element NOBELIUM = ElementProvider.addElement(new Element("Nobelium", "No", 102, 259.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f14-6s2-6p6-7s2"));
    public static final Element LAWRENCIUM = ElementProvider.addElement(new Element("Lawrencium", "Lr", 103, 262.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f14-6s2-6p6-7s2-7p1"));
    public static final Element RUTHERFORDIUM = ElementProvider.addElement(new Element("Rutherfordium", "Rf", 104, 261.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f14-6s2-6p6-6d2-7s2"));
    public static final Element DUBNIUM = ElementProvider.addElement(new Element("Dubnium", "Db", 105, 262.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f14-6s2-6p6-6d3-7s2"));
    public static final Element SEABORGIUM = ElementProvider.addElement(new Element("Seaborgium", "Sg", 106, 266.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f14-6s2-6p6-6d4-7s2"));
    public static final Element BOHRIUM = ElementProvider.addElement(new Element("Bohrium", "Bh", 107, 264.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f14-6s2-6p6-6d5-7s2"));
    public static final Element HASSIUM = ElementProvider.addElement(new Element("Hassium", "Hs", 108, 277.0, "1s2-2s2-2p6-3s2-3p6-3d10-4s2-4p6-4d10-4f14-5s2-5p6-5d10-5f14-6s2-6p6-6d6-7s2"));
    public static final Element UNKOWN = ElementProvider.addElement(new Element("Unkown", "X", 0, 0.0, "1s0"));
    private final Set<Element> elements = new HashSet<Element>();

    private static Element addElement(Element element) {
        ElementProvider.INSTANCE.elements.add(element);
        return element;
    }

    public static Optional<Element> getElementBySymbol(String symbol) {
        return ElementProvider.INSTANCE.elements.stream().filter(element -> element.getSymbol().equalsIgnoreCase(symbol)).findAny();
    }

    public static Set<Element> getElements() {
        return Collections.unmodifiableSet(ElementProvider.INSTANCE.elements);
    }
}

