/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.families;

import de.bioforscher.singa.core.utility.Resources;
import de.bioforscher.singa.structure.model.families.StructuralFamily;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.oak.AtomName;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParser;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public enum AminoAcidFamily implements StructuralFamily<AminoAcidFamily>
{
    ALANINE("Alanine", "A", "Ala", AtomName.ALANINE_ATOM_NAMES),
    ARGININE("Arginine", "R", "Arg", AtomName.ARGININE_ATOM_NAMES),
    ASPARAGINE("Asparagine", "N", "Asn", AtomName.ASPARAGINE_ATOM_NAMES),
    ASPARTIC_ACID("Aspartic acid", "D", "Asp", AtomName.ASPARTIC_ACID_ATOM_NAMES),
    CYSTEINE("Cysteine", "C", "Cys", AtomName.CYSTEINE_ATOM_NAMES),
    GLUTAMINE("Glutamine", "Q", "Gln", AtomName.GLUTAMINE_ATOM_NAMES),
    GLUTAMIC_ACID("Glutamic acid", "E", "Glu", AtomName.GLUTAMIC_ACID_ATOM_NAMES),
    GLYCINE("Glycine", "G", "Gly", AtomName.GLYCINE_ATOM_NAMES),
    HISTIDINE("Histidine", "H", "His", AtomName.HISTIDINE_ATOM_NAMES),
    ISOLEUCINE("Isoleucine", "I", "Ile", AtomName.ISOLEUCINE_ATOM_NAMES),
    LEUCINE("Leucine", "L", "Leu", AtomName.LEUCINE_ATOM_NAMES),
    LYSINE("Lysine", "K", "Lys", AtomName.LYSINE_ATOM_NAMES),
    METHIONINE("Methionine", "M", "Met", AtomName.METHIONINE_ATOM_NAMES),
    PHENYLALANINE("Phenylalanine", "F", "Phe", AtomName.PHENYLALANINE_ATOM_NAMES),
    PROLINE("Proline", "P", "Pro", AtomName.PROLINE_ATOM_NAMES),
    SERINE("Serine", "S", "Ser", AtomName.SERINE_ATOM_NAMES),
    THREONINE("Threonine", "T", "Thr", AtomName.THREONINE_ATOM_NAMES),
    TRYPTOPHAN("Tryptophan", "W", "Trp", AtomName.TRYPTOPHAN_ATOM_NAMES),
    TYROSINE("Tyrosine", "Y", "Tyr", AtomName.TYROSINE_ATOM_NAMES),
    VALINE("Valine", "V", "Val", AtomName.VALINE_ATOM_NAMES),
    UNKNOWN("Unknown", "X", "Unk", AtomName.UNKNOWN_ATOM_NAMES),
    GAP("Gap", "-", "Gap", AtomName.UNKNOWN_ATOM_NAMES);

    private static final String RESIDUE_PROTOTYPES_BASE_DIR = "de/bioforscher/singa/structure/leaves/prototypes/";
    private final String name;
    private final String oneLetterCode;
    private final String threeLetterCode;
    private final EnumSet<AtomName> allowedAtoms;

    private AminoAcidFamily(String name, String oneLetterCode, String threeLetterCode, EnumSet<AtomName> allowedAtoms) {
        this.name = name;
        this.oneLetterCode = oneLetterCode;
        this.threeLetterCode = threeLetterCode;
        this.allowedAtoms = allowedAtoms;
    }

    public static Optional<AminoAcidFamily> getAminoAcidTypeByThreeLetterCode(String threeLetterCode) {
        return Arrays.stream(AminoAcidFamily.values()).filter(type -> threeLetterCode.equalsIgnoreCase(type.getThreeLetterCode())).findAny();
    }

    public static Optional<AminoAcidFamily> getAminoAcidTypeByOneLetterCode(char oneLetterCode) {
        return AminoAcidFamily.getAminoAcidTypeByOneLetterCode(String.valueOf(oneLetterCode));
    }

    public static Optional<AminoAcidFamily> getAminoAcidTypeByOneLetterCode(String oneLetterCode) {
        return Arrays.stream(AminoAcidFamily.values()).filter(type -> oneLetterCode.equalsIgnoreCase(type.getOneLetterCode())).findAny();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getOneLetterCode() {
        return this.oneLetterCode;
    }

    @Override
    public String getThreeLetterCode() {
        return this.threeLetterCode;
    }

    public EnumSet<AtomName> getAllowedAtoms() {
        return this.allowedAtoms;
    }

    public boolean containsExpectedAtoms(List<Atom> atoms, AminoAcidFamily aminoAcidFamily) {
        Set actualNames = atoms.stream().map(Atom::getAtomName).collect(Collectors.toSet());
        Set expectedNames = aminoAcidFamily.getAllowedAtoms().stream().map(AtomName::getName).collect(Collectors.toSet());
        return expectedNames.containsAll(actualNames);
    }

    public AminoAcid getPrototype() {
        return StructureParser.local().inputStream(Resources.getResourceAsStream((String)(RESIDUE_PROTOTYPES_BASE_DIR + this.getName().replaceAll(" ", "_").toLowerCase() + ".pdb"))).parse().getAllAminoAcids().get(0);
    }
}

