/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.families;

import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.families.StructuralFamily;
import java.util.EnumSet;

public enum MatcherFamily implements StructuralFamily<MatcherFamily>
{
    ALL(EnumSet.allOf(AminoAcidFamily.class), "*", "ALL"),
    GUTTERIDGE_IMIDAZOLE(EnumSet.of(AminoAcidFamily.HISTIDINE), "i", "IMI"),
    GUTTERIDGE_AMINE(EnumSet.of(AminoAcidFamily.LYSINE), "n", "AMN"),
    GUTTERIDGE_CARBOXYLATE(EnumSet.of(AminoAcidFamily.ASPARTIC_ACID, AminoAcidFamily.GLUTAMIC_ACID), "n", "AMN"),
    GUTTERIDGE_AMIDE(EnumSet.of(AminoAcidFamily.ASPARAGINE, AminoAcidFamily.GLUTAMINE), "d", "AMD"),
    GUTTERIDGE_HYDROXYL(EnumSet.of(AminoAcidFamily.SERINE, AminoAcidFamily.THREONINE, AminoAcidFamily.TYROSINE), "h", "HYD"),
    GUTTERIDGE_THIOL(EnumSet.of(AminoAcidFamily.CYSTEINE), "t", "THI"),
    GUTTERIDGE_GUANIDIUM(EnumSet.of(AminoAcidFamily.ARGININE), "g", "GND"),
    GUTTERIDGE_OTHERS(EnumSet.of(AminoAcidFamily.ALANINE, new AminoAcidFamily[]{AminoAcidFamily.GLYCINE, AminoAcidFamily.ISOLEUCINE, AminoAcidFamily.LEUCINE, AminoAcidFamily.METHIONINE, AminoAcidFamily.PHENYLALANINE, AminoAcidFamily.PROLINE, AminoAcidFamily.TRYPTOPHAN, AminoAcidFamily.VALINE}), "o", "OTH"),
    FUNCTIONAL_AROMATIC(EnumSet.of(AminoAcidFamily.PHENYLALANINE, AminoAcidFamily.TYROSINE, AminoAcidFamily.TRYPTOPHAN), "a", "ARO"),
    FUNCTIONAL_NEGATIVE(EnumSet.of(AminoAcidFamily.ASPARTIC_ACID, AminoAcidFamily.GLUTAMIC_ACID), "e", "NEG"),
    FUNCTIONAL_POSITIVE(EnumSet.of(AminoAcidFamily.LYSINE, AminoAcidFamily.ARGININE, AminoAcidFamily.HISTIDINE), "p", "POS"),
    FUNCTIONAL_POLAR(EnumSet.of(AminoAcidFamily.PROLINE, new AminoAcidFamily[]{AminoAcidFamily.ASPARAGINE, AminoAcidFamily.GLUTAMINE, AminoAcidFamily.CYSTEINE, AminoAcidFamily.THREONINE, AminoAcidFamily.SERINE}), "p", "POL"),
    FUNCTIONAL_UNPOLAR(EnumSet.of(AminoAcidFamily.GLYCINE, new AminoAcidFamily[]{AminoAcidFamily.ALANINE, AminoAcidFamily.VALINE, AminoAcidFamily.LEUCINE, AminoAcidFamily.METHIONINE, AminoAcidFamily.ISOLEUCINE}), "u", "UPO");

    public static final EnumSet<MatcherFamily> GUTTERIDGE;
    public static EnumSet<MatcherFamily> FUNCTIONAL;
    public static EnumSet<MatcherFamily> ALL_AMINO_ACIDS;
    private final EnumSet<AminoAcidFamily> members;
    private final String oneLetterCode;
    private final String threeLetterCode;

    private MatcherFamily(EnumSet<AminoAcidFamily> members, String oneLetterCode, String threeLetterCode) {
        this.members = members;
        this.oneLetterCode = oneLetterCode;
        this.threeLetterCode = threeLetterCode;
    }

    public EnumSet<AminoAcidFamily> getMembers() {
        return this.members;
    }

    @Override
    public String getOneLetterCode() {
        return this.oneLetterCode;
    }

    @Override
    public String getThreeLetterCode() {
        return this.threeLetterCode;
    }

    static {
        GUTTERIDGE = EnumSet.of(GUTTERIDGE_AMIDE, new MatcherFamily[]{GUTTERIDGE_AMINE, GUTTERIDGE_CARBOXYLATE, GUTTERIDGE_GUANIDIUM, GUTTERIDGE_HYDROXYL, GUTTERIDGE_IMIDAZOLE, GUTTERIDGE_OTHERS, GUTTERIDGE_THIOL});
        FUNCTIONAL = EnumSet.of(FUNCTIONAL_AROMATIC, FUNCTIONAL_NEGATIVE, FUNCTIONAL_POSITIVE, FUNCTIONAL_POLAR, FUNCTIONAL_UNPOLAR);
        ALL_AMINO_ACIDS = EnumSet.of(ALL);
    }
}

