/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.families;

import de.bioforscher.singa.structure.model.families.StructuralFamily;
import java.util.Arrays;
import java.util.Optional;

public enum NucleotideFamily implements StructuralFamily<NucleotideFamily>
{
    ADENOSINE("A", "A"),
    DESOXYADENOSINE("A", "dA"),
    GUANOSINE("G", "G"),
    DESOXYGUANOSINE("G", "dG"),
    THYMIDINE("T", "T"),
    DESOXYTHYMIDINE("T", "dT"),
    URIDINE("U", "U"),
    DESOXYURIDINE("U", "dU"),
    CYTIDINE("C", "C"),
    DESOXYCYTIDINE("C", "dC"),
    UNKNOWN("X", "UNK");

    private final String oneLetterCode;
    private final String threeLetterCode;

    private NucleotideFamily(String oneLetterCode, String threeLetterCode) {
        this.oneLetterCode = oneLetterCode;
        this.threeLetterCode = threeLetterCode;
    }

    public static Optional<NucleotideFamily> getNucleotideByThreeLetterCode(String threeLetterCode) {
        return Arrays.stream(NucleotideFamily.values()).filter(type -> threeLetterCode.trim().equalsIgnoreCase(type.getThreeLetterCode())).findAny();
    }

    public static Optional<NucleotideFamily> getNucleotide(char nucleotide) {
        switch (nucleotide) {
            case 'A': 
            case 'a': {
                return Optional.of(ADENOSINE);
            }
            case 'C': 
            case 'c': {
                return Optional.of(CYTIDINE);
            }
            case 'G': 
            case 'g': {
                return Optional.of(GUANOSINE);
            }
            case 'T': 
            case 't': {
                return Optional.of(THYMIDINE);
            }
            case 'U': 
            case 'u': {
                return Optional.of(DESOXYURIDINE);
            }
        }
        return Optional.empty();
    }

    @Override
    public String getOneLetterCode() {
        return this.oneLetterCode;
    }

    @Override
    public String getThreeLetterCode() {
        return this.threeLetterCode;
    }
}

