/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.identifiers;

import java.util.Comparator;

public class LeafIdentifier
implements Comparable<LeafIdentifier> {
    public static final String DEFAULT_PDB_IDENTIFIER = "0000";
    public static final int DEFAULT_MODEL_IDENTIFIER = 1;
    public static final String DEFAULT_CHAIN_IDENTIFIER = "X";
    public static final char DEFAULT_INSERTION_CODE = '\u0000';
    public static final char DEFAULT_ALTERNATIVE_POSITION_CODE = '\u0000';
    public static final LeafIdentifier DEFAULT_LEAF_IDENTIFIER = new LeafIdentifier(1);
    private static final Comparator<LeafIdentifier> leafIdentiferComparator = Comparator.comparing(LeafIdentifier::getPdbIdentifier).thenComparing(LeafIdentifier::getModelIdentifier).thenComparing(LeafIdentifier::getChainIdentifier).thenComparing(LeafIdentifier::getSerial).thenComparing(LeafIdentifier::getInsertionCode);
    private final String pdbIdentifer;
    private final int modelIdentifer;
    private final String chainIdentifer;
    private final int serial;
    private final char insertionCode;

    public LeafIdentifier(String pdbIdentifer, int modelIdentifer, String chainIdentifer, int serial, char insertionCode) {
        this.pdbIdentifer = pdbIdentifer.toLowerCase();
        this.modelIdentifer = modelIdentifer;
        this.chainIdentifer = chainIdentifer.toUpperCase();
        this.serial = serial;
        this.insertionCode = insertionCode;
    }

    public LeafIdentifier(String pdbIdentifer, int modelIdentifer, String chainIdentifer, int serial) {
        this(pdbIdentifer, modelIdentifer, chainIdentifer, serial, '\u0000');
    }

    public LeafIdentifier(String chainIdentifier, int serial, char insertionCode) {
        this(DEFAULT_PDB_IDENTIFIER, 1, chainIdentifier, serial, insertionCode);
    }

    public LeafIdentifier(String chainIdentifer, int serial) {
        this(DEFAULT_PDB_IDENTIFIER, 1, chainIdentifer, serial);
    }

    public LeafIdentifier(int serial) {
        this(DEFAULT_PDB_IDENTIFIER, 1, DEFAULT_CHAIN_IDENTIFIER, serial);
    }

    public static LeafIdentifier fromSimpleString(String simpleString) {
        String[] split = simpleString.split("-");
        String firstPart = split[0];
        String secondPart = split[1];
        if (secondPart.substring(secondPart.length() - 1).matches("[A-Z]")) {
            char insertionCode = secondPart.charAt(secondPart.length() - 1);
            return new LeafIdentifier(firstPart, Integer.valueOf(secondPart.substring(0, secondPart.length() - 1)), insertionCode);
        }
        return new LeafIdentifier(firstPart, Integer.valueOf(secondPart));
    }

    public String getPdbIdentifier() {
        return this.pdbIdentifer;
    }

    public int getModelIdentifier() {
        return this.modelIdentifer;
    }

    public String getChainIdentifier() {
        return this.chainIdentifer;
    }

    public int getSerial() {
        return this.serial;
    }

    public char getInsertionCode() {
        return this.insertionCode;
    }

    @Override
    public int compareTo(LeafIdentifier o) {
        return leafIdentiferComparator.compare(this, o);
    }

    public String toString() {
        return this.pdbIdentifer + "-" + this.modelIdentifer + "-" + this.chainIdentifer + "-" + this.serial + (this.insertionCode != '\u0000' ? Character.valueOf(this.insertionCode) : "");
    }

    public String toSimpleString() {
        return this.chainIdentifer + "-" + this.serial + (this.insertionCode != '\u0000' ? Character.valueOf(this.insertionCode) : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafIdentifier that = (LeafIdentifier)o;
        if (this.serial != that.serial) {
            return false;
        }
        if (this.modelIdentifer != that.modelIdentifer) {
            return false;
        }
        if (this.insertionCode != that.insertionCode) {
            return false;
        }
        if (this.pdbIdentifer != null ? !this.pdbIdentifer.equals(that.pdbIdentifer) : that.pdbIdentifer != null) {
            return false;
        }
        return this.chainIdentifer != null ? this.chainIdentifer.equals(that.chainIdentifer) : that.chainIdentifer == null;
    }

    public int hashCode() {
        int result = this.pdbIdentifer != null ? this.pdbIdentifer.hashCode() : 0;
        result = 31 * result + this.modelIdentifer;
        result = 31 * result + (this.chainIdentifer != null ? this.chainIdentifer.hashCode() : 0);
        result = 31 * result + this.serial;
        result = 31 * result + this.insertionCode;
        return result;
    }
}

