/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.interfaces;

import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import de.bioforscher.singa.structure.model.families.StructuralFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.AtomContainer;
import de.bioforscher.singa.structure.model.oak.Exchangeable;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.AtomToken;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface LeafSubstructure<FamilyType extends StructuralFamily>
extends AtomContainer,
Exchangeable<FamilyType> {
    public LeafIdentifier getIdentifier();

    default public String getPdbIdentifier() {
        return this.getIdentifier().getPdbIdentifier();
    }

    default public Integer getModelIdentifier() {
        return this.getIdentifier().getModelIdentifier();
    }

    default public String getChainIdentifier() {
        return this.getIdentifier().getChainIdentifier();
    }

    default public Integer getSerial() {
        return this.getIdentifier().getSerial();
    }

    default public char getInsertionCode() {
        return this.getIdentifier().getInsertionCode();
    }

    default public Vector3D getPosition() {
        return Vectors3D.getCentroid((Collection)this.getAllAtoms().stream().map(Atom::getPosition).collect(Collectors.toList()));
    }

    default public List<String> getPdbLines() {
        return AtomToken.assemblePDBLine(this);
    }

    public boolean containsAtomWithName(String var1);

    public Optional<Atom> getAtomByName(String var1);

    public boolean isAnnotatedAsHeteroAtom();

    public String getThreeLetterCode();

    public <LeafImplementation extends LeafSubstructure> LeafImplementation getCopy();

    default public String flatToString() {
        return this.getIdentifier() + " " + this.getThreeLetterCode();
    }
}

