/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.interfaces;

import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.AtomContainer;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.Ligand;
import de.bioforscher.singa.structure.model.interfaces.Nucleotide;
import de.bioforscher.singa.structure.model.oak.Exchangeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface LeafSubstructureContainer
extends AtomContainer {
    public List<LeafSubstructure<?>> getAllLeafSubstructures();

    public Optional<LeafSubstructure<?>> getLeafSubstructure(LeafIdentifier var1);

    public LeafSubstructure<?> getFirstLeafSubstructure();

    public boolean removeLeafSubstructure(LeafIdentifier var1);

    default public boolean removeLeafSubstructure(LeafSubstructure leafSubstructure) {
        return this.removeLeafSubstructure(leafSubstructure.getIdentifier());
    }

    default public void removeLeafSubstructuresNotRelevantFor(LeafSubstructureContainer leafSubstructuresToKeep) {
        Set containingTypes = leafSubstructuresToKeep.getAllLeafSubstructures().stream().map(Exchangeable::getContainingFamilies).flatMap(Collection::stream).collect(Collectors.toSet());
        List<LeafSubstructure> toBeRemoved = this.getAllLeafSubstructures().stream().filter(leafSubstructure -> !containingTypes.contains(leafSubstructure.getFamily())).collect(Collectors.toList());
        toBeRemoved.forEach(this::removeLeafSubstructure);
    }

    default public int getNumberOfLeafSubstructures() {
        return this.getAllLeafSubstructures().size();
    }

    default public List<AminoAcid> getAllAminoAcids() {
        ArrayList<AminoAcid> aminoAcids = new ArrayList<AminoAcid>();
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            if (!(leafSubstructure instanceof AminoAcid)) continue;
            aminoAcids.add((AminoAcid)leafSubstructure);
        }
        return aminoAcids;
    }

    default public Optional<AminoAcid> getAminoAcid(LeafIdentifier leafIdentifier) {
        Optional<LeafSubstructure<?>> leafSubstructureOptional = this.getLeafSubstructure(leafIdentifier);
        if (!leafSubstructureOptional.isPresent()) {
            return Optional.empty();
        }
        LeafSubstructure<?> leafSubstructure = leafSubstructureOptional.get();
        if (!(leafSubstructure instanceof AminoAcid)) {
            return Optional.empty();
        }
        return Optional.of((AminoAcid)leafSubstructure);
    }

    default public List<Nucleotide> getAllNucleotides() {
        ArrayList<Nucleotide> nucleotides = new ArrayList<Nucleotide>();
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            if (!(leafSubstructure instanceof Nucleotide)) continue;
            nucleotides.add((Nucleotide)leafSubstructure);
        }
        return nucleotides;
    }

    default public Optional<Nucleotide> getNucleotide(LeafIdentifier leafIdentifier) {
        Optional<LeafSubstructure<?>> leafSubstructureOptional = this.getLeafSubstructure(leafIdentifier);
        if (!leafSubstructureOptional.isPresent()) {
            return Optional.empty();
        }
        LeafSubstructure<?> leafSubstructure = leafSubstructureOptional.get();
        if (!(leafSubstructure instanceof Nucleotide)) {
            return Optional.empty();
        }
        return Optional.of((Nucleotide)leafSubstructure);
    }

    default public List<Ligand> getAllLigands() {
        ArrayList<Ligand> ligands = new ArrayList<Ligand>();
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            if (!(leafSubstructure instanceof Ligand)) continue;
            ligands.add((Ligand)leafSubstructure);
        }
        return ligands;
    }

    default public Optional<Ligand> getLigand(LeafIdentifier leafIdentifier) {
        Optional<LeafSubstructure<?>> leafSubstructureOptional = this.getLeafSubstructure(leafIdentifier);
        if (!leafSubstructureOptional.isPresent()) {
            return Optional.empty();
        }
        LeafSubstructure<?> leafSubstructure = leafSubstructureOptional.get();
        if (!(leafSubstructure instanceof Ligand)) {
            return Optional.empty();
        }
        return Optional.of((Ligand)leafSubstructure);
    }

    @Override
    default public List<Atom> getAllAtoms() {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        List<LeafSubstructure<?>> allLeafSubstructures = this.getAllLeafSubstructures();
        for (LeafSubstructure<?> leafSubstructure : allLeafSubstructures) {
            atoms.addAll(leafSubstructure.getAllAtoms());
        }
        return atoms;
    }

    default public Optional<Atom> getAtom(int atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
            if (!optionalAtom.isPresent()) continue;
            return optionalAtom;
        }
        return Optional.empty();
    }

    public <ContainerType extends LeafSubstructureContainer> ContainerType getCopy();
}

