/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.mmtf;

import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.structure.elements.Element;
import de.bioforscher.singa.structure.elements.ElementProvider;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import org.rcsb.mmtf.api.StructureDataInterface;

public class MmtfAtom
implements Atom {
    private final StructureDataInterface data;
    private final int internalGroupIndex;
    private final int groupPositionIndex;
    private final int internalAtomIndex;
    private Vector3D cachedPosition;

    MmtfAtom(StructureDataInterface data, int internalGroupIndex, int groupPositionIndex, int internalAtomIndex) {
        this.data = data;
        this.internalGroupIndex = internalGroupIndex;
        this.internalAtomIndex = internalAtomIndex;
        this.groupPositionIndex = groupPositionIndex;
    }

    public MmtfAtom(MmtfAtom mmtfAtom) {
        this.data = mmtfAtom.data;
        this.internalGroupIndex = mmtfAtom.internalGroupIndex;
        this.internalAtomIndex = mmtfAtom.internalAtomIndex;
        this.groupPositionIndex = mmtfAtom.groupPositionIndex;
        this.cachedPosition = mmtfAtom.cachedPosition;
    }

    @Override
    public Integer getAtomIdentifier() {
        return this.internalAtomIndex + 1;
    }

    @Override
    public String getAtomName() {
        return this.data.getGroupAtomNames(this.data.getGroupTypeIndices()[this.internalGroupIndex])[this.groupPositionIndex];
    }

    @Override
    public Vector3D getPosition() {
        if (this.cachedPosition == null) {
            this.cachedPosition = new Vector3D((double)this.data.getxCoords()[this.internalAtomIndex], (double)this.data.getyCoords()[this.internalAtomIndex], (double)this.data.getzCoords()[this.internalAtomIndex]);
        }
        return this.cachedPosition;
    }

    @Override
    public void setPosition(Vector3D position) {
        this.cachedPosition = position;
    }

    @Override
    public Element getElement() {
        return ElementProvider.getElementBySymbol(this.data.getGroupElementNames(this.data.getGroupTypeIndices()[this.internalGroupIndex])[this.groupPositionIndex]).orElse(ElementProvider.UNKOWN);
    }

    @Override
    public Atom getCopy() {
        return new MmtfAtom(this);
    }

    public String toString() {
        return this.flatToString();
    }
}

