/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.mmtf;

import de.bioforscher.singa.core.utility.Range;
import de.bioforscher.singa.structure.model.families.StructuralFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.mmtf.MmtfLeafFactory;
import de.bioforscher.singa.structure.model.mmtf.MmtfLeafSubstructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.rcsb.mmtf.api.StructureDataInterface;

public class MmtfChain
implements Chain {
    private final byte[] bytes;
    private final StructureDataInterface data;
    private final String chainIdentifier;
    private final Map<Integer, MmtfLeafSubstructure<?>> cachedLeaves;
    private final List<Integer> relevantGroups;
    private final Map<Integer, LeafIdentifier> leafIdentifiers;
    private final Map<Integer, Range<Integer>> atomRanges;

    MmtfChain(StructureDataInterface data, byte[] bytes, String chainIdentifier, List<Integer> internalChainIndices, int modelIndex) {
        this.data = data;
        this.bytes = bytes;
        this.chainIdentifier = chainIdentifier;
        this.relevantGroups = new ArrayList<Integer>();
        this.leafIdentifiers = new HashMap<Integer, LeafIdentifier>();
        this.atomRanges = new HashMap<Integer, Range<Integer>>();
        this.cachedLeaves = new HashMap();
        int[] groupsPerChain = data.getGroupsPerChain();
        int currentGroupIndex = 0;
        for (int groupsPerChainIndex = 0; groupsPerChainIndex < groupsPerChain.length; ++groupsPerChainIndex) {
            int endRange = currentGroupIndex + groupsPerChain[groupsPerChainIndex];
            if (internalChainIndices.contains(groupsPerChainIndex)) {
                for (int groupIndex = currentGroupIndex; groupIndex <= endRange - 1; ++groupIndex) {
                    this.relevantGroups.add(groupIndex);
                    this.leafIdentifiers.put(groupIndex, new LeafIdentifier(data.getStructureId(), modelIndex + 1, chainIdentifier, data.getGroupIds()[groupIndex], data.getInsCodes()[groupIndex]));
                }
            }
            currentGroupIndex = endRange;
        }
        int currentAtomIndex = 0;
        for (int groupIndex = 0; groupIndex < data.getNumGroups(); ++groupIndex) {
            int lastAtom = currentAtomIndex + data.getNumAtomsInGroup(data.getGroupTypeIndices()[groupIndex]);
            if (this.relevantGroups.contains(groupIndex)) {
                this.atomRanges.put(groupIndex, (Range<Integer>)new Range((Comparable)Integer.valueOf(currentAtomIndex), (Comparable)Integer.valueOf(lastAtom - 1)));
            }
            currentAtomIndex = lastAtom;
        }
    }

    private MmtfChain(MmtfChain mmtfChain) {
        this.bytes = mmtfChain.bytes;
        this.data = mmtfChain.data;
        this.chainIdentifier = mmtfChain.chainIdentifier;
        this.cachedLeaves = new HashMap(mmtfChain.cachedLeaves);
        this.relevantGroups = new ArrayList<Integer>(mmtfChain.relevantGroups);
        this.leafIdentifiers = new HashMap<Integer, LeafIdentifier>(mmtfChain.leafIdentifiers);
        this.atomRanges = new HashMap<Integer, Range<Integer>>(mmtfChain.atomRanges);
    }

    @Override
    public String getChainIdentifier() {
        return this.chainIdentifier;
    }

    @Override
    public List<LeafSubstructure<?>> getAllLeafSubstructures() {
        ArrayList results = new ArrayList();
        for (Integer relevantGroup : this.relevantGroups) {
            if (this.cachedLeaves.containsKey(relevantGroup)) {
                results.add(this.cachedLeaves.get(relevantGroup));
                continue;
            }
            Range<Integer> atomRange = this.atomRanges.get(relevantGroup);
            MmtfLeafSubstructure<?> leaf = MmtfLeafFactory.createLeaf(this.data, this.bytes, this.leafIdentifiers.get(relevantGroup), relevantGroup, (Integer)atomRange.getLowerBound(), (Integer)atomRange.getUpperBound());
            this.cachedLeaves.put(relevantGroup, leaf);
            results.add(leaf);
        }
        return results;
    }

    @Override
    public Optional<LeafSubstructure<?>> getLeafSubstructure(LeafIdentifier leafIdentifier) {
        int internalIndex = this.getInternalIndexForLeafIdentifier(leafIdentifier);
        if (internalIndex == -1) {
            return Optional.empty();
        }
        if (this.cachedLeaves.containsKey(internalIndex)) {
            return Optional.of(this.cachedLeaves.get(internalIndex));
        }
        Range<Integer> atomRange = this.atomRanges.get(internalIndex);
        MmtfLeafSubstructure<?> leaf = MmtfLeafFactory.createLeaf(this.data, this.bytes, this.leafIdentifiers.get(internalIndex), internalIndex, (Integer)atomRange.getLowerBound(), (Integer)atomRange.getUpperBound());
        this.cachedLeaves.put(internalIndex, leaf);
        return Optional.of(leaf);
    }

    @Override
    public LeafSubstructure<?> getFirstLeafSubstructure() {
        return this.getLeafSubstructure(this.leafIdentifiers.values().iterator().next()).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public boolean removeLeafSubstructure(LeafIdentifier leafIdentifier) {
        int internalIndex = this.getInternalIndexForLeafIdentifier(leafIdentifier);
        if (internalIndex == -1) {
            return false;
        }
        this.leafIdentifiers.remove(internalIndex);
        this.cachedLeaves.remove(internalIndex);
        this.relevantGroups.remove((Object)internalIndex);
        this.atomRanges.remove(internalIndex);
        return true;
    }

    @Override
    public void removeLeafSubstructuresNotRelevantFor(LeafSubstructureContainer leafSubstructuresToKeep) {
        HashSet<String> relevantFamilies = new HashSet<String>();
        for (LeafSubstructure<?> leafSubstructure : leafSubstructuresToKeep.getAllLeafSubstructures()) {
            relevantFamilies.add(leafSubstructure.getFamily().getThreeLetterCode().toUpperCase());
            for (StructuralFamily structuralFamily : leafSubstructure.getExchangeableFamilies()) {
                relevantFamilies.add(structuralFamily.getThreeLetterCode().toUpperCase());
            }
        }
        ListIterator<Integer> relevantGroupIterator = this.relevantGroups.listIterator();
        while (relevantGroupIterator.hasNext()) {
            int internalIndex = relevantGroupIterator.next();
            String groupFamily = this.data.getGroupName(this.data.getGroupTypeIndices()[internalIndex]);
            if (relevantFamilies.contains(groupFamily)) continue;
            this.leafIdentifiers.remove(internalIndex);
            this.atomRanges.remove(internalIndex);
            relevantGroupIterator.remove();
        }
    }

    @Override
    public int getNumberOfLeafSubstructures() {
        return this.leafIdentifiers.size();
    }

    private int getInternalIndexForLeafIdentifier(LeafIdentifier leafIdentifier) {
        for (Map.Entry<Integer, LeafIdentifier> leafIdentifierEntry : this.leafIdentifiers.entrySet()) {
            if (!leafIdentifierEntry.getValue().equals(leafIdentifier)) continue;
            return leafIdentifierEntry.getKey();
        }
        return -1;
    }

    @Override
    public Optional<Atom> getAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            Optional<Atom> atomOptional = leafSubstructure.getAtom(atomIdentifier);
            if (!atomOptional.isPresent()) continue;
            return atomOptional;
        }
        return Optional.empty();
    }

    @Override
    public void removeAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            Optional<Atom> atomOptional = leafSubstructure.getAtom(atomIdentifier);
            atomOptional.ifPresent(atom -> leafSubstructure.removeAtom(atomIdentifier));
        }
    }

    @Override
    public Chain getCopy() {
        return new MmtfChain(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MmtfChain mmtfChain = (MmtfChain)o;
        return Objects.equals(this.chainIdentifier, mmtfChain.chainIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.chainIdentifier);
    }

    public String toString() {
        return this.flatToString();
    }
}

