/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.mmtf;

import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.families.LigandFamily;
import de.bioforscher.singa.structure.model.families.NucleotideFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.mmtf.MmtfAminoAcid;
import de.bioforscher.singa.structure.model.mmtf.MmtfLeafSubstructure;
import de.bioforscher.singa.structure.model.mmtf.MmtfLigand;
import de.bioforscher.singa.structure.model.mmtf.MmtfNucleotide;
import java.util.HashMap;
import java.util.Optional;
import org.rcsb.mmtf.api.StructureDataInterface;

class MmtfLeafFactory {
    private static final HashMap<String, LigandFamily> ligandFamilyCache = new HashMap();

    private MmtfLeafFactory() {
    }

    static MmtfLeafSubstructure<?> createLeaf(StructureDataInterface data, byte[] bytes, LeafIdentifier leafIdentifier, int internalGroupIndex, int atomStartIndex, int atomEndIndex) {
        String threeLetterCode = data.getGroupName(data.getGroupTypeIndices()[internalGroupIndex]);
        Optional<AminoAcidFamily> aminoAcidFamily = AminoAcidFamily.getAminoAcidTypeByThreeLetterCode(threeLetterCode);
        if (aminoAcidFamily.isPresent()) {
            return new MmtfAminoAcid(data, bytes, aminoAcidFamily.get(), leafIdentifier, internalGroupIndex, atomStartIndex, atomEndIndex);
        }
        Optional<NucleotideFamily> nucleotideFamily = NucleotideFamily.getNucleotideByThreeLetterCode(threeLetterCode);
        if (nucleotideFamily.isPresent()) {
            return new MmtfNucleotide(data, bytes, nucleotideFamily.get(), leafIdentifier, internalGroupIndex, atomStartIndex, atomEndIndex);
        }
        LigandFamily ligandFamily = MmtfLeafFactory.getLigandFamily(threeLetterCode);
        return new MmtfLigand(data, bytes, ligandFamily, leafIdentifier, internalGroupIndex, atomStartIndex, atomEndIndex);
    }

    private static LigandFamily getLigandFamily(String threeLetterCode) {
        if (ligandFamilyCache.containsKey(threeLetterCode)) {
            return ligandFamilyCache.get(threeLetterCode);
        }
        LigandFamily ligandFamily = new LigandFamily(threeLetterCode);
        ligandFamilyCache.put(threeLetterCode, ligandFamily);
        return ligandFamily;
    }
}

