/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.mmtf;

import de.bioforscher.singa.structure.model.families.StructuralFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.mmtf.MmtfAtom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.rcsb.mmtf.api.StructureDataInterface;

public abstract class MmtfLeafSubstructure<FamilyType extends StructuralFamily>
implements LeafSubstructure<FamilyType> {
    private final byte[] bytes;
    private final StructureDataInterface data;
    private final int internalGroupIndex;
    private final LeafIdentifier leafIdentifier;
    private final Map<Integer, MmtfAtom> cachedAtoms;
    private final int atomStartIndex;
    private final int atomEndIndex;
    private final Set<Integer> removedAtoms;
    protected FamilyType family;
    protected Set<FamilyType> exchangeableFamilies;

    MmtfLeafSubstructure(StructureDataInterface data, byte[] bytes, FamilyType family, LeafIdentifier leafIdentifier, int internalGroupIndex, int atomStartIndex, int atomEndIndex) {
        this.data = data;
        this.bytes = bytes;
        this.family = family;
        this.leafIdentifier = leafIdentifier;
        this.internalGroupIndex = internalGroupIndex;
        this.atomStartIndex = atomStartIndex;
        this.atomEndIndex = atomEndIndex;
        this.removedAtoms = new HashSet<Integer>();
        char[] alternativeLocationCodes = data.getAltLocIds();
        for (int internalAtomIndex = atomStartIndex; internalAtomIndex <= atomEndIndex; ++internalAtomIndex) {
            char alternativeLocationCode = alternativeLocationCodes[internalAtomIndex];
            if (alternativeLocationCode == '\u0000' || alternativeLocationCode == 'A') continue;
            this.removedAtoms.add(internalAtomIndex);
        }
        this.exchangeableFamilies = new HashSet<FamilyType>();
        this.cachedAtoms = new HashMap<Integer, MmtfAtom>();
    }

    protected MmtfLeafSubstructure(MmtfLeafSubstructure<?> mmtfLeafSubstructure) {
        this.bytes = mmtfLeafSubstructure.bytes;
        this.data = mmtfLeafSubstructure.data;
        this.leafIdentifier = mmtfLeafSubstructure.leafIdentifier;
        this.internalGroupIndex = mmtfLeafSubstructure.internalGroupIndex;
        this.atomStartIndex = mmtfLeafSubstructure.atomStartIndex;
        this.atomEndIndex = mmtfLeafSubstructure.atomEndIndex;
        this.removedAtoms = new HashSet<Integer>(mmtfLeafSubstructure.removedAtoms);
        this.cachedAtoms = new HashMap<Integer, MmtfAtom>();
        for (Map.Entry<Integer, MmtfAtom> entry : mmtfLeafSubstructure.cachedAtoms.entrySet()) {
            this.cachedAtoms.put(entry.getKey(), (MmtfAtom)entry.getValue().getCopy());
        }
    }

    @Override
    public LeafIdentifier getIdentifier() {
        return this.leafIdentifier;
    }

    @Override
    public String getThreeLetterCode() {
        return this.family.getThreeLetterCode();
    }

    @Override
    public List<Atom> getAllAtoms() {
        ArrayList<Atom> results = new ArrayList<Atom>();
        for (int internalAtomIndex = this.atomStartIndex; internalAtomIndex <= this.atomEndIndex; ++internalAtomIndex) {
            if (this.removedAtoms.contains(internalAtomIndex)) continue;
            if (this.cachedAtoms.containsKey(internalAtomIndex)) {
                results.add(this.cachedAtoms.get(internalAtomIndex));
                continue;
            }
            MmtfAtom mmtfAtom = new MmtfAtom(this.data, this.internalGroupIndex, internalAtomIndex - this.atomStartIndex, internalAtomIndex);
            this.cachedAtoms.put(internalAtomIndex, mmtfAtom);
            results.add(mmtfAtom);
        }
        return results;
    }

    @Override
    public Optional<Atom> getAtom(Integer internalAtomIndex) {
        Integer n = internalAtomIndex;
        Integer n2 = internalAtomIndex = Integer.valueOf(internalAtomIndex - 1);
        if (internalAtomIndex < this.atomStartIndex || internalAtomIndex > this.atomEndIndex || this.removedAtoms.contains(internalAtomIndex)) {
            return Optional.empty();
        }
        return this.cacheAtom(internalAtomIndex);
    }

    @Override
    public void removeAtom(Integer atomIdentifier) {
        this.removedAtoms.add(atomIdentifier - 1);
    }

    @Override
    public boolean containsAtomWithName(String atomName) {
        for (Atom atom : this.getAllAtoms()) {
            if (!atom.getAtomName().equals(atomName)) continue;
            return true;
        }
        return false;
    }

    private Optional<Atom> cacheAtom(int internalAtomIndex) {
        if (this.cachedAtoms.containsKey(internalAtomIndex)) {
            return Optional.of(this.cachedAtoms.get(internalAtomIndex));
        }
        MmtfAtom mmtfAtom = new MmtfAtom(this.data, this.internalGroupIndex, internalAtomIndex - this.atomStartIndex, internalAtomIndex);
        this.cachedAtoms.put(internalAtomIndex, mmtfAtom);
        return Optional.of(mmtfAtom);
    }

    @Override
    public Optional<Atom> getAtomByName(String atomName) {
        for (int internalAtomIndex = this.atomStartIndex; internalAtomIndex <= this.atomEndIndex; ++internalAtomIndex) {
            String actualAtomName;
            if (this.removedAtoms.contains(internalAtomIndex) || !atomName.equals(actualAtomName = this.data.getGroupAtomNames(this.data.getGroupTypeIndices()[this.internalGroupIndex])[internalAtomIndex - this.atomStartIndex])) continue;
            return this.cacheAtom(internalAtomIndex);
        }
        return Optional.empty();
    }

    @Override
    public FamilyType getFamily() {
        return this.family;
    }

    @Override
    public Set<FamilyType> getExchangeableFamilies() {
        return this.exchangeableFamilies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MmtfLeafSubstructure that = (MmtfLeafSubstructure)o;
        return Objects.equals(this.family, that.family) && Objects.equals(this.leafIdentifier, that.leafIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.family, this.leafIdentifier);
    }

    public String toString() {
        return this.flatToString();
    }
}

