/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.mmtf;

import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.interfaces.Model;
import de.bioforscher.singa.structure.model.mmtf.MmtfChain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.rcsb.mmtf.api.StructureDataInterface;

public class MmtfModel
implements Model {
    private final StructureDataInterface data;
    private final byte[] bytes;
    private final HashMap<String, MmtfChain> cachedChains;
    private final int modelIndex;
    private final Map<String, List<Integer>> chainMap;

    MmtfModel(StructureDataInterface data, byte[] bytes, int modelIndex) {
        this.data = data;
        this.bytes = bytes;
        this.modelIndex = modelIndex;
        this.chainMap = new TreeMap<String, List<Integer>>();
        this.cachedChains = new HashMap();
        if (modelIndex > data.getNumModels() - 1) {
            throw new IllegalArgumentException("Unable to access model with identifier: " + modelIndex);
        }
        int[] chainsPerModel = data.getChainsPerModel();
        int currentChainIndex = 0;
        for (int chainsPerModelIndex = 0; chainsPerModelIndex < chainsPerModel.length; ++chainsPerModelIndex) {
            int endRange = currentChainIndex + chainsPerModel[chainsPerModelIndex];
            if (chainsPerModelIndex != modelIndex) continue;
            for (int groupIndex = currentChainIndex; groupIndex <= endRange - 1; ++groupIndex) {
                String chainName = data.getChainNames()[groupIndex];
                if (!this.chainMap.containsKey(chainName)) {
                    this.chainMap.put(chainName, new ArrayList());
                    this.chainMap.get(chainName).add(groupIndex);
                    continue;
                }
                this.chainMap.get(chainName).add(groupIndex);
            }
        }
    }

    private MmtfModel(MmtfModel mmtfModel) {
        this.bytes = mmtfModel.bytes;
        this.data = mmtfModel.data;
        this.modelIndex = mmtfModel.modelIndex;
        this.chainMap = new HashMap<String, List<Integer>>(mmtfModel.chainMap);
        this.cachedChains = new HashMap();
    }

    @Override
    public Integer getModelIdentifier() {
        return this.modelIndex + 1;
    }

    @Override
    public List<Chain> getAllChains() {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        for (String chainIdentifier : this.chainMap.keySet()) {
            if (this.cachedChains.containsKey(chainIdentifier)) {
                chains.add(this.cachedChains.get(chainIdentifier));
                continue;
            }
            MmtfChain mmtfChain = new MmtfChain(this.data, this.bytes, chainIdentifier, this.chainMap.get(chainIdentifier), this.modelIndex);
            this.cachedChains.put(chainIdentifier, mmtfChain);
            chains.add(mmtfChain);
        }
        return chains;
    }

    @Override
    public Set<String> getAllChainIdentifiers() {
        return new HashSet<String>(this.chainMap.keySet());
    }

    @Override
    public Chain getFirstChain() {
        Map.Entry<String, List<Integer>> first = this.chainMap.entrySet().iterator().next();
        String chainIdentifier = first.getKey();
        if (this.cachedChains.containsKey(chainIdentifier)) {
            return this.cachedChains.get(chainIdentifier);
        }
        MmtfChain mmtfChain = new MmtfChain(this.data, this.bytes, chainIdentifier, first.getValue(), this.modelIndex);
        this.cachedChains.put(chainIdentifier, mmtfChain);
        return mmtfChain;
    }

    @Override
    public Optional<Chain> getChain(String chainIdentifier) {
        if (!this.chainMap.containsKey(chainIdentifier)) {
            return Optional.empty();
        }
        if (this.cachedChains.containsKey(chainIdentifier)) {
            return Optional.of(this.cachedChains.get(chainIdentifier));
        }
        MmtfChain mmtfChain = new MmtfChain(this.data, this.bytes, chainIdentifier, this.chainMap.get(chainIdentifier), this.modelIndex);
        this.cachedChains.put(chainIdentifier, mmtfChain);
        return Optional.of(mmtfChain);
    }

    @Override
    public void removeChain(String chainIdentifier) {
        this.chainMap.remove(chainIdentifier);
        this.cachedChains.remove(chainIdentifier);
    }

    @Override
    public List<LeafSubstructure<?>> getAllLeafSubstructures() {
        ArrayList leafSubstructures = new ArrayList();
        List<Chain> allChains = this.getAllChains();
        for (Chain chain : allChains) {
            leafSubstructures.addAll(chain.getAllLeafSubstructures());
        }
        return leafSubstructures;
    }

    @Override
    public Optional<LeafSubstructure<?>> getLeafSubstructure(LeafIdentifier leafIdentifier) {
        Optional<Chain> chainOptional = this.getChain(leafIdentifier.getChainIdentifier());
        return chainOptional.flatMap(chain -> chain.getLeafSubstructure(leafIdentifier));
    }

    @Override
    public LeafSubstructure<?> getFirstLeafSubstructure() {
        return this.getFirstChain().getFirstLeafSubstructure();
    }

    @Override
    public boolean removeLeafSubstructure(LeafIdentifier leafIdentifier) {
        Optional<Chain> chainOptional = this.getChain(leafIdentifier.getChainIdentifier());
        return chainOptional.map(chain -> chain.removeLeafSubstructure(leafIdentifier)).orElse(false);
    }

    @Override
    public void removeLeafSubstructuresNotRelevantFor(LeafSubstructureContainer leafSubstructuresToKeep) {
        for (Chain chain : this.getAllChains()) {
            chain.removeLeafSubstructuresNotRelevantFor(leafSubstructuresToKeep);
        }
    }

    @Override
    public int getNumberOfLeafSubstructures() {
        int sum = 0;
        for (Chain chain : this.getAllChains()) {
            sum += chain.getNumberOfLeafSubstructures();
        }
        return sum;
    }

    @Override
    public Optional<Atom> getAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
            if (!optionalAtom.isPresent()) continue;
            return optionalAtom;
        }
        return Optional.empty();
    }

    @Override
    public void removeAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
            optionalAtom.ifPresent(atom -> leafSubstructure.removeAtom(atomIdentifier));
        }
    }

    @Override
    public Model getCopy() {
        return new MmtfModel(this);
    }

    public String toString() {
        return this.flatToString();
    }
}

