/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.mmtf;

import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.interfaces.Model;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.mmtf.MmtfModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.decoder.GenericDecoder;
import org.rcsb.mmtf.decoder.ReaderUtils;
import org.rcsb.mmtf.serialization.MessagePackSerialization;

public class MmtfStructure
implements Structure {
    private final byte[] bytes;
    private final StructureDataInterface data;
    private Set<Integer> removedModels;
    private final Map<Integer, MmtfModel> cachedModels;

    public MmtfStructure(byte[] bytes) {
        this(bytes, true);
    }

    public MmtfStructure(byte[] bytes, boolean deflate) {
        this.bytes = bytes;
        this.data = MmtfStructure.bytesToStructureData(bytes, deflate);
        this.cachedModels = new HashMap<Integer, MmtfModel>();
        this.removedModels = new HashSet<Integer>();
    }

    private MmtfStructure(MmtfStructure mmtfStructure) {
        this(mmtfStructure.bytes);
    }

    static StructureDataInterface bytesToStructureData(byte[] bytes, boolean deflate) {
        MessagePackSerialization mmtfBeanSeDeMessagePackImpl = new MessagePackSerialization();
        try {
            byte[] gzip = deflate ? ReaderUtils.deflateGzip((byte[])bytes) : bytes;
            return new GenericDecoder(mmtfBeanSeDeMessagePackImpl.deserialize((InputStream)new ByteArrayInputStream(gzip)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getPdbIdentifier() {
        return this.data.getStructureId().toLowerCase();
    }

    @Override
    public String getTitle() {
        return this.data.getTitle();
    }

    @Override
    public List<Model> getAllModels() {
        ArrayList<Model> models = new ArrayList<Model>();
        for (int internalModelIndex = 0; internalModelIndex < this.data.getNumModels(); ++internalModelIndex) {
            if (this.cachedModels.containsKey(internalModelIndex)) {
                models.add(this.cachedModels.get(internalModelIndex));
                continue;
            }
            if (this.removedModels.contains(internalModelIndex)) continue;
            MmtfModel mmtfModel = new MmtfModel(this.data, this.bytes, internalModelIndex);
            this.cachedModels.put(internalModelIndex, mmtfModel);
            models.add(mmtfModel);
        }
        return models;
    }

    @Override
    public Set<Integer> getAllModelIdentifiers() {
        HashSet<Integer> modelIdentifiers = new HashSet<Integer>();
        for (int internalModelIndex = 0; internalModelIndex < this.data.getNumModels(); ++internalModelIndex) {
            if (this.removedModels.contains(internalModelIndex)) continue;
            modelIdentifiers.add(internalModelIndex + 1);
        }
        return modelIdentifiers;
    }

    @Override
    public Model getFirstModel() {
        if (this.cachedModels.containsKey(0)) {
            return this.cachedModels.get(0);
        }
        TreeSet<Integer> sortedModelIdentifiers = new TreeSet<Integer>(this.getAllModelIdentifiers());
        for (Integer modelIdentifier : sortedModelIdentifiers) {
            int internalModelIndex = modelIdentifier - 1;
            if (this.removedModels.contains(internalModelIndex)) continue;
            MmtfModel mmtfModel = new MmtfModel(this.data, this.bytes, internalModelIndex);
            this.cachedModels.put(internalModelIndex, mmtfModel);
            return mmtfModel;
        }
        throw new IllegalStateException("The structure does not contain any model. Either each model has been removed or no models have been assigned to this strucutre.");
    }

    @Override
    public Optional<Model> getModel(int modelIdentifier) {
        int internalModelIndex = modelIdentifier - 1;
        if (modelIdentifier < 0 ^ modelIdentifier > this.data.getNumModels() || this.removedModels.contains(internalModelIndex)) {
            return Optional.empty();
        }
        if (this.cachedModels.containsKey(internalModelIndex)) {
            return Optional.of(this.cachedModels.get(internalModelIndex));
        }
        MmtfModel mmtfModel = new MmtfModel(this.data, this.bytes, internalModelIndex);
        this.cachedModels.put(internalModelIndex, mmtfModel);
        return Optional.of(mmtfModel);
    }

    @Override
    public void removeModel(int modelIdentifier) {
        int internalModelIndex = modelIdentifier - 1;
        this.cachedModels.remove(internalModelIndex);
        this.removedModels.add(internalModelIndex);
    }

    @Override
    public List<Chain> getAllChains() {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        List<Model> allModels = this.getAllModels();
        for (Model model : allModels) {
            chains.addAll(model.getAllChains());
        }
        return chains;
    }

    @Override
    public Chain getFirstChain() {
        return this.getFirstModel().getFirstChain();
    }

    @Override
    public Optional<Chain> getChain(int modelIdentifier, String chainIdentifier) {
        Optional<Model> modelOptional = this.getModel(modelIdentifier);
        return modelOptional.flatMap(model -> model.getChain(chainIdentifier));
    }

    @Override
    public List<LeafSubstructure<?>> getAllLeafSubstructures() {
        ArrayList leafSubstructures = new ArrayList();
        List<Chain> allChains = this.getAllChains();
        for (Chain chain : allChains) {
            leafSubstructures.addAll(chain.getAllLeafSubstructures());
        }
        return leafSubstructures;
    }

    @Override
    public Optional<LeafSubstructure<?>> getLeafSubstructure(LeafIdentifier leafIdentifier) {
        Optional<Chain> chainOptional = this.getChain(leafIdentifier.getModelIdentifier(), leafIdentifier.getChainIdentifier());
        return chainOptional.flatMap(chain -> chain.getLeafSubstructure(leafIdentifier));
    }

    @Override
    public LeafSubstructure<?> getFirstLeafSubstructure() {
        return this.getFirstChain().getFirstLeafSubstructure();
    }

    @Override
    public boolean removeLeafSubstructure(LeafIdentifier leafIdentifier) {
        for (Chain chain : this.getAllChains()) {
            if (!chain.removeLeafSubstructure(leafIdentifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeLeafSubstructuresNotRelevantFor(LeafSubstructureContainer leafSubstructuresToKeep) {
        for (Chain chain : this.getAllChains()) {
            chain.removeLeafSubstructuresNotRelevantFor(leafSubstructuresToKeep);
        }
    }

    @Override
    public int getNumberOfLeafSubstructures() {
        int sum = 0;
        for (Chain chain : this.getAllChains()) {
            sum += chain.getNumberOfLeafSubstructures();
        }
        return sum;
    }

    @Override
    public Optional<Atom> getAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
            if (!optionalAtom.isPresent()) continue;
            return optionalAtom;
        }
        return Optional.empty();
    }

    @Override
    public void removeAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
            optionalAtom.ifPresent(atom -> leafSubstructure.removeAtom(atomIdentifier));
        }
    }

    @Override
    public Structure getCopy() {
        return new MmtfStructure(this);
    }

    public String toString() {
        return this.flatToString();
    }
}

