/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.molecules;

import java.util.stream.Stream;

public enum MoleculeBondType {
    SINGLE_BOND('-'),
    DOUBLE_BOND('='),
    TRIPLE_BOND('#'),
    QUADRUPLE_BOND('$'),
    ISOMERIC_BOND_UP('/'),
    ISOMERIC_BOND_DOWN('\\'),
    AROMATIC_BOND(':'),
    UNCONNECTED('.');

    private final char smilesRepresentation;

    private MoleculeBondType(char smilesRepresentation) {
        this.smilesRepresentation = smilesRepresentation;
    }

    public static MoleculeBondType getBondForSMILESSymbol(char smilesSymbol) {
        return Stream.of(MoleculeBondType.values()).filter(type -> type.getSmilesRepresentation() == smilesSymbol).findAny().orElse(SINGLE_BOND);
    }

    public char getSmilesRepresentation() {
        return this.smilesRepresentation;
    }
}

