/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.molecules;

import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.graphs.model.AbstractMapGraph;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import de.bioforscher.singa.structure.elements.Element;
import de.bioforscher.singa.structure.elements.ElementProvider;
import de.bioforscher.singa.structure.model.molecules.MoleculeAtom;
import de.bioforscher.singa.structure.model.molecules.MoleculeBond;
import de.bioforscher.singa.structure.model.molecules.MoleculeBondType;
import de.bioforscher.singa.structure.model.oak.BondType;

public class MoleculeGraph
extends AbstractMapGraph<MoleculeAtom, MoleculeBond, Vector2D, Integer> {
    public int addNextAtom(char elementSymbol) {
        return this.addNextAtom(String.valueOf(elementSymbol));
    }

    public int addNextAtom(String elementSymbol) {
        return this.addNextAtom(ElementProvider.getElementBySymbol(elementSymbol).orElseThrow(() -> new IllegalArgumentException("The symbol " + elementSymbol + " represents no valid element.")));
    }

    public int addNextAtom(Element element) {
        MoleculeAtom atom = new MoleculeAtom(this.nextNodeIdentifier(), Vectors.generateRandom2DVector((Rectangle)new Rectangle(100.0, 100.0)), element);
        this.addNode((Node)atom);
        return (Integer)atom.getIdentifier();
    }

    public int addNextAtom(Element element, int charge) {
        Element ion = element.asIon(charge);
        return this.addNextAtom(ion);
    }

    public int addNextAtom(Element element, int charge, int massNumber) {
        Element modifiedElement = element.asIon(charge).asIsotope(massNumber);
        return this.addNextAtom(modifiedElement);
    }

    public int addEdgeBetween(int identifier, MoleculeAtom source, MoleculeAtom target) {
        return this.addEdgeBetween((Edge)new MoleculeBond(identifier), (Node)source, (Node)target);
    }

    public int addEdgeBetween(MoleculeAtom source, MoleculeAtom target) {
        return this.addEdgeBetween(this.nextEdgeIdentifier(), source, target);
    }

    public int addEdgeBetween(MoleculeAtom source, MoleculeAtom target, MoleculeBondType bondType) {
        MoleculeBond bond = new MoleculeBond(this.nextEdgeIdentifier());
        bond.setType(bondType);
        return this.addEdgeBetween((Edge)bond, (Node)source, (Node)target);
    }

    int addEdgeBetween(int edgeIdentifier, int sourceIdentifier, int targetIdentifier, BondType bondType) {
        MoleculeBond bond = new MoleculeBond(edgeIdentifier);
        switch (bondType) {
            default: {
                bond.setType(MoleculeBondType.SINGLE_BOND);
                break;
            }
            case DOUBLE_BOND: {
                bond.setType(MoleculeBondType.DOUBLE_BOND);
                break;
            }
            case TRIPLE_BOND: {
                bond.setType(MoleculeBondType.TRIPLE_BOND);
            }
        }
        MoleculeAtom source = (MoleculeAtom)this.getNode(sourceIdentifier);
        MoleculeAtom target = (MoleculeAtom)this.getNode(targetIdentifier);
        this.addEdgeBetween((Edge)bond, (Node)source, (Node)target);
        return edgeIdentifier;
    }

    public Integer nextNodeIdentifier() {
        if (this.getNodes().isEmpty()) {
            return 0;
        }
        return this.getNodes().size();
    }
}

