/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.molecules;

import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import de.bioforscher.singa.structure.algorithms.molecules.MoleculePathFinder;
import de.bioforscher.singa.structure.elements.Element;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.molecules.MoleculeAtom;
import de.bioforscher.singa.structure.model.molecules.MoleculeBond;
import de.bioforscher.singa.structure.model.molecules.MoleculeBondType;
import de.bioforscher.singa.structure.model.molecules.MoleculeGraph;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.OakBond;
import de.bioforscher.singa.structure.model.oak.OakLeafSubstructure;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class MoleculeGraphs {
    public static Rectangle defaultBoundingBox = new Rectangle(100.0, 100.0);

    public static MoleculeGraph createMoleculeGraphFromStructure(OakLeafSubstructure<?> leafSubstructure) {
        MoleculeGraph graph = new MoleculeGraph();
        for (Atom atom : leafSubstructure.getAllAtoms()) {
            graph.addNode((Node)new MoleculeAtom(atom.getAtomIdentifier(), Vectors.generateRandom2DVector((Rectangle)defaultBoundingBox), atom.getElement()));
        }
        for (OakBond bond : leafSubstructure.getBonds()) {
            OakAtom source = bond.getSource();
            OakAtom target = bond.getTarget();
            if (graph.getNode(source.getAtomIdentifier()) == null || graph.getNode(target.getAtomIdentifier()) == null) continue;
            graph.addEdgeBetween(bond.getIdentifier(), source.getAtomIdentifier(), target.getAtomIdentifier(), bond.getBondType());
        }
        return graph;
    }

    public static int countAtomsOfElement(MoleculeGraph graph, Element element) {
        return (int)graph.getNodes().stream().filter(MoleculeGraphs.isElement(element)).count();
    }

    public static List<LinkedList<MoleculeAtom>> findPathOfElements(MoleculeGraph graph, LinkedList<Element> path) {
        return MoleculePathFinder.findPathInMolecule(graph, path);
    }

    public static List<LinkedList<MoleculeAtom>> findMultiPathOfElements(MoleculeGraph graph, LinkedList<Set<Element>> path) {
        return MoleculePathFinder.findMultiPathInMolecule(graph, path);
    }

    public static void replaceAromaticsWithDoubleBonds(MoleculeGraph graph) {
        List<LinkedList<MoleculeBond>> aromaticPaths = MoleculePathFinder.findAromaticPath(graph);
        for (List list : aromaticPaths) {
            for (int i = 0; i < list.size(); ++i) {
                if (i % 2 == 0) {
                    ((MoleculeBond)((Object)list.get(i))).setType(MoleculeBondType.DOUBLE_BOND);
                    continue;
                }
                ((MoleculeBond)((Object)list.get(i))).setType(MoleculeBondType.SINGLE_BOND);
            }
        }
    }

    public static Predicate<MoleculeAtom> isElement(Element element) {
        return atom -> atom.getElement().getProtonNumber() == element.getProtonNumber();
    }

    public static Predicate<MoleculeAtom> isOneOfElements(Set<Element> elements) {
        return atom -> elements.contains(atom.getElement());
    }
}

