/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.structure.model.families.StructuralFamily;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Exchangeable<FamilyType extends StructuralFamily> {
    public FamilyType getFamily();

    default public Set<FamilyType> getExchangeableFamilies() {
        return Stream.of(this.getFamily()).collect(Collectors.toSet());
    }

    default public Set<FamilyType> getContainingFamilies() {
        HashSet<FamilyType> types = new HashSet<FamilyType>();
        types.add(this.getFamily());
        types.addAll(this.getExchangeableFamilies());
        return types;
    }

    default public void addExchangeableFamily(FamilyType exchangeableFamily) {
        this.getExchangeableFamilies().add(exchangeableFamily);
    }
}

