/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.families.LigandFamily;
import de.bioforscher.singa.structure.model.families.NucleotideFamily;
import de.bioforscher.singa.structure.model.families.StructuralFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.oak.BondType;
import de.bioforscher.singa.structure.model.oak.OakAminoAcid;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.OakLeafSubstructure;
import de.bioforscher.singa.structure.model.oak.OakLigand;
import de.bioforscher.singa.structure.model.oak.OakNucleotide;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParserOptions;
import java.util.Map;

public class LeafSubstructureFactory {
    private LeafSubstructureFactory() {
    }

    public static OakLeafSubstructure<?> createLeafSubstructure(LeafIdentifier leafIdentifier, StructuralFamily family) {
        if (family instanceof AminoAcidFamily) {
            return new OakAminoAcid(leafIdentifier, (AminoAcidFamily)family);
        }
        if (family instanceof NucleotideFamily) {
            return new OakNucleotide(leafIdentifier, (NucleotideFamily)family);
        }
        return new OakLigand(leafIdentifier, (LigandFamily)family);
    }

    public static OakNucleotide createNucleotideFromAtoms(LeafIdentifier leafIdentifier, NucleotideFamily nucleotideFamily, Map<String, OakAtom> atoms, StructureParserOptions options) {
        OakNucleotide nucleotide = new OakNucleotide(leafIdentifier, nucleotideFamily);
        if (options.isOmittingHydrogen()) {
            atoms.values().stream().filter(atom -> atom.getElement().getProtonNumber() != 1).forEach(nucleotide::addAtom);
        } else {
            atoms.values().forEach(nucleotide::addAtom);
        }
        if (options.isCreatingEdges()) {
            LeafSubstructureFactory.connectRibose(nucleotide, atoms);
            LeafSubstructureFactory.connectPhosphateGroup(nucleotide, atoms);
            nucleotide.addBondBetween(atoms.get("P"), atoms.get("O5'"));
            switch (nucleotideFamily) {
                case ADENOSINE: {
                    nucleotide.addBondBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafSubstructureFactory.connectPurine(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("C6"), atoms.get("N6"));
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N9"));
                    break;
                }
                case CYTIDINE: {
                    nucleotide.addBondBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafSubstructureFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("C4"), atoms.get("N4"));
                    nucleotide.addBondBetween(atoms.get("N3"), atoms.get("C4"), BondType.DOUBLE_BOND);
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case DESOXYADENOSINE: {
                    LeafSubstructureFactory.connectPurine(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("C6"), atoms.get("N6"));
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N9"));
                    break;
                }
                case DESOXYCYTIDINE: {
                    LeafSubstructureFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("C4"), atoms.get("N4"));
                    nucleotide.addBondBetween(atoms.get("N3"), atoms.get("C4"), BondType.DOUBLE_BOND);
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case DESOXYGUANOSINE: {
                    LeafSubstructureFactory.connectPurine(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("C6"), atoms.get("N1"));
                    nucleotide.addBondBetween(atoms.get("C6"), atoms.get("O6"), BondType.DOUBLE_BOND);
                    nucleotide.addBondBetween(atoms.get("C2"), atoms.get("N2"));
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N9"));
                    break;
                }
                case DESOXYTHYMIDINE: {
                    LeafSubstructureFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("C4"), atoms.get("O4"), BondType.DOUBLE_BOND);
                    nucleotide.addBondBetween(atoms.get("N3"), atoms.get("C4"));
                    nucleotide.addBondBetween(atoms.get("C5"), atoms.get("C7"));
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case DESOXYURIDINE: {
                    LeafSubstructureFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("N3"), atoms.get("C4"));
                    nucleotide.addBondBetween(atoms.get("C4"), atoms.get("O4"), BondType.DOUBLE_BOND);
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case GUANOSINE: {
                    nucleotide.addBondBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafSubstructureFactory.connectPurine(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("C6"), atoms.get("N1"));
                    nucleotide.addBondBetween(atoms.get("C6"), atoms.get("O6"), BondType.DOUBLE_BOND);
                    nucleotide.addBondBetween(atoms.get("C2"), atoms.get("N2"));
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N9"));
                    break;
                }
                case THYMIDINE: {
                    nucleotide.addBondBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafSubstructureFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("C4"), atoms.get("O4"), BondType.DOUBLE_BOND);
                    nucleotide.addBondBetween(atoms.get("N3"), atoms.get("C4"));
                    nucleotide.addBondBetween(atoms.get("C5"), atoms.get("C7"));
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N1"));
                    break;
                }
                case URIDINE: {
                    nucleotide.addBondBetween(atoms.get("C2'"), atoms.get("O2'"));
                    LeafSubstructureFactory.connectPyrimidin(nucleotide, atoms);
                    nucleotide.addBondBetween(atoms.get("C4"), atoms.get("O4"), BondType.DOUBLE_BOND);
                    nucleotide.addBondBetween(atoms.get("N3"), atoms.get("C4"));
                    nucleotide.addBondBetween(atoms.get("C1'"), atoms.get("N1"));
                }
            }
        }
        return nucleotide;
    }

    private static void connectRibose(OakNucleotide nucleotide, Map<String, OakAtom> atoms) {
        LeafSubstructureFactory.connectInOrder(nucleotide, atoms, "C1'", "C2'", "C3'", "C4'", "O4'", "C1'");
        nucleotide.addBondBetween(atoms.get("C3'"), atoms.get("O3'"));
        nucleotide.addBondBetween(atoms.get("C4'"), atoms.get("C5'"));
        nucleotide.addBondBetween(atoms.get("C5'"), atoms.get("O5'"));
    }

    private static void connectPhosphateGroup(OakNucleotide nucleotide, Map<String, OakAtom> atoms) {
        nucleotide.addBondBetween(atoms.get("P"), atoms.get("OP1"), BondType.DOUBLE_BOND);
        nucleotide.addBondBetween(atoms.get("P"), atoms.get("OP2"));
        nucleotide.addBondBetween(atoms.get("P"), atoms.get("OP3"));
    }

    private static void connectPyrimidin(OakNucleotide nucleotide, Map<String, OakAtom> atoms) {
        nucleotide.addBondBetween(atoms.get("N1"), atoms.get("C2"));
        nucleotide.addBondBetween(atoms.get("C2"), atoms.get("N3"));
        nucleotide.addBondBetween(atoms.get("C4"), atoms.get("C5"));
        nucleotide.addBondBetween(atoms.get("C2"), atoms.get("O2"), BondType.DOUBLE_BOND);
        nucleotide.addBondBetween(atoms.get("C5"), atoms.get("O6"), BondType.DOUBLE_BOND);
        nucleotide.addBondBetween(atoms.get("C6"), atoms.get("N1"));
    }

    private static void connectPurine(OakNucleotide nucleotide, Map<String, OakAtom> atoms) {
        nucleotide.addBondBetween(atoms.get("N1"), atoms.get("C2"));
        nucleotide.addBondBetween(atoms.get("C2"), atoms.get("N3"), BondType.DOUBLE_BOND);
        nucleotide.addBondBetween(atoms.get("N3"), atoms.get("C4"));
        nucleotide.addBondBetween(atoms.get("C4"), atoms.get("N9"));
        nucleotide.addBondBetween(atoms.get("N9"), atoms.get("C8"));
        nucleotide.addBondBetween(atoms.get("C8"), atoms.get("N7"), BondType.DOUBLE_BOND);
        nucleotide.addBondBetween(atoms.get("N7"), atoms.get("C5"));
        nucleotide.addBondBetween(atoms.get("C5"), atoms.get("C6"));
        nucleotide.addBondBetween(atoms.get("C4"), atoms.get("C5"), BondType.DOUBLE_BOND);
    }

    public static OakAminoAcid createAminoAcidFromAtoms(LeafIdentifier leafIdentifier, AminoAcidFamily aminoAcidFamily, Map<String, OakAtom> atoms, StructureParserOptions options) {
        OakAminoAcid aminoAcid = new OakAminoAcid(leafIdentifier, aminoAcidFamily);
        if (options.isOmittingHydrogen()) {
            atoms.values().stream().filter(atom -> atom.getElement().getProtonNumber() != 1).forEach(aminoAcid::addAtom);
        } else {
            atoms.values().forEach(aminoAcid::addAtom);
        }
        if (options.isCreatingEdges()) {
            LeafSubstructureFactory.connectBackboneAtoms(aminoAcid, atoms);
            switch (aminoAcidFamily) {
                case ALANINE: {
                    aminoAcid.addBondBetween(atoms.get("CA"), atoms.get("CB"));
                    break;
                }
                case ARGININE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "NE", "CZ", "NH1");
                    aminoAcid.addBondBetween(atoms.get("CZ"), atoms.get("NH2"), BondType.DOUBLE_BOND);
                    break;
                }
                case ASPARAGINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "ND2");
                    aminoAcid.addBondBetween(atoms.get("CG"), atoms.get("OD1"), BondType.DOUBLE_BOND);
                    break;
                }
                case ASPARTIC_ACID: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "OD2");
                    aminoAcid.addBondBetween(atoms.get("CG"), atoms.get("OD1"), BondType.DOUBLE_BOND);
                    break;
                }
                case CYSTEINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "SG");
                    break;
                }
                case GLUTAMINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "NE2");
                    aminoAcid.addBondBetween(atoms.get("CD"), atoms.get("OE1"), BondType.DOUBLE_BOND);
                    break;
                }
                case GLUTAMIC_ACID: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "OE2");
                    aminoAcid.addBondBetween(atoms.get("CD"), atoms.get("OE1"), BondType.DOUBLE_BOND);
                    break;
                }
                case GLYCINE: {
                    break;
                }
                case HISTIDINE: {
                    LeafSubstructureFactory.connectHistidine(aminoAcid, atoms);
                    break;
                }
                case ISOLEUCINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG1", "CD1");
                    aminoAcid.addBondBetween(atoms.get("CB"), atoms.get("CG2"));
                    break;
                }
                case LEUCINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD1");
                    aminoAcid.addBondBetween(atoms.get("CG"), atoms.get("CD2"));
                    break;
                }
                case LYSINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "CE", "NZ");
                    break;
                }
                case METHIONINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "SD", "CE");
                    break;
                }
                case PHENYLALANINE: {
                    LeafSubstructureFactory.connectPhenylalanine(aminoAcid, atoms);
                    break;
                }
                case PROLINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG", "CD", "N", "CA");
                    break;
                }
                case SERINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "OG");
                    break;
                }
                case THREONINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "OG1");
                    aminoAcid.addBondBetween(atoms.get("CB"), atoms.get("CG2"));
                    break;
                }
                case TRYPTOPHAN: {
                    LeafSubstructureFactory.connectTryptophan(aminoAcid, atoms);
                    break;
                }
                case TYROSINE: {
                    LeafSubstructureFactory.connectPhenylalanine(aminoAcid, atoms);
                    aminoAcid.addBondBetween(atoms.get("CZ"), atoms.get("OH"));
                    break;
                }
                case VALINE: {
                    LeafSubstructureFactory.connectInOrder(aminoAcid, atoms, "CA", "CB", "CG1");
                    aminoAcid.addBondBetween(atoms.get("CB"), atoms.get("CG2"));
                    break;
                }
            }
        }
        return aminoAcid;
    }

    private static void connectInOrder(OakLeafSubstructure<?> substructure, Map<String, OakAtom> atoms, String ... names) {
        if (names.length < 2) {
            throw new IllegalArgumentException("Two or more atom names are required in order to connect them.");
        }
        for (int i = 1; i < names.length; ++i) {
            substructure.addBondBetween(atoms.get(names[i - 1]), atoms.get(names[i]));
        }
    }

    private static void connectPhenylalanine(OakLeafSubstructure<?> substructure, Map<String, OakAtom> atoms) {
        substructure.addBondBetween(atoms.get("CA"), atoms.get("CB"));
        substructure.addBondBetween(atoms.get("CB"), atoms.get("CG"));
        substructure.addBondBetween(atoms.get("CG"), atoms.get("CD2"));
        substructure.addBondBetween(atoms.get("CD2"), atoms.get("CE2"), BondType.DOUBLE_BOND);
        substructure.addBondBetween(atoms.get("CE2"), atoms.get("CZ"));
        substructure.addBondBetween(atoms.get("CZ"), atoms.get("CE1"), BondType.DOUBLE_BOND);
        substructure.addBondBetween(atoms.get("CE1"), atoms.get("CD1"));
        substructure.addBondBetween(atoms.get("CD1"), atoms.get("CG"), BondType.DOUBLE_BOND);
    }

    private static void connectTryptophan(OakLeafSubstructure<?> substructure, Map<String, OakAtom> atoms) {
        substructure.addBondBetween(atoms.get("CA"), atoms.get("CB"));
        substructure.addBondBetween(atoms.get("CB"), atoms.get("CG"));
        substructure.addBondBetween(atoms.get("CG"), atoms.get("CD2"));
        substructure.addBondBetween(atoms.get("CD2"), atoms.get("CE3"));
        substructure.addBondBetween(atoms.get("CE3"), atoms.get("CZ3"), BondType.DOUBLE_BOND);
        substructure.addBondBetween(atoms.get("CZ3"), atoms.get("CH2"));
        substructure.addBondBetween(atoms.get("CH2"), atoms.get("CZ2"), BondType.DOUBLE_BOND);
        substructure.addBondBetween(atoms.get("CZ2"), atoms.get("CE2"));
        substructure.addBondBetween(atoms.get("CE2"), atoms.get("CD2"), BondType.DOUBLE_BOND);
        substructure.addBondBetween(atoms.get("CE2"), atoms.get("NE1"));
        substructure.addBondBetween(atoms.get("NE1"), atoms.get("CD1"));
        substructure.addBondBetween(atoms.get("CD1"), atoms.get("CG"), BondType.DOUBLE_BOND);
    }

    private static void connectHistidine(OakLeafSubstructure<?> substructure, Map<String, OakAtom> atoms) {
        substructure.addBondBetween(atoms.get("CA"), atoms.get("CB"));
        substructure.addBondBetween(atoms.get("CB"), atoms.get("CG"));
        substructure.addBondBetween(atoms.get("CG"), atoms.get("CD2"), BondType.DOUBLE_BOND);
        substructure.addBondBetween(atoms.get("CD2"), atoms.get("NE2"));
        substructure.addBondBetween(atoms.get("NE2"), atoms.get("CE1"));
        substructure.addBondBetween(atoms.get("CE1"), atoms.get("ND1"), BondType.DOUBLE_BOND);
        substructure.addBondBetween(atoms.get("ND1"), atoms.get("CG"));
    }

    private static void connectBackboneAtoms(OakAminoAcid aminoAcid, Map<String, OakAtom> atoms) {
        aminoAcid.addBondBetween(atoms.get("N"), atoms.get("CA"));
        aminoAcid.addBondBetween(atoms.get("CA"), atoms.get("C"));
        aminoAcid.addBondBetween(atoms.get("C"), atoms.get("O"), BondType.DOUBLE_BOND);
    }

    private static void connectNTerminalAtoms(OakAminoAcid aminoAcid, Map<String, OakAtom> atoms, StructureParserOptions options) {
        if (options.isConnectingHydrogens()) {
            aminoAcid.addBondBetween(atoms.get("N"), atoms.get("H"));
            aminoAcid.addBondBetween(atoms.get("N"), atoms.get("H2"));
        }
    }

    private static void connectCTerminaAtoms(OakAminoAcid aminoAcid, Map<String, OakAtom> atoms, StructureParserOptions options) {
        aminoAcid.addBondBetween(atoms.get("C"), atoms.get("OXT"));
        if (options.isConnectingHydrogens()) {
            aminoAcid.addBondBetween(atoms.get("OXT"), atoms.get("HXT"));
        }
    }
}

