/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.structure.elements.Element;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import java.util.HashSet;
import java.util.Set;

public class OakAtom
implements Atom {
    private final int identifier;
    private final Element element;
    private final String atomName;
    private final Set<OakAtom> neighbours;
    private Vector3D position;

    public OakAtom(int identifier, Element element, String atomName, Vector3D position) {
        this.atomName = atomName;
        this.identifier = identifier;
        this.element = element;
        this.position = position;
        this.neighbours = new HashSet<OakAtom>();
    }

    public OakAtom(OakAtom atom) {
        this.atomName = atom.atomName;
        this.identifier = atom.identifier;
        this.element = atom.element;
        this.position = new Vector3D(atom.position);
        this.neighbours = new HashSet<OakAtom>();
    }

    @Override
    public Integer getAtomIdentifier() {
        return this.identifier;
    }

    @Override
    public Vector3D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3D position) {
        this.position = position;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public String getAtomName() {
        return this.atomName;
    }

    public void addNeighbour(OakAtom node) {
        this.neighbours.add(node);
    }

    public Set<OakAtom> getNeighbours() {
        return this.neighbours;
    }

    @Override
    public OakAtom getCopy() {
        return new OakAtom(this);
    }

    public String toString() {
        return this.flatToString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OakAtom that = (OakAtom)o;
        if (this.identifier != that.identifier) {
            return false;
        }
        if (this.atomName != null ? !this.atomName.equals(that.atomName) : that.atomName != null) {
            return false;
        }
        return this.position != null ? this.position.equals((Object)that.position) : that.position == null;
    }

    public int hashCode() {
        int result = this.identifier;
        result = 31 * result + (this.atomName != null ? this.atomName.hashCode() : 0);
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        return result;
    }
}

