/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.structure.model.oak.BondType;
import de.bioforscher.singa.structure.model.oak.OakAtom;

public class OakBond {
    private final int identifier;
    protected OakAtom source;
    protected OakAtom target;
    private BondType bondType;

    public OakBond(int identifier) {
        this.identifier = identifier;
    }

    public OakBond(int identifier, BondType bondType) {
        this(identifier);
        this.bondType = bondType;
    }

    public OakBond(OakBond bond) {
        this.identifier = bond.identifier;
        this.bondType = bond.bondType;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public BondType getBondType() {
        return this.bondType;
    }

    public void setBondType(BondType bondType) {
        this.bondType = bondType;
    }

    public OakAtom getSource() {
        return this.source;
    }

    public void setSource(OakAtom source) {
        this.source = source;
    }

    public OakAtom getTarget() {
        return this.target;
    }

    public void setTarget(OakAtom target) {
        this.target = target;
    }

    public boolean connectsAtom(OakAtom oakAtom) {
        return this.source.equals(oakAtom) || this.target.equals(oakAtom);
    }

    public OakBond getCopy() {
        return new OakBond(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OakBond bond = (OakBond)o;
        if (this.identifier != bond.getIdentifier()) {
            return false;
        }
        return this.bondType == bond.bondType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.bondType != null ? this.bondType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.identifier + ": " + this.source.getAtomName() + "-" + this.source.getAtomIdentifier() + " -- " + this.target.getAtomName() + "-" + this.target.getAtomIdentifier();
    }
}

