/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.Nucleotide;
import de.bioforscher.singa.structure.model.oak.OakAminoAcid;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.OakLeafSubstructure;
import de.bioforscher.singa.structure.model.oak.OakNucleotide;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class OakChain
implements Chain {
    private final String identifier;
    private final TreeMap<LeafIdentifier, OakLeafSubstructure<?>> leafSubstructures;
    private final Set<LeafIdentifier> consecutiveIdentifiers;

    public OakChain(String chainIdentifier) {
        this.identifier = chainIdentifier;
        this.leafSubstructures = new TreeMap();
        this.consecutiveIdentifiers = new HashSet<LeafIdentifier>();
    }

    public OakChain(OakChain chain) {
        this.identifier = chain.identifier;
        this.leafSubstructures = new TreeMap();
        for (OakLeafSubstructure<?> leafSubstructure : chain.leafSubstructures.values()) {
            this.leafSubstructures.put(leafSubstructure.getIdentifier(), (OakLeafSubstructure<?>)leafSubstructure.getCopy());
        }
        this.consecutiveIdentifiers = new HashSet<LeafIdentifier>(chain.consecutiveIdentifiers);
    }

    @Override
    public String getChainIdentifier() {
        return this.identifier;
    }

    @Override
    public List<LeafSubstructure<?>> getAllLeafSubstructures() {
        return new ArrayList(this.leafSubstructures.values());
    }

    @Override
    public Optional<LeafSubstructure<?>> getLeafSubstructure(LeafIdentifier leafIdentifier) {
        if (this.leafSubstructures.containsKey(leafIdentifier)) {
            return Optional.of(this.leafSubstructures.get(leafIdentifier));
        }
        return Optional.empty();
    }

    @Override
    public LeafSubstructure<?> getFirstLeafSubstructure() {
        return this.leafSubstructures.values().iterator().next();
    }

    public void addLeafSubstructure(OakLeafSubstructure leafSubstructure, boolean consecutivePart) {
        if (consecutivePart) {
            this.consecutiveIdentifiers.add(leafSubstructure.getIdentifier());
        }
        this.addLeafSubstructure(leafSubstructure);
    }

    public void addLeafSubstructure(OakLeafSubstructure leafSubstructure) {
        this.leafSubstructures.put(leafSubstructure.getIdentifier(), leafSubstructure);
    }

    @Override
    public boolean removeLeafSubstructure(LeafIdentifier leafIdentifier) {
        if (this.leafSubstructures.containsKey(leafIdentifier)) {
            List<Integer> atomsToBeRemoved = this.leafSubstructures.get(leafIdentifier).getAllAtoms().stream().map(Atom::getAtomIdentifier).collect(Collectors.toList());
            atomsToBeRemoved.forEach(this::removeAtom);
            this.leafSubstructures.remove(leafIdentifier);
            this.consecutiveIdentifiers.remove(leafIdentifier);
            return true;
        }
        return false;
    }

    @Override
    public Optional<Atom> getAtom(Integer atomIdentifier) {
        for (LeafSubstructure leafSubstructure : this.leafSubstructures.values()) {
            Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
            if (!optionalAtom.isPresent()) continue;
            return optionalAtom;
        }
        return Optional.empty();
    }

    @Override
    public void removeAtom(Integer atomIdentifier) {
        for (LeafSubstructure leafSubstructure : this.leafSubstructures.values()) {
            Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
            if (!optionalAtom.isPresent()) continue;
            leafSubstructure.removeAtom(optionalAtom.get().getAtomIdentifier());
            return;
        }
    }

    public void connectChainBackbone() {
        OakLeafSubstructure<?> lastSubstructure = null;
        for (OakLeafSubstructure<?> currentSubstructure : this.leafSubstructures.values()) {
            if (lastSubstructure != null) {
                if (lastSubstructure instanceof AminoAcid && currentSubstructure instanceof AminoAcid) {
                    this.connectPeptideBonds((OakAminoAcid)lastSubstructure, (OakAminoAcid)currentSubstructure);
                } else if (lastSubstructure instanceof Nucleotide && currentSubstructure instanceof Nucleotide) {
                    this.connectNucleotideBonds((OakNucleotide)lastSubstructure, (OakNucleotide)currentSubstructure);
                }
            }
            lastSubstructure = currentSubstructure;
        }
    }

    public void connectPeptideBonds(OakAminoAcid source, OakAminoAcid target) {
        Optional<Atom> sourceAtomOptional = source.getAtomByName("C");
        Optional<Atom> targetAtomOptional = target.getAtomByName("N");
        if (sourceAtomOptional.isPresent() && targetAtomOptional.isPresent()) {
            source.addBondBetween((OakAtom)sourceAtomOptional.get(), (OakAtom)targetAtomOptional.get());
        }
    }

    public void connectNucleotideBonds(OakNucleotide source, OakNucleotide target) {
        Optional<Atom> sourceAtomOptional = source.getAtomByName("O3'");
        Optional<Atom> targetAtomOptional = target.getAtomByName("P");
        if (sourceAtomOptional.isPresent() && targetAtomOptional.isPresent()) {
            source.addBondBetween((OakAtom)sourceAtomOptional.get(), (OakAtom)targetAtomOptional.get());
        }
    }

    public List<LeafSubstructure<?>> getConsecutivePart() {
        ArrayList consecutivePart = new ArrayList();
        for (LeafSubstructure leafSubstructure : this.leafSubstructures.values()) {
            if (!this.consecutiveIdentifiers.contains(leafSubstructure.getIdentifier())) continue;
            consecutivePart.add(leafSubstructure);
        }
        return consecutivePart;
    }

    public List<LeafSubstructure<?>> getNonConsecutivePart() {
        ArrayList consecutivePart = new ArrayList();
        for (LeafSubstructure leafSubstructure : this.leafSubstructures.values()) {
            if (this.consecutiveIdentifiers.contains(leafSubstructure.getIdentifier())) continue;
            consecutivePart.add(leafSubstructure);
        }
        return consecutivePart;
    }

    public LeafIdentifier getNextLeafIdentifier() {
        LeafIdentifier lastLeafIdentifier = this.leafSubstructures.lastEntry().getKey();
        return new LeafIdentifier(lastLeafIdentifier.getPdbIdentifier(), lastLeafIdentifier.getModelIdentifier(), lastLeafIdentifier.getChainIdentifier(), lastLeafIdentifier.getSerial() + 1);
    }

    @Override
    public OakChain getCopy() {
        return new OakChain(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OakChain oakChain = (OakChain)o;
        return this.identifier != null ? this.identifier.equals(oakChain.identifier) : oakChain.identifier == null;
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    public String toString() {
        return this.flatToString();
    }
}

