/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.structure.model.families.StructuralFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.oak.BondType;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.OakBond;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public abstract class OakLeafSubstructure<FamilyType extends StructuralFamily>
implements LeafSubstructure<FamilyType> {
    private final LeafIdentifier leafIdentifier;
    private final FamilyType family;
    private final String divergingThreeLetterCode;
    private final Map<Integer, OakAtom> atoms;
    private final Map<Integer, OakBond> bonds;
    private final Set<FamilyType> exchangeableFamilies;
    private int nextEdgeIdentifier = 0;
    private boolean annotatedAsHetAtom;

    public OakLeafSubstructure(LeafIdentifier leafIdentifier, FamilyType family) {
        this.leafIdentifier = leafIdentifier;
        this.divergingThreeLetterCode = "";
        this.family = family;
        this.atoms = new TreeMap<Integer, OakAtom>();
        this.bonds = new HashMap<Integer, OakBond>();
        this.exchangeableFamilies = new HashSet<FamilyType>();
    }

    public OakLeafSubstructure(LeafIdentifier identifer, FamilyType aminoAcidFamily, String threeLetterCode) {
        this.leafIdentifier = identifer;
        this.family = aminoAcidFamily;
        this.divergingThreeLetterCode = threeLetterCode;
        this.atoms = new TreeMap<Integer, OakAtom>();
        this.bonds = new HashMap<Integer, OakBond>();
        this.exchangeableFamilies = new HashSet<FamilyType>();
    }

    public OakLeafSubstructure(OakLeafSubstructure<FamilyType> leafSubstructure) {
        this(leafSubstructure.leafIdentifier, leafSubstructure.family);
        for (OakAtom atom : leafSubstructure.atoms.values()) {
            this.atoms.put(atom.getAtomIdentifier(), atom.getCopy());
        }
        for (OakBond bond : leafSubstructure.bonds.values()) {
            OakBond edgeCopy = bond.getCopy();
            OakAtom sourceCopy = this.atoms.get(bond.getSource().getAtomIdentifier());
            OakAtom targetCopy = this.atoms.get(bond.getTarget().getAtomIdentifier());
            this.addBondBetween(edgeCopy, sourceCopy, targetCopy);
        }
        this.exchangeableFamilies.addAll(leafSubstructure.getExchangeableFamilies());
        this.annotatedAsHetAtom = leafSubstructure.annotatedAsHetAtom;
    }

    @Override
    public LeafIdentifier getIdentifier() {
        return this.leafIdentifier;
    }

    @Override
    public boolean containsAtomWithName(String atomName) {
        return this.getAtomByName(atomName).isPresent();
    }

    @Override
    public Optional<Atom> getAtomByName(String atomName) {
        for (OakAtom graphAtom : this.atoms.values()) {
            if (!graphAtom.getAtomName().equals(atomName)) continue;
            return Optional.of(graphAtom);
        }
        return Optional.empty();
    }

    @Override
    public boolean isAnnotatedAsHeteroAtom() {
        return this.annotatedAsHetAtom;
    }

    public void setAnnotatedAsHetAtom(boolean annotatedAsHetAtom) {
        this.annotatedAsHetAtom = annotatedAsHetAtom;
    }

    @Override
    public String getThreeLetterCode() {
        if (this.divergingThreeLetterCode.isEmpty()) {
            return this.family.getThreeLetterCode();
        }
        return this.divergingThreeLetterCode;
    }

    @Override
    public FamilyType getFamily() {
        return this.family;
    }

    @Override
    public List<Atom> getAllAtoms() {
        return new ArrayList<Atom>(this.atoms.values());
    }

    @Override
    public Optional<Atom> getAtom(Integer atomIdentifier) {
        if (this.atoms.containsKey(atomIdentifier)) {
            return Optional.of(this.atoms.get(atomIdentifier));
        }
        return Optional.empty();
    }

    public void addAtom(OakAtom atom) {
        this.atoms.put(atom.getAtomIdentifier(), atom);
    }

    @Override
    public void removeAtom(Integer atomIdentifier) {
        OakAtom atom = this.atoms.get(atomIdentifier);
        if (atom != null) {
            for (OakAtom neighbor : atom.getNeighbours()) {
                neighbor.getNeighbours().remove(atom);
            }
            this.atoms.remove(atom.getAtomIdentifier());
            this.bonds.entrySet().removeIf(edge -> ((OakBond)edge.getValue()).connectsAtom(atom));
        }
    }

    public Collection<OakBond> getBonds() {
        return this.bonds.values();
    }

    public int addBondBetween(OakBond edge, OakAtom source, OakAtom target) {
        if (source == null || target == null) {
            return -1;
        }
        edge.setSource(source);
        edge.setTarget(target);
        this.bonds.put(edge.getIdentifier(), edge);
        source.addNeighbour(target);
        target.addNeighbour(source);
        return edge.getIdentifier();
    }

    public int addBondBetween(OakAtom source, OakAtom target) {
        return this.addBondBetween(source, target, BondType.SINGLE_BOND);
    }

    public int addBondBetween(OakAtom source, OakAtom target, BondType bondType) {
        if (source == null || target == null) {
            return -1;
        }
        OakBond bond = new OakBond(this.nextEdgeIdentifier++, bondType);
        bond.setSource(source);
        bond.setTarget(target);
        this.bonds.put(bond.getIdentifier(), bond);
        source.addNeighbour(target);
        target.addNeighbour(source);
        return bond.getIdentifier();
    }

    @Override
    public Set<FamilyType> getExchangeableFamilies() {
        return this.exchangeableFamilies;
    }

    @Override
    public void addExchangeableFamily(FamilyType exchangeableType) {
        this.exchangeableFamilies.add(exchangeableType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OakLeafSubstructure that = (OakLeafSubstructure)o;
        if (this.leafIdentifier != null ? !this.leafIdentifier.equals(that.leafIdentifier) : that.leafIdentifier != null) {
            return false;
        }
        return this.family != null ? this.family.equals(that.family) : that.family == null;
    }

    public int hashCode() {
        int result = this.leafIdentifier != null ? this.leafIdentifier.hashCode() : 0;
        result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.flatToString();
    }

    public int getNextEdgeIdentifier() {
        return this.nextEdgeIdentifier++;
    }
}

