/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.Model;
import de.bioforscher.singa.structure.model.oak.OakChain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class OakModel
implements Model {
    private final Integer identifier;
    private final TreeMap<String, OakChain> chains;

    public OakModel(int identifier) {
        this.identifier = identifier;
        this.chains = new TreeMap();
    }

    public OakModel(OakModel model) {
        this.identifier = model.getModelIdentifier();
        this.chains = new TreeMap();
        for (OakChain chain : model.chains.values()) {
            this.chains.put(chain.getChainIdentifier(), chain.getCopy());
        }
    }

    @Override
    public Integer getModelIdentifier() {
        return this.identifier;
    }

    @Override
    public Chain getFirstChain() {
        return this.chains.firstEntry().getValue();
    }

    @Override
    public List<Chain> getAllChains() {
        return new ArrayList<Chain>(this.chains.values());
    }

    @Override
    public Set<String> getAllChainIdentifiers() {
        return new HashSet<String>(this.chains.keySet());
    }

    @Override
    public Optional<Chain> getChain(String chainIdentifier) {
        if (this.chains.containsKey(chainIdentifier)) {
            return Optional.of(this.chains.get(chainIdentifier));
        }
        return Optional.empty();
    }

    public void addChain(OakChain chain) {
        this.chains.put(chain.getChainIdentifier(), chain);
    }

    @Override
    public void removeChain(String chainIdentifier) {
        this.chains.remove(chainIdentifier);
    }

    @Override
    public List<LeafSubstructure<?>> getAllLeafSubstructures() {
        ArrayList allLeafSubstructures = new ArrayList();
        for (Chain chain : this.chains.values()) {
            List<LeafSubstructure<?>> leafSubstructures = chain.getAllLeafSubstructures();
            allLeafSubstructures.addAll(leafSubstructures);
        }
        return allLeafSubstructures;
    }

    @Override
    public Optional<LeafSubstructure<?>> getLeafSubstructure(LeafIdentifier leafIdentifier) {
        for (Chain chain : this.chains.values()) {
            Optional<LeafSubstructure<?>> optionalLeafSubstructure = chain.getLeafSubstructure(leafIdentifier);
            if (!optionalLeafSubstructure.isPresent()) continue;
            return optionalLeafSubstructure;
        }
        return Optional.empty();
    }

    @Override
    public LeafSubstructure<?> getFirstLeafSubstructure() {
        return this.getFirstChain().getFirstLeafSubstructure();
    }

    @Override
    public boolean removeLeafSubstructure(LeafIdentifier leafIdentifier) {
        for (Chain chain : this.chains.values()) {
            Optional<LeafSubstructure<?>> optionalLeafSubstructure = chain.getLeafSubstructure(leafIdentifier);
            if (!optionalLeafSubstructure.isPresent()) continue;
            chain.removeLeafSubstructure(optionalLeafSubstructure.get().getIdentifier());
            return true;
        }
        return false;
    }

    @Override
    public Optional<Atom> getAtom(Integer atomIdentifier) {
        for (Chain chain : this.chains.values()) {
            List<LeafSubstructure<?>> allLeafSubstructures = chain.getAllLeafSubstructures();
            for (LeafSubstructure<?> leafSubstructure : allLeafSubstructures) {
                Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
                if (!optionalAtom.isPresent()) continue;
                return optionalAtom;
            }
        }
        return Optional.empty();
    }

    @Override
    public void removeAtom(Integer atomIdentifier) {
        for (Chain chain : this.chains.values()) {
            List<LeafSubstructure<?>> allLeafSubstructures = chain.getAllLeafSubstructures();
            for (LeafSubstructure<?> leafSubstructure : allLeafSubstructures) {
                Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
                optionalAtom.ifPresent(atom -> leafSubstructure.removeAtom(atomIdentifier));
            }
        }
    }

    @Override
    public OakModel getCopy() {
        return new OakModel(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OakModel model = (OakModel)o;
        return this.identifier != null ? this.identifier.equals(model.identifier) : model.identifier == null;
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    public String toString() {
        return this.flatToString();
    }
}

