/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.structure.elements.ElementProvider;
import de.bioforscher.singa.structure.model.families.LigandFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.identifiers.PDBIdentifier;
import de.bioforscher.singa.structure.model.identifiers.UniqueAtomIdentifer;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.Model;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.OakChain;
import de.bioforscher.singa.structure.model.oak.OakLigand;
import de.bioforscher.singa.structure.model.oak.OakModel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class OakStructure
implements Structure {
    private final TreeMap<Integer, OakModel> models;
    private String pdbIdentifier;
    private String title;
    private int lastAddedAtomIdentifier;

    public OakStructure() {
        this.models = new TreeMap();
    }

    public OakStructure(OakStructure structure) {
        this.pdbIdentifier = structure.getPdbIdentifier();
        this.title = structure.title;
        this.models = new TreeMap();
        this.lastAddedAtomIdentifier = structure.lastAddedAtomIdentifier;
        for (OakModel model : structure.models.values()) {
            this.models.put(model.getModelIdentifier(), model.getCopy());
        }
    }

    @Override
    public String getPdbIdentifier() {
        return this.pdbIdentifier;
    }

    public void setPdbIdentifier(String pdbIdentifier) {
        if (!PDBIdentifier.PATTERN.matcher(pdbIdentifier).matches() && !pdbIdentifier.equals("0000")) {
            throw new IllegalArgumentException("The pdb identifier must match to the pdb identifier pattern.");
        }
        this.pdbIdentifier = pdbIdentifier.toLowerCase();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public List<Model> getAllModels() {
        return new ArrayList<Model>(this.models.values());
    }

    @Override
    public Set<Integer> getAllModelIdentifiers() {
        return new HashSet<Integer>(this.models.keySet());
    }

    @Override
    public Model getFirstModel() {
        return this.models.firstEntry().getValue();
    }

    @Override
    public Optional<Model> getModel(int modelIdentifier) {
        if (this.models.containsKey(modelIdentifier)) {
            return Optional.of(this.models.get(modelIdentifier));
        }
        return Optional.empty();
    }

    @Override
    public void removeModel(int modelIdentifier) {
        this.models.remove(modelIdentifier);
    }

    public void addModel(OakModel model) {
        this.models.put(model.getModelIdentifier(), model);
    }

    @Override
    public Optional<Chain> getChain(int modelIdentifier, String chainIdentifier) {
        Optional<Model> optionalModel = this.getModel(modelIdentifier);
        return optionalModel.flatMap(model -> model.getChain(chainIdentifier));
    }

    @Override
    public List<Chain> getAllChains() {
        ArrayList<Chain> allChains = new ArrayList<Chain>();
        for (OakModel model : this.models.values()) {
            allChains.addAll(model.getAllChains());
        }
        return allChains;
    }

    @Override
    public Chain getFirstChain() {
        return this.getFirstModel().getFirstChain();
    }

    @Override
    public List<LeafSubstructure<?>> getAllLeafSubstructures() {
        ArrayList allLeafSubstructures = new ArrayList();
        for (OakModel model : this.models.values()) {
            allLeafSubstructures.addAll(model.getAllLeafSubstructures());
        }
        return allLeafSubstructures;
    }

    @Override
    public Optional<LeafSubstructure<?>> getLeafSubstructure(LeafIdentifier leafIdentifier) {
        Optional<Chain> chainOptional = this.getChain(leafIdentifier.getModelIdentifier(), leafIdentifier.getChainIdentifier());
        return chainOptional.flatMap(chain -> chain.getLeafSubstructure(leafIdentifier));
    }

    @Override
    public LeafSubstructure<?> getFirstLeafSubstructure() {
        return this.getFirstModel().getFirstChain().getFirstLeafSubstructure();
    }

    @Override
    public boolean removeLeafSubstructure(LeafIdentifier leafIdentifier) {
        Optional<Chain> chain = this.getChain(leafIdentifier.getModelIdentifier(), leafIdentifier.getChainIdentifier());
        if (chain.isPresent() && chain.get().getLeafSubstructure(leafIdentifier).isPresent()) {
            chain.get().removeLeafSubstructure(leafIdentifier);
            return true;
        }
        this.getAllAtoms();
        return false;
    }

    @Override
    public Optional<Atom> getAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            Optional<Atom> atom = leafSubstructure.getAtom(atomIdentifier);
            if (!atom.isPresent()) continue;
            return atom;
        }
        return Optional.empty();
    }

    public Optional<Map.Entry<UniqueAtomIdentifer, Atom>> getUniqueAtomEntry(int atomSerial) {
        for (Model model : this.getAllModels()) {
            for (Chain chain : model.getAllChains()) {
                for (LeafSubstructure<?> leafSubstructure : chain.getAllLeafSubstructures()) {
                    for (Atom atom : leafSubstructure.getAllAtoms()) {
                        if (!atom.getAtomIdentifier().equals(atomSerial)) continue;
                        UniqueAtomIdentifer identifier = new UniqueAtomIdentifer(this.pdbIdentifier, model.getModelIdentifier(), chain.getChainIdentifier(), leafSubstructure.getIdentifier().getSerial(), leafSubstructure.getIdentifier().getInsertionCode(), atomSerial);
                        return Optional.of(new AbstractMap.SimpleEntry<UniqueAtomIdentifer, Atom>(identifier, atom));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public void addAtom(String chainIdentifier, String threeLetterCode, Vector3D position) {
        OakLigand leafSubstructure;
        OakChain chain;
        Optional<Chain> optionalChain = this.getFirstModel().getChain(chainIdentifier);
        if (optionalChain.isPresent()) {
            chain = (OakChain)optionalChain.get();
            leafSubstructure = new OakLigand(chain.getNextLeafIdentifier(), new LigandFamily(threeLetterCode));
            ++this.lastAddedAtomIdentifier;
        } else {
            throw new IllegalStateException("Unable to add atom to chain " + chainIdentifier + ", chain could not be found.");
        }
        leafSubstructure.addAtom(new OakAtom(this.lastAddedAtomIdentifier, ElementProvider.UNKOWN, "CA", position));
        chain.addLeafSubstructure(leafSubstructure);
    }

    @Override
    public void removeAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.getAllLeafSubstructures()) {
            Optional<Atom> atom = leafSubstructure.getAtom(atomIdentifier);
            if (!atom.isPresent()) continue;
            leafSubstructure.removeAtom(atomIdentifier);
            return;
        }
    }

    public int getLastAddedAtomIdentifier() {
        return this.lastAddedAtomIdentifier;
    }

    public void setLastAddedAtomIdentifier(int lastAddedAtomIdentifier) {
        this.lastAddedAtomIdentifier = lastAddedAtomIdentifier;
    }

    @Override
    public Structure getCopy() {
        return new OakStructure(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OakStructure that = (OakStructure)o;
        return this.pdbIdentifier != null ? this.pdbIdentifier.equals(that.pdbIdentifier) : that.pdbIdentifier == null;
    }

    public int hashCode() {
        return this.pdbIdentifier != null ? this.pdbIdentifier.hashCode() : 0;
    }

    public String toString() {
        return this.flatToString();
    }
}

