/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.core.utility.Range;
import de.bioforscher.singa.structure.elements.ElementProvider;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.Ligand;
import de.bioforscher.singa.structure.model.interfaces.Nucleotide;
import de.bioforscher.singa.structure.model.oak.AtomName;
import java.util.Objects;
import java.util.function.Predicate;

public class StructuralEntityFilter {

    public static final class AtomFilter {
        public static Predicate<Atom> hasAtomName(String atomName) {
            return atom -> Objects.equals(atom.getAtomName(), atomName);
        }

        public static Predicate<Atom> hasAtomName(AtomName atomName) {
            return atom -> Objects.equals(atom.getAtomName(), atomName.getName());
        }

        public static Predicate<Atom> hasAtomNames(String ... atomNames) {
            Predicate<Atom> predicate = atom -> false;
            for (String atomName : atomNames) {
                predicate = predicate.or(AtomFilter.hasAtomName(atomName));
            }
            return predicate;
        }

        public static Predicate<Atom> hasIdentifier(int identifier) {
            return atom -> atom.getAtomIdentifier() == identifier;
        }

        public static Predicate<Atom> isAlphaCarbon() {
            return atom -> Objects.equals(atom.getAtomName(), AtomName.CA.getName());
        }

        public static Predicate<Atom> isArbitrary() {
            return atom -> true;
        }

        public static Predicate<Atom> isBackbone() {
            return atom -> Objects.equals(atom.getAtomName(), AtomName.N.getName()) || Objects.equals(atom.getAtomName(), AtomName.CA.getName()) || Objects.equals(atom.getAtomName(), AtomName.C.getName()) || Objects.equals(atom.getAtomName(), AtomName.O.getName());
        }

        public static Predicate<Atom> isBackboneCarbon() {
            return AtomFilter.isBackbone().and(AtomFilter.isCarbon()).and(AtomFilter.isAlphaCarbon().negate());
        }

        public static Predicate<Atom> isBackboneNitrogen() {
            return AtomFilter.isBackbone().and(AtomFilter.isNitrogen());
        }

        public static Predicate<Atom> isBackboneOxygen() {
            return AtomFilter.isBackbone().and(AtomFilter.isOxygen());
        }

        public static Predicate<Atom> isBetaCarbon() {
            return atom -> Objects.equals(atom.getAtomName(), AtomName.CB.getName());
        }

        public static Predicate<Atom> isCarbon() {
            return atom -> atom.getElement().equals(ElementProvider.CARBON);
        }

        public static Predicate<Atom> isHydrogen() {
            return atom -> atom.getElement().equals(ElementProvider.HYDROGEN);
        }

        public static Predicate<Atom> isNitrogen() {
            return atom -> atom.getElement().equals(ElementProvider.NITROGEN);
        }

        public static Predicate<Atom> isOxygen() {
            return atom -> atom.getElement().equals(ElementProvider.OXYGEN);
        }

        public static Predicate<Atom> isPhosphorus() {
            return atom -> Objects.equals(atom.getAtomName(), AtomName.P.getName());
        }

        public static Predicate<Atom> isSideChain() {
            return AtomFilter.isBackbone().negate();
        }

        public static Predicate<Atom> isWithinRange(int startId, int endId) {
            Range range = new Range((Comparable)Integer.valueOf(startId), (Comparable)Integer.valueOf(endId));
            return atom -> range.isInRange((Comparable)atom.getAtomIdentifier());
        }
    }

    public static final class LeafFilter {
        public static Predicate<LeafSubstructure> hasIdentifier(Object identifier) {
            return leafSubstructure -> leafSubstructure.getIdentifier().equals(identifier);
        }

        public static Predicate<LeafSubstructure> isAminoAcid() {
            return leaf -> leaf instanceof AminoAcid;
        }

        public static Predicate<LeafSubstructure> isLigand() {
            return leaf -> leaf instanceof Ligand;
        }

        public static Predicate<LeafSubstructure> isNucleotide() {
            return leaf -> leaf instanceof Nucleotide;
        }

        public static Predicate<LeafSubstructure> isWithinRange(int startIdentifier, int endIdentifier) {
            Range range = new Range((Comparable)Integer.valueOf(startIdentifier), (Comparable)Integer.valueOf(endIdentifier));
            return leaf -> range.isInRange((Comparable)Integer.valueOf(leaf.getIdentifier().getSerial()));
        }
    }

    public static final class ChainFilter {
        public static Predicate<Chain> isInChain(String chainIdentifier) {
            return chain -> chainIdentifier.equals(chain.getChainIdentifier());
        }
    }

    public static enum AtomFilterType {
        ALPHA_CARBON(AtomFilter.isAlphaCarbon(), "alpha carbon"),
        ARBITRARY(AtomFilter.isArbitrary(), "all-atom"),
        BACKBONE(AtomFilter.isBackbone(), "backbone"),
        BACKBONE_CARBON(AtomFilter.isBackboneCarbon(), "backbone carbon"),
        BACKBONE_NITROGEN(AtomFilter.isBackboneNitrogen(), "backbone nitrogen"),
        BACKBONE_OXYGEN(AtomFilter.isBackboneOxygen(), "backbone oxygen"),
        BETA_CARBON(AtomFilter.isBetaCarbon(), "beta carbon"),
        CARBON(AtomFilter.isCarbon(), "any carbon atom"),
        HYDROGEN(AtomFilter.isHydrogen(), "any hydrogen atom"),
        NITROGEN(AtomFilter.isNitrogen(), "any nitrogen atom"),
        OXYGEN(AtomFilter.isOxygen(), "any oxygen atom"),
        PHOSPHORUS(AtomFilter.isPhosphorus(), "any phosphorus atom"),
        SIDE_CHAIN(AtomFilter.isSideChain(), "side chain");

        private final Predicate<Atom> filter;
        private final String description;

        private AtomFilterType(Predicate<Atom> filter, String description) {
            this.filter = filter;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public Predicate<Atom> getFilter() {
            return this.filter;
        }
    }

    public static enum LeafFilterType {
        AMINO_ACID(LeafFilter.isAminoAcid()),
        ATOM_CONTAINER(LeafFilter.isLigand()),
        NUCLEOTIDE(LeafFilter.isNucleotide());

        private final Predicate<LeafSubstructure> filter;

        private LeafFilterType(Predicate<LeafSubstructure> filter) {
            this.filter = filter;
        }

        public Predicate<LeafSubstructure> getFilter() {
            return this.filter;
        }
    }
}

