/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.families.MatcherFamily;
import de.bioforscher.singa.structure.model.families.NucleotideFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.interfaces.Nucleotide;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

public class StructuralMotif
implements LeafSubstructureContainer {
    public final LinkedHashMap<LeafIdentifier, LeafSubstructure<?>> leafSubstructures;
    private final String identifier;

    private StructuralMotif(String identifier) {
        this.identifier = identifier;
        this.leafSubstructures = new LinkedHashMap();
    }

    private StructuralMotif(String identifier, List<LeafSubstructure<?>> leafSubstructures) {
        this(identifier);
        for (LeafSubstructure<?> leafSubstructure : leafSubstructures) {
            this.addLeafSubstructure(leafSubstructure);
        }
    }

    private StructuralMotif(StructuralMotif structuralMotif) {
        this(structuralMotif.identifier);
        for (LeafSubstructure<?> leafSubstructure : structuralMotif.leafSubstructures.values()) {
            this.addLeafSubstructure(leafSubstructure);
        }
    }

    public static StructuralMotif fromLeafIdentifiers(Structure structure, List<LeafIdentifier> leafIdentifiers) {
        ArrayList leafSubstructures = new ArrayList();
        for (LeafIdentifier leafIdentifier : leafIdentifiers) {
            leafIdentifier = new LeafIdentifier(structure.getPdbIdentifier(), leafIdentifier.getModelIdentifier(), leafIdentifier.getChainIdentifier(), leafIdentifier.getSerial(), leafIdentifier.getInsertionCode());
            Optional<LeafSubstructure<?>> leafSubstructure = structure.getLeafSubstructure(leafIdentifier);
            if (leafSubstructure.isPresent()) {
                leafSubstructures.add(leafSubstructure.get());
                continue;
            }
            throw new NoSuchElementException("Unable to add leaf substructure with identifier " + leafIdentifier + " from structure " + structure.getPdbIdentifier());
        }
        return new StructuralMotif(StructuralMotif.generateMotifIdentifier(leafSubstructures), leafSubstructures);
    }

    public static StructuralMotif fromLeafSubstructures(List<LeafSubstructure<?>> leafSubstructures) {
        return new StructuralMotif(StructuralMotif.generateMotifIdentifier(leafSubstructures), leafSubstructures);
    }

    private static String generateMotifIdentifier(List<LeafSubstructure<?>> substructures) {
        String pdbIdentifier = substructures.iterator().next().getIdentifier().getPdbIdentifier();
        return substructures.stream().map(leafSubstructure -> leafSubstructure.getIdentifier().getChainIdentifier() + "-" + leafSubstructure.getIdentifier().getSerial() + (leafSubstructure.getIdentifier().getInsertionCode() == '\u0000' ? "" : Character.valueOf(leafSubstructure.getIdentifier().getInsertionCode()))).collect(Collectors.joining("_", pdbIdentifier + "_", ""));
    }

    @Override
    public List<LeafSubstructure<?>> getAllLeafSubstructures() {
        return new LinkedList(this.leafSubstructures.values());
    }

    @Override
    public Optional<LeafSubstructure<?>> getLeafSubstructure(LeafIdentifier leafIdentifier) {
        LeafSubstructure<?> leafSubstructure = this.leafSubstructures.get(leafIdentifier);
        if (leafSubstructure != null) {
            return Optional.of(leafSubstructure);
        }
        return Optional.empty();
    }

    @Override
    public LeafSubstructure<?> getFirstLeafSubstructure() {
        return this.leafSubstructures.values().iterator().next();
    }

    @Override
    public boolean removeLeafSubstructure(LeafIdentifier leafIdentifier) {
        LeafSubstructure leafSubstructure = (LeafSubstructure)this.leafSubstructures.remove(leafIdentifier);
        return leafSubstructure != null;
    }

    public void addLeafSubstructure(LeafSubstructure leafSubstructure) {
        this.leafSubstructures.put(leafSubstructure.getIdentifier(), leafSubstructure);
    }

    public int size() {
        return this.leafSubstructures.size();
    }

    @Override
    public Optional<Atom> getAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.leafSubstructures.values()) {
            Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
            if (!optionalAtom.isPresent()) continue;
            return optionalAtom;
        }
        return Optional.empty();
    }

    @Override
    public void removeAtom(Integer atomIdentifier) {
        for (LeafSubstructure<?> leafSubstructure : this.leafSubstructures.values()) {
            Optional<Atom> optionalAtom = leafSubstructure.getAtom(atomIdentifier);
            if (!optionalAtom.isPresent()) continue;
            leafSubstructure.removeAtom(atomIdentifier);
            return;
        }
    }

    public void addExchangeableFamily(LeafIdentifier leafIdentifier, MatcherFamily matcherFamily) {
        matcherFamily.getMembers().forEach(matcherFamilyMember -> this.addExchangeableFamily(leafIdentifier, (AminoAcidFamily)matcherFamilyMember));
    }

    public void addExchangeableFamily(LeafIdentifier leafIdentifier, NucleotideFamily nucleotideFamily) {
        this.leafSubstructures.values().stream().filter(StructuralEntityFilter.LeafFilter.isNucleotide()).map(Nucleotide.class::cast).filter(nucleotide -> nucleotide.getIdentifier().getChainIdentifier().equals(leafIdentifier.getChainIdentifier())).filter(nucleotide -> nucleotide.getIdentifier().getSerial() == leafIdentifier.getSerial()).findFirst().orElseThrow(NoSuchElementException::new).addExchangeableFamily(nucleotideFamily);
    }

    public void addExchangeableFamily(LeafIdentifier leafIdentifier, AminoAcidFamily aminoAcidFamily) {
        this.leafSubstructures.values().stream().filter(StructuralEntityFilter.LeafFilter.isAminoAcid()).map(AminoAcid.class::cast).filter(aminoAcid -> aminoAcid.getIdentifier().getChainIdentifier().equals(leafIdentifier.getChainIdentifier())).filter(aminoAcid -> aminoAcid.getIdentifier().getSerial() == leafIdentifier.getSerial()).findFirst().orElseThrow(NoSuchElementException::new).addExchangeableFamily(aminoAcidFamily);
    }

    public void addExchangeableFamilyToAll(AminoAcidFamily aminoAcidFamily) {
        this.leafSubstructures.values().stream().filter(StructuralEntityFilter.LeafFilter.isAminoAcid()).map(AminoAcid.class::cast).forEach(exchangeable -> exchangeable.addExchangeableFamily(aminoAcidFamily));
    }

    public void addExchangeableFamilyToAll(NucleotideFamily nucleotideFamily) {
        this.leafSubstructures.values().stream().filter(StructuralEntityFilter.LeafFilter.isNucleotide()).map(Nucleotide.class::cast).forEach(exchangeable -> exchangeable.addExchangeableFamily(nucleotideFamily));
    }

    public void addExchangeableFamilyToAll(MatcherFamily matcherFamily) {
        this.leafSubstructures.values().forEach(leafSubstructure -> matcherFamily.getMembers().forEach(matcherFamilyMember -> this.addExchangeableFamily(leafSubstructure.getIdentifier(), (AminoAcidFamily)matcherFamilyMember)));
    }

    public String toString() {
        return StructuralMotif.generateMotifIdentifier(this.getAllLeafSubstructures());
    }

    public StructuralMotif getCopy() {
        return new StructuralMotif(this);
    }

    public static enum Type {
        INTRA("intra"),
        INTER("inter");

        private final String description;

        private Type(String name) {
            this.description = name;
        }

        public static Type determine(StructuralMotif structuralMotif) {
            return structuralMotif.getAllLeafSubstructures().stream().map(LeafSubstructure::getChainIdentifier).distinct().count() == 1L ? INTRA : INTER;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

