/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.model.oak;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.geometry.bodies.Sphere;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.matrices.Matrices;
import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.AtomContainer;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Structures {
    private Structures() {
    }

    public static LabeledSymmetricMatrix<LeafSubstructure<?>> calculateDistanceMatrix(LeafSubstructureContainer leafSubstructureContainer) {
        return VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistancesPairwise(leafSubstructureContainer.getAllLeafSubstructures(), LeafSubstructure::getPosition);
    }

    public static LabeledSymmetricMatrix<LeafSubstructure<?>> calculateSquaredDistanceMatrix(LeafSubstructureContainer leafSubstructureContainer) {
        return VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistancesPairwise(leafSubstructureContainer.getAllLeafSubstructures(), LeafSubstructure::getPosition);
    }

    public static double calculateExtent(LeafSubstructureContainer leafSubstructureContainer) {
        return Math.sqrt(Structures.calculateSquaredExtent(leafSubstructureContainer));
    }

    public static double calculateSquaredExtent(LeafSubstructureContainer leafSubstructureContainer) {
        LabeledSymmetricMatrix<LeafSubstructure<?>> queryDistanceMatrix = Structures.calculateSquaredDistanceMatrix(leafSubstructureContainer);
        Pair positionOfMaximalElement = (Pair)Matrices.getPositionsOfMaximalElement(queryDistanceMatrix).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("could not determine the maximal squared extent of " + leafSubstructureContainer));
        return queryDistanceMatrix.getElement(((Integer)positionOfMaximalElement.getFirst()).intValue(), ((Integer)positionOfMaximalElement.getSecond()).intValue());
    }

    public static LabeledSymmetricMatrix<Atom> calculateAtomDistanceMatrix(AtomContainer atomContainer) {
        return VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistancesPairwise(atomContainer.getAllAtoms(), Atom::getPosition);
    }

    public static LabeledSymmetricMatrix<Atom> calculateAtomDistanceMatrix(List<Atom> atoms) {
        return VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistancesPairwise(atoms, Atom::getPosition);
    }

    public static boolean isAlphaCarbonStructure(Structure structure) {
        return structure.getAllAminoAcids().stream().map(AtomContainer::getAllAtoms).flatMap(Collection::stream).noneMatch(StructuralEntityFilter.AtomFilter.isAlphaCarbon().negate().and(StructuralEntityFilter.AtomFilter.isHydrogen().negate()));
    }

    public static boolean isBackboneStructure(Structure structure) {
        return structure.getAllAminoAcids().stream().map(AtomContainer::getAllAtoms).flatMap(Collection::stream).noneMatch(StructuralEntityFilter.AtomFilter.isBackbone().negate().and(StructuralEntityFilter.AtomFilter.isHydrogen().negate()).and(StructuralEntityFilter.AtomFilter.isBetaCarbon().negate()));
    }

    public static List<Sphere> convertToSpheres(AtomContainer atomContainer) {
        ArrayList<Sphere> spheres = new ArrayList<Sphere>();
        for (Atom atom : atomContainer.getAllAtoms()) {
            spheres.add(new Sphere(atom.getPosition(), atom.getElement().getVanDerWaalsRadius().getValue().doubleValue()));
        }
        return spheres;
    }
}

