/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.ligands;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.structure.elements.Element;
import de.bioforscher.singa.structure.elements.ElementProvider;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.families.LigandFamily;
import de.bioforscher.singa.structure.model.families.NucleotideFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.oak.BondType;
import de.bioforscher.singa.structure.model.oak.OakAminoAcid;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.OakBond;
import de.bioforscher.singa.structure.model.oak.OakLeafSubstructure;
import de.bioforscher.singa.structure.model.oak.OakLigand;
import de.bioforscher.singa.structure.model.oak.OakNucleotide;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.LeafSkeleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CifFileParser {
    private static final int DEFAULT_VALUE_SPACING = 49;
    private final List<String> lines;
    private final List<String> atomLines;
    private final List<String> bondLines;
    private final Map<String, OakAtom> atoms;
    private final Map<Pair<String>, BondType> bonds;
    private String name;
    private String type;
    private String oneLetterCode;
    private String threeLetterCode;
    private String parent;

    private CifFileParser(List<String> lines) {
        this.lines = lines;
        this.atoms = new HashMap<String, OakAtom>();
        this.bonds = new HashMap<Pair<String>, BondType>();
        this.bondLines = new ArrayList<String>();
        this.atomLines = new ArrayList<String>();
    }

    public static LeafSubstructure<?> parseLeafSubstructure(List<String> lines) {
        CifFileParser parser = new CifFileParser(lines);
        return parser.parseCompleteLeafSubstructure();
    }

    public static LeafSkeleton parseLeafSkeleton(List<String> lines) {
        CifFileParser parser = new CifFileParser(lines);
        return parser.parseLeafSkeleton();
    }

    private static String extractValue(String line) {
        return line.substring(49).replace("\"", "").trim();
    }

    private void collectLines(boolean skipAtoms) {
        boolean bondSection = false;
        boolean atomSection = false;
        for (String line : this.lines) {
            this.extractInformation(line);
            if (line.startsWith("_chem_comp_bond.pdbx_ordinal")) {
                bondSection = true;
                continue;
            }
            if (bondSection) {
                if (line.startsWith("#")) {
                    bondSection = false;
                    continue;
                }
                this.bondLines.add(line);
            }
            if (skipAtoms) continue;
            if (line.startsWith("_chem_comp_atom.pdbx_ordinal")) {
                atomSection = true;
                continue;
            }
            if (!atomSection) continue;
            if (line.startsWith("#")) {
                atomSection = false;
                continue;
            }
            this.atomLines.add(line);
        }
    }

    private void extractAtoms() {
        for (String line : this.atomLines) {
            String[] splitLine = line.split("\\s+");
            int identifier = Integer.valueOf(splitLine[17]);
            Element element = ElementProvider.getElementBySymbol(splitLine[3]).orElse(ElementProvider.UNKOWN);
            String atomName = splitLine[1];
            Vector3D coordinates = new Vector3D(Double.valueOf(splitLine[9]).doubleValue(), Double.valueOf(splitLine[10]).doubleValue(), Double.valueOf(splitLine[11]).doubleValue());
            OakAtom atom = new OakAtom(identifier, element, atomName, coordinates);
            this.atoms.put(atomName, atom);
        }
    }

    private void extractBonds() {
        for (String line : this.bondLines) {
            String[] splitLine = line.split("\\s+");
            this.bonds.put((Pair<String>)new Pair((Object)splitLine[1].replace("\"", ""), (Object)splitLine[2].replace("\"", "")), BondType.getBondTypeByCifName(splitLine[3]).orElse(BondType.SINGLE_BOND));
        }
    }

    private void extractInformation(String line) {
        if (line.startsWith("_chem_comp.name")) {
            this.name = CifFileParser.extractValue(line);
        }
        if (line.startsWith("_chem_comp.type")) {
            this.type = CifFileParser.extractValue(line);
        }
        if (line.startsWith("_chem_comp.one_letter_code")) {
            this.oneLetterCode = CifFileParser.extractValue(line);
        }
        if (line.startsWith("_chem_comp.three_letter_code")) {
            this.threeLetterCode = CifFileParser.extractValue(line);
        }
        if (line.startsWith("_chem_comp.mon_nstd_parent_comp_id")) {
            this.parent = CifFileParser.extractValue(line);
        }
    }

    private OakLeafSubstructure<?> parseCompleteLeafSubstructure() {
        this.collectLines(false);
        this.extractAtoms();
        this.extractBonds();
        return this.createLeafSubstructure(LeafIdentifier.fromSimpleString("A-1"));
    }

    private OakLeafSubstructure<?> createLeafSubstructure(LeafIdentifier leafIdentifier) {
        OakLeafSubstructure leafSubstructure;
        if (this.isNucleotide()) {
            Optional<NucleotideFamily> nucleotideFamily = NucleotideFamily.getNucleotideByThreeLetterCode(this.parent);
            leafSubstructure = nucleotideFamily.map(nucleotideFamily1 -> new OakNucleotide(leafIdentifier, (NucleotideFamily)nucleotideFamily1, this.threeLetterCode)).orElseGet(() -> new OakNucleotide(leafIdentifier, NucleotideFamily.getNucleotideByThreeLetterCode(this.threeLetterCode).orElseThrow(() -> new IllegalArgumentException("Could not create Nucleotide with three letter code" + this.threeLetterCode))));
        } else if (this.isAminoAcid()) {
            Optional<AminoAcidFamily> aminoAcidFamily = AminoAcidFamily.getAminoAcidTypeByThreeLetterCode(this.parent);
            leafSubstructure = aminoAcidFamily.map(aminoAcidFamily1 -> new OakAminoAcid(leafIdentifier, (AminoAcidFamily)aminoAcidFamily1, this.threeLetterCode)).orElseGet(() -> new OakAminoAcid(leafIdentifier, AminoAcidFamily.getAminoAcidTypeByThreeLetterCode(this.threeLetterCode).orElseThrow(() -> new IllegalArgumentException("Could not create Nucleotide with three letter code" + this.threeLetterCode))));
        } else {
            OakLigand OakLigand2 = new OakLigand(leafIdentifier, new LigandFamily(this.oneLetterCode, this.threeLetterCode));
            OakLigand2.setName(this.name);
            leafSubstructure = OakLigand2;
        }
        this.atoms.values().forEach(leafSubstructure::addAtom);
        this.connectAtoms(leafSubstructure);
        return leafSubstructure;
    }

    private LeafSkeleton parseLeafSkeleton() {
        this.collectLines(true);
        this.extractBonds();
        return this.createLeafSkeleton();
    }

    private LeafSkeleton createLeafSkeleton() {
        LeafSkeleton.AssignedFamily assignedFamily = this.isNucleotide() ? (!this.parent.equals("?") ? LeafSkeleton.AssignedFamily.MODIFIED_NUCLEOTIDE : LeafSkeleton.AssignedFamily.LIGAND) : (this.isAminoAcid() ? LeafSkeleton.AssignedFamily.MODIFIED_AMINO_ACID : LeafSkeleton.AssignedFamily.LIGAND);
        return new LeafSkeleton(this.threeLetterCode, this.parent, assignedFamily, this.bonds);
    }

    private boolean isNucleotide() {
        return this.type.equalsIgnoreCase("RNA LINKING") || this.type.equalsIgnoreCase("DNA LINKING");
    }

    private boolean isAminoAcid() {
        return this.type.equalsIgnoreCase("L-PEPTIDE LINKING");
    }

    private void connectAtoms(OakLeafSubstructure<?> leafWithAtoms) {
        int bondCounter = 0;
        for (Map.Entry<Pair<String>, BondType> bond : this.bonds.entrySet()) {
            OakBond oakBond = new OakBond(bondCounter++, bond.getValue());
            leafWithAtoms.addBondBetween(oakBond, this.atoms.get(bond.getKey().getFirst()), this.atoms.get(bond.getKey().getSecond()));
        }
    }
}

