/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.rest.cluster;

import de.bioforscher.singa.structure.model.identifiers.PDBIdentifier;
import de.bioforscher.singa.structure.parser.pdb.rest.PDBRestEndpoint;
import de.bioforscher.singa.structure.parser.pdb.rest.cluster.PDBSequenceClusterMember;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDBSequenceCluster
extends PDBRestEndpoint {
    private static final Pattern LINE_PATTERN = Pattern.compile("<pdbChain name=\"([0-9A-Z.]+)\" rank=\"(\\d+)\" />");
    private static final Logger logger = LoggerFactory.getLogger(PDBSequenceCluster.class);
    private static final String SEQUENCE_CLUSTER_ENDPOINT = "http://www.rcsb.org/pdb/rest/sequenceCluster?";
    private final PDBIdentifier pdbIdentifier;
    private final String chainIdentifier;
    private final PDBSequenceClusterIdentity identity;
    private List<PDBSequenceClusterMember> clusterMembers;

    public PDBSequenceCluster(String pdbIdentifier, String chainIdentifier, PDBSequenceClusterIdentity identity) {
        this.pdbIdentifier = new PDBIdentifier(pdbIdentifier);
        this.chainIdentifier = chainIdentifier;
        this.identity = identity;
        this.clusterMembers = new ArrayList<PDBSequenceClusterMember>();
        logger.info("calling PDB REST to obtain sequence cluster {}/{}", (Object)pdbIdentifier, (Object)chainIdentifier);
    }

    public static PDBSequenceCluster of(String pdbIdentifier, String chainIdentifier, PDBSequenceClusterIdentity identity) {
        return new PDBSequenceCluster(pdbIdentifier, chainIdentifier, identity).parse();
    }

    public List<PDBSequenceClusterMember> getClusterMembers() {
        return this.clusterMembers;
    }

    public PDBSequenceCluster parse() {
        this.setResource(this.getEndpoint());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("cluster", String.valueOf(this.identity.getIdentity()));
        parameterMap.put("structureId", this.pdbIdentifier.getIdentifier() + "." + this.chainIdentifier);
        this.fetchWithQuery(parameterMap);
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFetchResult()));
            TreeSet<Integer> ranks = new TreeSet<Integer>();
            while ((line = bufferedReader.readLine()) != null) {
                Matcher matcher = LINE_PATTERN.matcher(line = line.trim());
                if (!matcher.matches()) continue;
                String chainSpecification = matcher.group(1);
                String pdbIdentifier = chainSpecification.split("\\.")[0].toLowerCase();
                String chainIdentifier = chainSpecification.split("\\.")[1];
                int rank = Integer.parseInt(matcher.group(2));
                if (!ranks.contains(rank)) {
                    this.clusterMembers.add(new PDBSequenceClusterMember(rank, new PDBIdentifier(pdbIdentifier), chainIdentifier));
                } else {
                    logger.debug("ignored duplicate homomeric entry {}_{}", (Object)pdbIdentifier, (Object)chainIdentifier);
                }
                ranks.add(rank);
            }
            if (this.clusterMembers.isEmpty()) {
                throw new IllegalArgumentException("failed to obtain PDB sequence clusters for" + (Object)((Object)this.pdbIdentifier) + "/" + this.chainIdentifier);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to parse results for chain " + (Object)((Object)this.pdbIdentifier) + "." + this.chainIdentifier, e);
        }
        return this;
    }

    @Override
    protected String getEndpoint() {
        return SEQUENCE_CLUSTER_ENDPOINT;
    }

    public String[] getRepresentative() {
        if (!this.clusterMembers.isEmpty()) {
            PDBSequenceClusterMember representativeMember = this.clusterMembers.get(0);
            return new String[]{representativeMember.getPdbIdentifier().getIdentifier(), representativeMember.getChainIdentifier()};
        }
        throw new UnsupportedOperationException("Cannot retrieve representative member if no members are defined.");
    }

    public static enum PDBSequenceClusterIdentity {
        IDENTITY_100,
        IDENTITY_95,
        IDENTITY_90,
        IDENTITY_70,
        IDENTITY_50,
        IDENTITY_40,
        IDENTITY_30;


        public int getIdentity() {
            return Integer.parseInt(this.name().split("_")[1]);
        }
    }
}

