/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.structures;

import de.bioforscher.singa.structure.model.identifiers.UniqueAtomIdentifer;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContentTreeNode {
    private static final Logger logger = LoggerFactory.getLogger(ContentTreeNode.class);
    private final StructureLevel level;
    private String identifier;
    private char insertionCode;
    private OakAtom atom;
    private List<ContentTreeNode> children;

    ContentTreeNode(String identifier, StructureLevel level) {
        this.identifier = identifier;
        this.level = level;
        this.children = new ArrayList<ContentTreeNode>();
    }

    private ContentTreeNode(String identifier, OakAtom atom) {
        this.identifier = identifier;
        this.level = StructureLevel.ATOM;
        this.atom = atom;
    }

    private ContentTreeNode(String identifier, char insertionCode) {
        this(identifier, StructureLevel.LEAF);
        this.insertionCode = insertionCode;
    }

    public StructureLevel getLevel() {
        return this.level;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public OakAtom getAtom() {
        return this.atom;
    }

    public void setAtom(OakAtom atom) {
        this.atom = atom;
    }

    public char getInsertionCode() {
        return this.insertionCode;
    }

    public List<ContentTreeNode> getNodesFromLevel(StructureLevel level) {
        ArrayList<ContentTreeNode> nodes = new ArrayList<ContentTreeNode>();
        if (this.level == level) {
            nodes.add(this);
        } else {
            this.children.forEach(child -> nodes.addAll(child.getNodesFromLevel(level)));
        }
        return nodes;
    }

    public Map<String, OakAtom> getAtomMap() {
        if (this.getLevel() == StructureLevel.LEAF) {
            HashMap<String, OakAtom> atoms = new HashMap<String, OakAtom>();
            for (ContentTreeNode node : this.children) {
                atoms.put(node.getAtom().getAtomName(), node.getAtom());
            }
            return atoms;
        }
        return null;
    }

    public void appendAtom(OakAtom atom, UniqueAtomIdentifer identifer) {
        ListIterator<ContentTreeNode> iterator = this.children.listIterator();
        if (this.children.isEmpty()) {
            switch (this.level) {
                case STRUCTURE: {
                    iterator.add(new ContentTreeNode(String.valueOf(identifer.getModelIdentifier()), StructureLevel.MODEL));
                    logger.trace("Added model {}", (Object)identifer.getModelIdentifier());
                    break;
                }
                case MODEL: {
                    iterator.add(new ContentTreeNode(identifer.getChainIdentifier(), StructureLevel.CHAIN));
                    logger.trace("Added chain {}", (Object)identifer.getChainIdentifier());
                    break;
                }
                case CHAIN: {
                    iterator.add(new ContentTreeNode(String.valueOf(identifer.getLeafSerial()), identifer.getLeafInsertionCode()));
                    logger.trace("Added leaf {}", (Object)identifer.getLeafSerial());
                    break;
                }
                case LEAF: {
                    iterator.add(new ContentTreeNode(String.valueOf(identifer.getAtomSerial()), atom));
                    logger.trace("Appending atom {}", (Object)identifer.getAtomSerial());
                    return;
                }
                case ATOM: {
                    return;
                }
            }
            iterator.previous().appendAtom(atom, identifer);
        } else {
            switch (this.level) {
                case STRUCTURE: {
                    while (iterator.hasNext()) {
                        ContentTreeNode model = iterator.next();
                        if (!model.identifier.equals(String.valueOf(identifer.getModelIdentifier()))) continue;
                        logger.trace("Already at correct model, going further.");
                        model.appendAtom(atom, identifer);
                        return;
                    }
                    iterator.add(new ContentTreeNode(String.valueOf(identifer.getModelIdentifier()), StructureLevel.MODEL));
                    logger.trace("Added model {}", (Object)identifer.getModelIdentifier());
                    break;
                }
                case MODEL: {
                    while (iterator.hasNext()) {
                        ContentTreeNode chain = iterator.next();
                        if (!chain.identifier.equals(String.valueOf(identifer.getChainIdentifier()))) continue;
                        logger.trace("Already at correct chain, going further.");
                        chain.appendAtom(atom, identifer);
                        return;
                    }
                    iterator.add(new ContentTreeNode(identifer.getChainIdentifier(), StructureLevel.CHAIN));
                    logger.trace("Added chain {}", (Object)identifer.getChainIdentifier());
                    break;
                }
                case CHAIN: {
                    while (iterator.hasNext()) {
                        ContentTreeNode leaf = iterator.next();
                        if (!leaf.identifier.equals(String.valueOf(identifer.getLeafSerial())) || leaf.insertionCode != identifer.getLeafInsertionCode()) continue;
                        logger.trace("Found correct leaf, appending atom {}", (Object)identifer.getAtomSerial());
                        leaf.children.add(new ContentTreeNode(String.valueOf(identifer.getAtomSerial()), atom));
                        return;
                    }
                    logger.trace("Added leaf {} with initial atom {} ", (Object)identifer.getLeafSerial(), (Object)identifer.getAtomSerial());
                    ContentTreeNode leafNode = new ContentTreeNode(String.valueOf(identifer.getLeafSerial()), identifer.getLeafInsertionCode());
                    leafNode.children.add(new ContentTreeNode(String.valueOf(identifer.getAtomSerial()), atom));
                    iterator.add(leafNode);
                    break;
                }
                case LEAF: 
                case ATOM: {
                    return;
                }
            }
            iterator.previous().appendAtom(atom, identifer);
        }
    }

    public static enum StructureLevel {
        STRUCTURE,
        MODEL,
        CHAIN,
        LEAF,
        ATOM;

    }
}

