/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.structures;

import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.families.LigandFamily;
import de.bioforscher.singa.structure.model.families.NucleotideFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.identifiers.PDBIdentifier;
import de.bioforscher.singa.structure.model.identifiers.UniqueAtomIdentifer;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.oak.LeafSubstructureFactory;
import de.bioforscher.singa.structure.model.oak.OakAminoAcid;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.OakChain;
import de.bioforscher.singa.structure.model.oak.OakLeafSubstructure;
import de.bioforscher.singa.structure.model.oak.OakLigand;
import de.bioforscher.singa.structure.model.oak.OakModel;
import de.bioforscher.singa.structure.model.oak.OakNucleotide;
import de.bioforscher.singa.structure.model.oak.OakStructure;
import de.bioforscher.singa.structure.parser.pdb.ligands.LigandParserService;
import de.bioforscher.singa.structure.parser.pdb.structures.ContentTreeNode;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParser;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParserException;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.AtomToken;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.ChainTerminatorToken;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.HeaderToken;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.LeafSkeleton;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.ModelToken;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.TerminatorTokens;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.TitleToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureCollector {
    private static final Logger logger = LoggerFactory.getLogger(StructureCollector.class);
    private final StringBuilder titleBuilder = new StringBuilder();
    private final Map<UniqueAtomIdentifer, OakAtom> atoms;
    private final Map<LeafIdentifier, String> leafCodes;
    private final Set<LeafIdentifier> hetAtoms;
    private final Set<LeafIdentifier> notInConsecutiveChain;
    private final Set<String> closedChains;
    private final StructureParser.Reducer reducer;
    private String currentPDB = "0000";
    private int currentModel = 1;
    private String currentChain = "X";
    private ContentTreeNode contentTree;
    private List<String> pdbLines;

    private StructureCollector(List<String> pdbLines, StructureParser.Reducer reducer) {
        this.reducer = reducer;
        this.pdbLines = pdbLines;
        this.atoms = new HashMap<UniqueAtomIdentifer, OakAtom>();
        this.leafCodes = new TreeMap<LeafIdentifier, String>();
        this.hetAtoms = new HashSet<LeafIdentifier>();
        this.notInConsecutiveChain = new HashSet<LeafIdentifier>();
        this.closedChains = new HashSet<String>();
    }

    static Structure parse(List<String> pdbLines, StructureParser.Reducer reducer) throws StructureParserException {
        StructureCollector collector = new StructureCollector(pdbLines, reducer);
        collector.reduceLines();
        return collector.collectStructure();
    }

    public static String trimEnd(String source) {
        int pos;
        for (pos = source.length() - 1; pos >= 0 && Character.isWhitespace(source.charAt(pos)); --pos) {
        }
        return ++pos < source.length() ? source.substring(0, pos) : source;
    }

    private void reduceLines() throws StructureParserException {
        String firstLine = this.pdbLines.get(0);
        if (this.reducer.options.isInferringIdentifierFromFileName()) {
            String currentSource = this.reducer.sourceSelector.contentIterator.getCurrentSource();
            String identifier = PDBIdentifier.extractFirst(currentSource);
            if (identifier != null) {
                this.currentPDB = identifier;
            }
        } else if (HeaderToken.RECORD_PATTERN.matcher(firstLine).matches()) {
            this.currentPDB = HeaderToken.ID_CODE.extract(firstLine);
        }
        this.getTitle();
        if (this.reducer.parseMapping) {
            this.reducer.updatePdbIdentifer();
            this.reducer.updateChainIdentifier();
            this.reduceToChain(this.reducer.chainIdentifier);
            logger.info("Parsing structure {} chainIdentifier {}", (Object)this.reducer.pdbIdentifier, (Object)this.reducer.chainIdentifier);
        } else {
            if (!this.reducer.allModels) {
                this.reduceToModel(this.reducer.modelIdentifier);
            }
            if (!this.reducer.allChains) {
                this.reduceToChain(this.reducer.chainIdentifier);
            }
        }
    }

    private void getTitle() {
        if (this.reducer.options.isInferringTitleFromFileName()) {
            this.titleBuilder.append(this.reducer.sourceSelector.contentIterator.getCurrentSource());
        } else {
            boolean titleFound = false;
            for (String currentLine : this.pdbLines) {
                if (TitleToken.RECORD_PATTERN.matcher(currentLine).matches()) {
                    if (!titleFound) {
                        titleFound = true;
                    }
                    this.titleBuilder.append(StructureCollector.trimEnd(TitleToken.TEXT.extract(currentLine)));
                    continue;
                }
                if (!titleFound) continue;
                return;
            }
        }
    }

    private void reduceToModel(int modelIdentifier) {
        ArrayList<String> reducedList = new ArrayList<String>();
        boolean collectLines = false;
        for (String currentLine : this.pdbLines) {
            int currentModel;
            if (ModelToken.RECORD_PATTERN.matcher(currentLine).matches() && (currentModel = Integer.valueOf(ModelToken.MODEL_SERIAL.extract(currentLine)).intValue()) == modelIdentifier) {
                this.currentModel = currentModel;
                collectLines = true;
                continue;
            }
            if (collectLines && TerminatorTokens.MODEL_TERMINATOR.matcher(currentLine).matches()) break;
            if (!collectLines) continue;
            reducedList.add(currentLine);
        }
        this.pdbLines = reducedList;
    }

    private void reduceToChain(String chainIdentifier) {
        ArrayList<String> reducedList = new ArrayList<String>();
        for (String currentLine : this.pdbLines) {
            if (AtomToken.RECORD_PATTERN.matcher(currentLine).matches()) {
                String currentChain = AtomToken.CHAIN_IDENTIFIER.extract(currentLine);
                if (!currentChain.equals(chainIdentifier)) continue;
                reducedList.add(currentLine);
                continue;
            }
            if (ModelToken.RECORD_PATTERN.matcher(currentLine).matches()) {
                reducedList.add(currentLine);
                continue;
            }
            if (!ChainTerminatorToken.RECORD_PATTERN.matcher(currentLine).matches() || !ChainTerminatorToken.CHAIN_IDENTIFIER.extract(currentLine).equals(chainIdentifier)) continue;
            reducedList.add(currentLine);
        }
        this.pdbLines = reducedList;
    }

    private Structure collectStructure() {
        this.collectAtomInformation();
        this.createContentTree();
        logger.debug("Creating structure for {}", (Object)this.contentTree.getIdentifier());
        OakStructure structure = new OakStructure();
        structure.setPdbIdentifier(this.contentTree.getIdentifier());
        structure.setTitle(this.titleBuilder.toString());
        for (ContentTreeNode modelNode : this.contentTree.getNodesFromLevel(ContentTreeNode.StructureLevel.MODEL)) {
            logger.debug("Collecting chains for model {}", (Object)modelNode.getIdentifier());
            OakModel model = new OakModel(Integer.valueOf(modelNode.getIdentifier()));
            for (ContentTreeNode chainNode : modelNode.getNodesFromLevel(ContentTreeNode.StructureLevel.CHAIN)) {
                logger.trace("Collecting leafs for chain {}", (Object)chainNode.getIdentifier());
                OakChain chain = new OakChain(chainNode.getIdentifier());
                for (ContentTreeNode leafNode : chainNode.getNodesFromLevel(ContentTreeNode.StructureLevel.LEAF)) {
                    OakLeafSubstructure<?> leafSubstructure = this.assignLeaf(leafNode, Integer.valueOf(modelNode.getIdentifier()), chainNode.getIdentifier());
                    if (this.hetAtoms.contains(leafSubstructure.getIdentifier())) {
                        leafSubstructure.setAnnotatedAsHetAtom(true);
                    }
                    if (this.notInConsecutiveChain.contains(leafSubstructure.getIdentifier())) {
                        chain.addLeafSubstructure(leafSubstructure);
                        continue;
                    }
                    chain.addLeafSubstructure(leafSubstructure, true);
                }
                model.addChain(chain);
            }
            structure.addModel(model);
        }
        if (this.reducer.options.isCreatingEdges()) {
            structure.getAllChains().stream().map(OakChain.class::cast).forEach(OakChain::connectChainBackbone);
        }
        UniqueAtomIdentifer lastAtom = Collections.max(this.atoms.keySet());
        structure.setLastAddedAtomIdentifier(lastAtom.getAtomSerial());
        return structure;
    }

    private void collectAtomInformation() {
        logger.debug("Collecting information from {} PDB lines", (Object)this.pdbLines.size());
        for (String currentLine : this.pdbLines) {
            String currentRecordType = AtomToken.RECORD_TYPE.extract(currentLine);
            if (AtomToken.RECORD_PATTERN.matcher(currentRecordType).matches()) {
                if (!this.reducer.options.isHeteroAtoms() && currentRecordType.equals("HETATM")) continue;
                UniqueAtomIdentifer identifier = this.createUniqueAtomIdentifier(currentLine);
                this.atoms.put(identifier, AtomToken.assembleAtom(currentLine));
                LeafIdentifier leafIdentifier = new LeafIdentifier(identifier.getPdbIdentifier(), identifier.getModelIdentifier(), identifier.getChainIdentifier(), identifier.getLeafSerial(), identifier.getLeafInsertionCode());
                this.currentChain = leafIdentifier.getChainIdentifier();
                if (currentRecordType.equals("HETATM")) {
                    this.hetAtoms.add(leafIdentifier);
                }
                if (this.closedChains.contains(this.currentModel + "-" + this.currentChain)) {
                    this.notInConsecutiveChain.add(leafIdentifier);
                }
                this.leafCodes.put(leafIdentifier, AtomToken.RESIDUE_NAME.extract(currentLine));
                continue;
            }
            if (currentRecordType.equals("MODEL")) {
                this.currentModel = Integer.valueOf(ModelToken.MODEL_SERIAL.extract(currentLine));
                continue;
            }
            if (!currentRecordType.equals("TER")) continue;
            this.closedChains.add(this.currentModel + "-" + this.currentChain);
        }
    }

    private void createContentTree() {
        logger.debug("Creating content tree.");
        this.contentTree = new ContentTreeNode(this.currentPDB, ContentTreeNode.StructureLevel.STRUCTURE);
        this.atoms.forEach((identifer, atom) -> this.contentTree.appendAtom((OakAtom)atom, (UniqueAtomIdentifer)identifer));
        if (this.atoms.isEmpty()) {
            throw new StructureParserException("Unable to apply the reduction, supplied with the reducer: " + this.reducer);
        }
    }

    private UniqueAtomIdentifer createUniqueAtomIdentifier(String atomLine) {
        int atomSerial = Integer.valueOf(AtomToken.ATOM_SERIAL.extract(atomLine));
        String chain = AtomToken.CHAIN_IDENTIFIER.extract(atomLine);
        int leaf = Integer.valueOf(AtomToken.RESIDUE_SERIAL.extract(atomLine));
        String insertion = AtomToken.RESIDUE_INSERTION.extract(atomLine);
        char insertionCode = insertion.isEmpty() ? (char)'\u0000' : insertion.charAt(0);
        return new UniqueAtomIdentifer(this.currentPDB, this.currentModel, chain, leaf, insertionCode, atomSerial);
    }

    private OakLeafSubstructure<?> assignLeaf(ContentTreeNode leafNode, int modelIdentifier, String chainIdentifer) {
        LeafIdentifier leafIdentifier = new LeafIdentifier(this.currentPDB, modelIdentifier, chainIdentifer, Integer.valueOf(leafNode.getIdentifier()), leafNode.getInsertionCode());
        String leafName = this.leafCodes.get(leafIdentifier);
        Map<String, OakAtom> atoms = leafNode.getAtomMap();
        logger.trace("Creating leaf {}-{} in chain {}", new Object[]{leafNode.getIdentifier(), leafName, chainIdentifer});
        Optional<AminoAcidFamily> aminoAcidFamilyOptional = AminoAcidFamily.getAminoAcidTypeByThreeLetterCode(leafName);
        if (aminoAcidFamilyOptional.isPresent()) {
            AminoAcidFamily family = aminoAcidFamilyOptional.get();
            return this.createAminoAcid(leafIdentifier, family, atoms);
        }
        Optional<NucleotideFamily> nucleotideFamilyOptional = NucleotideFamily.getNucleotideByThreeLetterCode(leafName);
        if (nucleotideFamilyOptional.isPresent()) {
            NucleotideFamily family = nucleotideFamilyOptional.get();
            return this.createNucleotide(leafIdentifier, family, atoms);
        }
        if (this.reducer.options.isRetrievingLigandInformation()) {
            return this.createLeafWithAdditionalInformation(leafIdentifier, leafName, atoms);
        }
        return this.createLeafWithoutAdditionalInformation(leafIdentifier, leafName, atoms);
    }

    private boolean isPlainAminoAcid(String leafName) {
        return AminoAcidFamily.getAminoAcidTypeByThreeLetterCode(leafName).isPresent();
    }

    private boolean isPlainNucleotide(String leafName) {
        return NucleotideFamily.getNucleotideByThreeLetterCode(leafName).isPresent();
    }

    private OakAminoAcid createAminoAcid(LeafIdentifier identifier, AminoAcidFamily family, Map<String, OakAtom> atoms) {
        return LeafSubstructureFactory.createAminoAcidFromAtoms(identifier, family, atoms, this.reducer.options);
    }

    private OakNucleotide createNucleotide(LeafIdentifier identifier, NucleotideFamily family, Map<String, OakAtom> atoms) {
        return LeafSubstructureFactory.createNucleotideFromAtoms(identifier, family, atoms, this.reducer.options);
    }

    private OakLeafSubstructure<?> createLeafWithoutAdditionalInformation(LeafIdentifier identifier, String leafName, Map<String, OakAtom> atoms) {
        OakLigand substructure = new OakLigand(identifier, new LigandFamily("?", leafName));
        atoms.values().forEach(substructure::addAtom);
        return substructure;
    }

    private OakLeafSubstructure<?> createLeafWithAdditionalInformation(LeafIdentifier identifier, String leafName, Map<String, OakAtom> atoms) {
        LeafSkeleton leafSkeleton;
        if (!this.reducer.skeletons.containsKey(leafName)) {
            leafSkeleton = LigandParserService.parseLeafSkeleton(leafName);
            this.reducer.skeletons.put(leafName, leafSkeleton);
        } else {
            leafSkeleton = this.reducer.skeletons.get(leafName);
        }
        return leafSkeleton.toRealLeafSubstructure(identifier, atoms);
    }
}

