/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.structures;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.structure.parser.pdb.structures.SourceLocation;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StructureContentIterator
implements Iterator<List<String>> {
    private static final Logger logger = LoggerFactory.getLogger(StructureContentIterator.class);
    private static final String PDB_FETCH_URL = "https://files.rcsb.org/download/%s.pdb";
    private final List<String> pdbIdentifiers;
    private StructureParser.LocalPDB localPdb;
    private List<URL> identifiers;
    private Iterator<URL> currentURL;
    private List<Path> paths;
    private Iterator<Path> currentPath;
    private Iterator<String> pdbIdentifierIterator;
    private String currentPdbIdentifier;
    private List<String> chains;
    private Iterator<String> chainIdentifierIterator;
    private String currentChainIdentifier;
    private SourceLocation location;
    private String currentSource;
    private int progressCounter;

    StructureContentIterator(String identifier, SourceLocation sourceLocation) {
        this(String.class, Collections.singletonList(identifier), sourceLocation);
    }

    StructureContentIterator(Path path) {
        this(Path.class, Collections.singletonList(path), SourceLocation.OFFLINE_PDB);
    }

    StructureContentIterator(File file) {
        this(File.class, Collections.singletonList(file), SourceLocation.OFFLINE_PDB);
    }

    StructureContentIterator(StructureParser.LocalPDB localPdb, String identifier) {
        this.localPdb = localPdb;
        this.paths = new ArrayList<Path>();
        this.pdbIdentifiers = new ArrayList<String>();
        this.prepareLocalPDB(Collections.singletonList(identifier));
    }

    StructureContentIterator(StructureParser.LocalPDB localPdb, List<String> identifiers) {
        this.localPdb = localPdb;
        this.paths = new ArrayList<Path>();
        this.pdbIdentifiers = new ArrayList<String>();
        this.prepareLocalPDB(identifiers);
    }

    StructureContentIterator(List<Pair<String>> mapping, StructureParser.LocalPDB localPDB) {
        this.localPdb = localPDB;
        this.paths = new ArrayList<Path>();
        this.pdbIdentifiers = new ArrayList<String>();
        this.chains = new ArrayList<String>();
        this.prepareMappedLocalPDB(mapping);
    }

    StructureContentIterator(List<Pair<String>> mapping, SourceLocation sourceLocation) {
        this.paths = new ArrayList<Path>();
        this.identifiers = new ArrayList<URL>();
        this.pdbIdentifiers = new ArrayList<String>();
        this.chains = new ArrayList<String>();
        this.prepareMappedIdentifiers(mapping, sourceLocation);
    }

    StructureContentIterator(Class<?> context, List<?> identifiers, SourceLocation sourceLocation) {
        this.paths = new ArrayList<Path>();
        this.identifiers = new ArrayList<URL>();
        this.pdbIdentifiers = new ArrayList<String>();
        this.progressCounter = 0;
        if (context.equals(String.class)) {
            this.prepareIdentifiers(identifiers, sourceLocation);
        } else if (context.equals(Path.class)) {
            this.prepareOfflinePaths(identifiers);
        } else if (context.equals(File.class)) {
            this.prepareOfflineFiles(identifiers);
        }
    }

    private void prepareIdentifiers(List<String> identifiers, SourceLocation sourceLocation) {
        for (String identifier : identifiers) {
            try {
                if (sourceLocation == SourceLocation.ONLINE_PDB) {
                    this.identifiers.add(new URL(String.format(PDB_FETCH_URL, identifier)));
                }
                this.pdbIdentifiers.add(identifier);
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException("Malformed URL to PDB for identifier " + identifier, e);
            }
        }
        this.currentURL = this.identifiers.iterator();
        this.pdbIdentifierIterator = this.pdbIdentifiers.iterator();
        this.location = sourceLocation;
    }

    private void prepareOfflinePaths(List<Path> paths) {
        this.paths = paths;
        this.currentPath = this.paths.iterator();
        this.location = SourceLocation.OFFLINE_PDB;
    }

    private void prepareOfflineFiles(List<File> files) {
        for (File file : files) {
            this.paths.add(file.toPath());
        }
        this.currentPath = this.paths.iterator();
        this.location = SourceLocation.OFFLINE_PDB;
    }

    private void prepareLocalPDB(List<String> identifiers) {
        for (String identifier : identifiers) {
            this.paths.add(this.assemblePath(identifier));
            this.pdbIdentifiers.add(identifier);
        }
        this.currentPath = this.paths.iterator();
        this.pdbIdentifierIterator = this.pdbIdentifiers.iterator();
        this.location = SourceLocation.OFFLINE_PDB;
    }

    private void prepareMappedLocalPDB(List<Pair<String>> mapping) {
        for (Pair<String> pair : mapping) {
            this.paths.add(this.assemblePath((String)pair.getFirst()));
            this.pdbIdentifiers.add((String)pair.getFirst());
            this.chains.add((String)pair.getSecond());
        }
        this.currentPath = this.paths.iterator();
        this.pdbIdentifierIterator = this.pdbIdentifiers.iterator();
        this.chainIdentifierIterator = this.chains.iterator();
        this.location = SourceLocation.OFFLINE_PDB;
    }

    private void prepareMappedIdentifiers(List<Pair<String>> mapping, SourceLocation sourceLocation) {
        for (Pair<String> pair : mapping) {
            try {
                if (sourceLocation == SourceLocation.ONLINE_PDB) {
                    this.identifiers.add(new URL(String.format(PDB_FETCH_URL, pair.getFirst())));
                }
                this.pdbIdentifiers.add((String)pair.getFirst());
                this.chains.add((String)pair.getSecond());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException("Malformed URL to PDB", e);
            }
        }
        this.currentURL = this.identifiers.iterator();
        this.pdbIdentifierIterator = this.pdbIdentifiers.iterator();
        this.chainIdentifierIterator = this.chains.iterator();
        this.location = sourceLocation;
    }

    private Path assemblePath(String identifier) {
        return this.localPdb.getPathForPdbIdentifier(identifier);
    }

    private InputStream readPacked(Path path) throws IOException {
        return new GZIPInputStream(new FileInputStream(path.toFile()));
    }

    int getNumberOfQueuedStructures() {
        if (this.location == SourceLocation.ONLINE_PDB || this.location == SourceLocation.ONLINE_MMTF) {
            return this.pdbIdentifiers.size();
        }
        return this.paths.size();
    }

    int getNumberOfRemainingStructures() {
        if (this.location == SourceLocation.ONLINE_PDB || this.location == SourceLocation.ONLINE_MMTF) {
            return this.pdbIdentifiers.size() - this.progressCounter;
        }
        return this.paths.size() - this.progressCounter;
    }

    String getCurrentPdbIdentifier() {
        if (this.currentPdbIdentifier != null) {
            return this.currentPdbIdentifier;
        }
        throw new IllegalStateException("Unable to retrieve the PDB Identifier in the current state.");
    }

    String getCurrentChainIdentifier() {
        if (this.currentChainIdentifier != null) {
            return this.currentChainIdentifier;
        }
        throw new IllegalStateException("Unable to retrieve chainIdentifier Identifier in the current state.");
    }

    String getCurrentSource() {
        return this.currentSource;
    }

    @Override
    public boolean hasNext() {
        switch (this.location) {
            case ONLINE_PDB: {
                return this.currentURL.hasNext();
            }
            case ONLINE_MMTF: {
                return this.pdbIdentifierIterator.hasNext();
            }
        }
        return this.currentPath.hasNext();
    }

    @Override
    public List<String> next() {
        if (this.pdbIdentifiers != null && !this.pdbIdentifiers.isEmpty()) {
            this.currentPdbIdentifier = this.pdbIdentifierIterator.next();
            if (this.chains != null) {
                this.currentChainIdentifier = this.chainIdentifierIterator.next();
                logger.debug("Parsing structure {}/{}.", (Object)this.currentPdbIdentifier, (Object)this.currentChainIdentifier);
            } else {
                logger.debug("Parsing structure {}.", (Object)this.currentPdbIdentifier);
            }
        }
        switch (this.location) {
            case OFFLINE_PDB: {
                try {
                    Path path = this.currentPath.next();
                    this.currentSource = path.getFileName().toString().replaceFirst("[.][^.]+$", "");
                    if (path.toString().endsWith(".ent.gz")) {
                        List<String> list = this.fetchLines(this.readPacked(path));
                        return list;
                    }
                    if (path.toString().endsWith(".mmtf.gz")) {
                        List<String> list = Collections.singletonList(path.toString());
                        return list;
                    }
                    List<String> list = this.fetchLines(Files.newInputStream(path, new OpenOption[0]));
                    return list;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not open input stream for path.", e);
                }
                finally {
                    ++this.progressCounter;
                }
            }
            case ONLINE_PDB: {
                try {
                    URL url = this.currentURL.next();
                    this.currentSource = url.getFile();
                    List<String> list = this.fetchLines(url.openStream());
                    return list;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not open input stream for URL. The PDB identifier \"" + this.currentPdbIdentifier + "\" does not seem to exist", e);
                }
                finally {
                    ++this.progressCounter;
                }
            }
        }
        ++this.progressCounter;
        return Collections.singletonList(this.currentPdbIdentifier);
    }

    /*
     * Exception decompiling
     */
    private List<String> fetchLines(InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

