/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.structures;

public class StructureParserOptions {
    private boolean createEdges = true;
    private boolean retrieveLigandInformation = true;
    private boolean connectHydrogens = false;
    private boolean omitHydrogens = false;
    private boolean inferTitleFromFileName = false;
    private boolean inferIdentifierFromFileName = false;
    private boolean heteroAtoms = true;

    public static StructureParserOptions withSettings(Setting ... settings) {
        StructureParserOptions options = new StructureParserOptions();
        for (Setting setting : settings) {
            StructureParserOptions.setOption(options, setting);
        }
        return options;
    }

    private static void setOption(StructureParserOptions options, Setting setting) {
        switch (setting) {
            case CREATE_EDGES: {
                options.createEdges(true);
                break;
            }
            case OMIT_EDGES: {
                options.createEdges(false);
                break;
            }
            case GET_LIGAND_INFORMATION: {
                options.retrieveLigandInformation(true);
                break;
            }
            case OMIT_LIGAND_INFORMATION: {
                options.retrieveLigandInformation(false);
                break;
            }
            case GET_HETERO_ATOMS: {
                options.heteroAtoms(true);
                break;
            }
            case OMIT_HETERO_ATOMS: {
                options.heteroAtoms(false);
                break;
            }
            case GET_HYDROGEN_CONNECTIONS: {
                options.connectHydrogens(true);
                break;
            }
            case OMIT_HYDROGENS_CONNECTIONS: {
                options.connectHydrogens(false);
                break;
            }
            case GET_HYDROGENS: {
                options.omitHydrogens(false);
                break;
            }
            case OMIT_HYDROGENS: {
                options.omitHydrogens(true);
                break;
            }
            case GET_TITLE_FROM_FILENAME: {
                options.inferTitleFromFileName(true);
                break;
            }
            case GET_TITLE_FROM_PDB: {
                options.inferTitleFromFileName(false);
                break;
            }
            case GET_IDENTIFIER_FROM_FILENAME: {
                options.inferIdentifierFromFileName(true);
                break;
            }
            case GET_IDENTIFIER_FROM_PDB: {
                options.inferIdentifierFromFileName(false);
            }
        }
    }

    public void heteroAtoms(boolean heteroAtoms) {
        this.heteroAtoms = heteroAtoms;
    }

    public boolean isHeteroAtoms() {
        return this.heteroAtoms;
    }

    public boolean isCreatingEdges() {
        return this.createEdges;
    }

    public void createEdges(boolean createEdges) {
        this.createEdges = createEdges;
    }

    public boolean isRetrievingLigandInformation() {
        return this.retrieveLigandInformation;
    }

    public void retrieveLigandInformation(boolean retrieveLigandInformation) {
        this.retrieveLigandInformation = retrieveLigandInformation;
    }

    public boolean isConnectingHydrogens() {
        return this.connectHydrogens;
    }

    public void connectHydrogens(boolean connectHydrogens) {
        this.connectHydrogens = connectHydrogens;
    }

    public boolean isOmittingHydrogen() {
        return this.omitHydrogens;
    }

    public void omitHydrogens(boolean omitHydrogens) {
        this.omitHydrogens = omitHydrogens;
        if (omitHydrogens) {
            this.connectHydrogens = false;
        }
    }

    public boolean isInferringTitleFromFileName() {
        return this.inferTitleFromFileName;
    }

    public void inferTitleFromFileName(boolean inferTitleFromFileName) {
        this.inferTitleFromFileName = inferTitleFromFileName;
    }

    public boolean isInferringIdentifierFromFileName() {
        return this.inferIdentifierFromFileName;
    }

    public void inferIdentifierFromFileName(boolean inferIdentifierFromFileName) {
        this.inferIdentifierFromFileName = inferIdentifierFromFileName;
    }

    public static enum Setting {
        CREATE_EDGES,
        OMIT_EDGES,
        GET_LIGAND_INFORMATION,
        OMIT_LIGAND_INFORMATION,
        GET_HETERO_ATOMS,
        OMIT_HETERO_ATOMS,
        GET_HYDROGEN_CONNECTIONS,
        OMIT_HYDROGENS_CONNECTIONS,
        GET_HYDROGENS,
        OMIT_HYDROGENS,
        GET_TITLE_FROM_FILENAME,
        GET_TITLE_FROM_PDB,
        GET_IDENTIFIER_FROM_FILENAME,
        GET_IDENTIFIER_FROM_PDB;

    }
}

