/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.structures;

import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.Ligand;
import de.bioforscher.singa.structure.model.interfaces.Model;
import de.bioforscher.singa.structure.model.interfaces.Nucleotide;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.oak.StructuralMotif;
import java.util.NoSuchElementException;

public class StructureSelector {
    private StructureSelector() {
    }

    public static StructuralModelStep selectFrom(Structure structure) {
        return new Selector(structure);
    }

    public static ChainStep selectFrom(Model structuralModel) {
        return new Selector(structuralModel);
    }

    public static ResidueStep selectFrom(Chain chain) {
        return new Selector(chain);
    }

    public static StructuralModelStep selectFrom(StructuralMotif structuralMotif) {
        return new Selector(structuralMotif);
    }

    public static AtomStep selectFrom(AminoAcid aminoAcid) {
        return new Selector(aminoAcid);
    }

    public static AtomStep selectFrom(Nucleotide nucleotide) {
        return new Selector(nucleotide);
    }

    public static AtomStep selectFrom(Ligand atomContainer) {
        return new Selector(atomContainer);
    }

    public static class Selector
    implements StructuralModelStep,
    ChainStep,
    ResidueStep,
    AtomStep,
    AminoAcidAtomStep,
    NucleotideAtomStep,
    AtomContainerAtomStep,
    SelectStep {
        private Structure structure;
        private Model structuralModel;
        private Chain chain;
        private StructuralMotif structuralMotif;
        private AminoAcid aminoAcid;
        private Nucleotide nucleotide;
        private Ligand atomContainer;
        private Atom atom;

        public Selector(Structure structure) {
            this.structure = structure;
        }

        public Selector(Model structuralModel) {
            this.structuralModel = structuralModel;
        }

        public Selector(Chain chain) {
            this.chain = chain;
        }

        public Selector(AminoAcid aminoAcid) {
            this.aminoAcid = aminoAcid;
        }

        public Selector(Nucleotide nucleotide) {
            this.nucleotide = nucleotide;
        }

        public Selector(Ligand atomContainer) {
            this.atomContainer = atomContainer;
        }

        public Selector(StructuralMotif structuralMotif) {
            this.structuralMotif = structuralMotif;
        }

        @Override
        public ChainStep model(int identifier) {
            this.structuralModel = this.structure.getAllModels().stream().filter(structuralModel -> structuralModel.getModelIdentifier() == identifier).findFirst().orElseThrow(() -> new NoSuchElementException("no structural model with ID " + identifier));
            return this;
        }

        @Override
        public Model selectModel() {
            return this.structuralModel;
        }

        @Override
        public ResidueStep chain(String identifier) {
            this.chain = this.structuralModel.getAllChains().stream().filter(chain -> chain.getChainIdentifier().equals(identifier)).findFirst().orElseThrow(() -> new NoSuchElementException("no chainIdentifier with index " + identifier));
            return this;
        }

        @Override
        public Chain selectChain() {
            return this.chain;
        }

        @Override
        public AminoAcidAtomStep aminoAcid(int identifier) {
            this.aminoAcid = this.chain.getAllLeafSubstructures().stream().filter(AminoAcid.class::isInstance).map(AminoAcid.class::cast).filter(leafSubstructure -> leafSubstructure.getIdentifier().getSerial() == identifier).findFirst().orElseThrow(() -> new NoSuchElementException("no amino acid with ID " + identifier));
            return this;
        }

        @Override
        public AminoAcid selectAminoAcid() {
            return this.aminoAcid;
        }

        @Override
        public NucleotideAtomStep nucleotide(int identifier) {
            this.nucleotide = this.chain.getAllLeafSubstructures().stream().filter(Nucleotide.class::isInstance).map(Nucleotide.class::cast).filter(leafSubstructure -> leafSubstructure.getIdentifier().getSerial() == identifier).findFirst().orElseThrow(() -> new NoSuchElementException("no nucleotide with ID " + identifier));
            return this;
        }

        @Override
        public Nucleotide selectNucleotide() {
            return this.nucleotide;
        }

        @Override
        public AtomContainerAtomStep atomContainer(int identifier) {
            this.atomContainer = this.chain.getAllLeafSubstructures().stream().filter(Ligand.class::isInstance).map(Ligand.class::cast).filter(leafSubstructure -> leafSubstructure.getIdentifier().getSerial() == identifier).findFirst().orElseThrow(() -> new NoSuchElementException("no atom container with ID " + identifier));
            return this;
        }

        @Override
        public Ligand selectAtomContainer() {
            return this.atomContainer;
        }

        @Override
        public SelectStep atom(int identifier) {
            if (this.aminoAcid != null) {
                this.atom = this.getAtomFromLeafSubstructure(this.aminoAcid, identifier);
            }
            if (this.nucleotide != null) {
                this.atom = this.getAtomFromLeafSubstructure(this.nucleotide, identifier);
            }
            if (this.atomContainer != null) {
                this.atom = this.getAtomFromLeafSubstructure(this.atomContainer, identifier);
            }
            return this;
        }

        private Atom getAtomFromLeafSubstructure(LeafSubstructure leafSubstructure, int atomId) {
            return leafSubstructure.getAllAtoms().stream().filter(atom -> atom.getAtomIdentifier() == atomId).findFirst().orElseThrow(() -> new NoSuchElementException("no atom with ID " + atomId));
        }

        @Override
        public Atom selectAtom() {
            return this.atom;
        }
    }

    public static interface SelectStep {
        public Atom selectAtom();
    }

    public static interface AtomStep {
        public SelectStep atom(int var1);
    }

    public static interface AtomContainerAtomStep
    extends AtomStep {
        public Ligand selectAtomContainer();
    }

    public static interface NucleotideAtomStep
    extends AtomStep {
        public Nucleotide selectNucleotide();
    }

    public static interface AminoAcidAtomStep
    extends AtomStep {
        public AminoAcid selectAminoAcid();
    }

    public static interface ResidueStep {
        public AminoAcidAtomStep aminoAcid(int var1);

        public NucleotideAtomStep nucleotide(int var1);

        public AtomContainerAtomStep atomContainer(int var1);

        public Chain selectChain();
    }

    public static interface ChainStep {
        public ResidueStep chain(String var1);

        public Model selectModel();
    }

    public static interface StructuralModelStep {
        public ChainStep model(int var1);
    }
}

