/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.structures;

import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.AtomContainer;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.interfaces.Model;
import de.bioforscher.singa.structure.model.oak.LeafSubstructureFactory;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.OakChain;
import de.bioforscher.singa.structure.model.oak.OakLeafSubstructure;
import de.bioforscher.singa.structure.model.oak.OakModel;
import de.bioforscher.singa.structure.model.oak.OakStructure;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureRepresentation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureWriter {
    private static final Logger logger = LoggerFactory.getLogger(StructureWriter.class);

    private StructureWriter() {
    }

    public static void writeLeafSubstructureContainer(LeafSubstructureContainer leafSubstructureContainer, Path outputPath) throws IOException {
        logger.info("Writing branch substructure {} to {}.", (Object)leafSubstructureContainer, (Object)outputPath);
        StructureWriter.writeLeafSubstructures(leafSubstructureContainer.getAllLeafSubstructures(), outputPath);
    }

    public static void writeLeafSubstructures(List<LeafSubstructure<?>> leafSubstructures, Path outputPath) throws IOException {
        logger.info("Writing {} leaf substructures to {}.", (Object)leafSubstructures.size(), (Object)outputPath);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        Files.write(outputPath, StructureRepresentation.composePdbRepresentation(leafSubstructures).getBytes(), new OpenOption[0]);
    }

    public static void writeStructure(OakStructure structure, Path outputPath) throws IOException {
        logger.info("Writing structure {} to {}.", (Object)structure, (Object)outputPath);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        Files.write(outputPath, StructureRepresentation.composePdbRepresentation(structure).getBytes(), new OpenOption[0]);
    }

    public static void writeWithConsecutiveNumbering(OakStructure structure, Path outputPath) throws IOException {
        OakStructure renumberedStructure = StructureWriter.prepareForConsecutiveRewrite(structure);
        StructureWriter.writeStructure(renumberedStructure, outputPath);
    }

    private static OakStructure prepareForConsecutiveRewrite(OakStructure structure) {
        logger.debug("Renumbering structure consecutively.");
        OakStructure renumberedStructure = new OakStructure();
        renumberedStructure.setPdbIdentifier(structure.getPdbIdentifier());
        int identifier = 1;
        for (Model model : structure.getAllModels()) {
            OakAtom renumberedAtom;
            OakLeafSubstructure<?> renumberedLeafSubstructure;
            OakChain renumberedChain;
            OakChain oakChain;
            OakModel renumberedModel = new OakModel(model.getModelIdentifier());
            renumberedStructure.addModel(renumberedModel);
            for (Chain chain : model.getAllChains()) {
                oakChain = (OakChain)chain;
                renumberedChain = new OakChain(chain.getChainIdentifier());
                renumberedModel.addChain(renumberedChain);
                for (LeafSubstructure<?> leafSubstructure : oakChain.getConsecutivePart()) {
                    renumberedLeafSubstructure = LeafSubstructureFactory.createLeafSubstructure(leafSubstructure.getIdentifier(), leafSubstructure.getFamily());
                    renumberedChain.addLeafSubstructure(renumberedLeafSubstructure, true);
                    for (Atom atom : leafSubstructure.getAllAtoms()) {
                        renumberedAtom = new OakAtom(identifier, atom.getElement(), atom.getAtomName(), atom.getPosition());
                        logger.trace("Renumbering atom {} to {}.", (Object)atom.getAtomIdentifier(), (Object)renumberedAtom.getAtomIdentifier());
                        renumberedLeafSubstructure.addAtom(renumberedAtom);
                        ++identifier;
                    }
                }
                logger.trace("Keeping identifier {} for terminator token.", (Object)identifier);
                ++identifier;
            }
            for (Chain chain : model.getAllChains()) {
                oakChain = (OakChain)chain;
                renumberedChain = (OakChain)renumberedModel.getChain(chain.getChainIdentifier()).get();
                for (LeafSubstructure<?> leafSubstructure : oakChain.getNonConsecutivePart()) {
                    renumberedLeafSubstructure = LeafSubstructureFactory.createLeafSubstructure(leafSubstructure.getIdentifier(), leafSubstructure.getFamily());
                    renumberedLeafSubstructure.setAnnotatedAsHetAtom(true);
                    renumberedChain.addLeafSubstructure(renumberedLeafSubstructure);
                    for (Atom atom : leafSubstructure.getAllAtoms()) {
                        renumberedAtom = new OakAtom(identifier, atom.getElement(), atom.getAtomName(), atom.getPosition());
                        renumberedLeafSubstructure.addAtom(renumberedAtom);
                        logger.trace("Renumbering atom {} to {}.", (Object)atom.getAtomIdentifier(), (Object)renumberedAtom.getAtomIdentifier());
                        ++identifier;
                    }
                }
            }
        }
        return renumberedStructure;
    }

    public static void writeToXYZ(AtomContainer atomContainer, Path outputPath) throws IOException {
        StringBuilder builder = new StringBuilder();
        DecimalFormat coordinateFormat = new DecimalFormat("0.00000", new DecimalFormatSymbols(Locale.US));
        builder.append(atomContainer.getAllAtoms().size()).append(System.lineSeparator()).append(System.lineSeparator());
        for (Atom atom : atomContainer.getAllAtoms()) {
            builder.append(atom.getElement().getSymbol()).append("\t").append(coordinateFormat.format(atom.getPosition().getX())).append("\t").append(coordinateFormat.format(atom.getPosition().getY())).append("\t").append(coordinateFormat.format(atom.getPosition().getZ())).append(System.lineSeparator());
        }
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        Files.write(outputPath, builder.toString().getBytes(), new OpenOption[0]);
    }
}

