/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.structures.tokens;

import de.bioforscher.singa.core.utility.Range;
import java.util.regex.Pattern;

public interface PDBToken {
    public static String extractValueFromPDBLine(String line, PDBToken token) {
        if (line.length() >= (Integer)token.getColumns().getUpperBound()) {
            return line.substring((Integer)token.getColumns().getLowerBound() - 1, (Integer)token.getColumns().getUpperBound()).trim();
        }
        return "";
    }

    public static String endLine(String content) {
        StringBuilder filler = new StringBuilder();
        for (int i = 0; i < 80 - content.length(); ++i) {
            filler.append(" ");
        }
        return content + filler + System.lineSeparator();
    }

    public Pattern getRecordNamePattern();

    public Range<Integer> getColumns();

    default public String extract(String line) {
        return PDBToken.extractValueFromPDBLine(line, this);
    }
}

