/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pdb.structures.tokens;

import de.bioforscher.singa.core.utility.Range;
import de.bioforscher.singa.structure.parser.pdb.structures.tokens.PDBToken;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public enum TitleToken implements PDBToken
{
    CONTINUATION((Range<Integer>)Range.of((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10))),
    TEXT((Range<Integer>)Range.of((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(80)));

    public static final Pattern RECORD_PATTERN;
    private final Range<Integer> columns;

    private TitleToken(Range<Integer> columns) {
        this.columns = columns;
    }

    public static List<String> assemblePDBLines(String title) {
        title = title.toUpperCase();
        ArrayList<String> titleLines = new ArrayList<String>();
        if (title.length() < 70) {
            titleLines.add("TITLE     " + title);
        } else {
            int continuation = 1;
            while (title.length() >= 70) {
                if (continuation == 1) {
                    String substring = title.substring(0, title.substring(0, 70).lastIndexOf(32));
                    titleLines.add("TITLE     " + substring);
                    title = title.substring(substring.length());
                } else {
                    int lastIndex = title.substring(0, 69).lastIndexOf(32);
                    String substring = lastIndex <= 0 ? title.substring(0, 69) : title.substring(0, lastIndex);
                    titleLines.add("TITLE    " + continuation + substring);
                    title = title.substring(substring.length());
                }
                ++continuation;
            }
            titleLines.add("TITLE    " + continuation + title);
        }
        return titleLines;
    }

    @Override
    public Pattern getRecordNamePattern() {
        return RECORD_PATTERN;
    }

    @Override
    public Range<Integer> getColumns() {
        return this.columns;
    }

    @Override
    public String extract(String line) {
        if (line.length() >= (Integer)this.getColumns().getUpperBound()) {
            return line.substring((Integer)this.getColumns().getLowerBound() - 1, (Integer)this.getColumns().getUpperBound());
        }
        return line.substring((Integer)this.getColumns().getLowerBound() - 1);
    }

    static {
        RECORD_PATTERN = Pattern.compile("^TITLE.*");
    }
}

