/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pfam;

import de.bioforscher.singa.features.identifiers.PfamIdentifier;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParser;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParserOptions;
import de.bioforscher.singa.structure.parser.pfam.tokens.PfamToken;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PfamParser {
    private static final String DEFAULT_CHAIN_LIST_SEPARATOR = "\t";
    private static final Predicate<LeafSubstructure<?>> LEAF_SUBSTRUCTURE_FILTER = leafSubstructure -> !(leafSubstructure instanceof AminoAcid);
    private static final Logger logger = LoggerFactory.getLogger(PfamParser.class);
    private final PfamVersion version;
    private final PfamIdentifier pfamIdentifier;
    private final Path chainListPath;
    private final String chainListSeparator;
    private final boolean parseChains;
    private final StructureParserOptions structureParserOptions;
    private List<List<LeafSubstructure<?>>> domains;
    private List<Chain> chains;
    private List<String> relevantLines;

    public PfamParser(Builder builder) {
        this.version = builder.version;
        this.pfamIdentifier = builder.pfamIdentifier;
        this.chainListPath = builder.chainListPath;
        this.chainListSeparator = builder.chainListSeparator == null ? DEFAULT_CHAIN_LIST_SEPARATOR : builder.chainListSeparator;
        this.parseChains = builder.parseChains;
        this.structureParserOptions = builder.structureParserOptions;
        this.parse();
    }

    public static VersionStep create() {
        return new Builder();
    }

    private void parse() {
        this.fetchMappingFile();
        if (this.chainListPath != null) {
            try {
                List chainsToCollect = Files.lines(this.chainListPath).map(line -> line.split(this.chainListSeparator)).collect(Collectors.toList());
                this.relevantLines.removeIf(line -> chainsToCollect.stream().noneMatch(chain -> PfamToken.PDBToken.PDB_IDENTIFIER.extract((String)line).equalsIgnoreCase(chain[0]) && PfamToken.PDBToken.CHAIN_IDENTIFIER.extract((String)line).equals(chain[1])));
                logger.info("Pfam covers {} of {} chains in the provided list", (Object)this.relevantLines.size(), (Object)chainsToCollect.size());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (this.parseChains) {
            this.parseChains();
        } else {
            this.parseDomains();
        }
    }

    private void parseDomains() {
        ArrayList domains = new ArrayList();
        for (String relevantLine : this.relevantLines) {
            String pdbIdentifier = PfamToken.PDBToken.PDB_IDENTIFIER.extract(relevantLine).toLowerCase();
            String chainIdentifier = PfamToken.PDBToken.CHAIN_IDENTIFIER.extract(relevantLine);
            int startPdb = Integer.valueOf(PfamToken.PDBToken.PDB_RESIDUE_START.extract(relevantLine));
            int endPdb = Integer.valueOf(PfamToken.PDBToken.PDB_RESIDUE_END.extract(relevantLine));
            List<LeafSubstructure<?>> domain = this.structureParserOptions != null ? StructureParser.pdb().pdbIdentifier(pdbIdentifier).chainIdentifier(chainIdentifier).setOptions(this.structureParserOptions).parse().getAllLeafSubstructures() : StructureParser.pdb().pdbIdentifier(pdbIdentifier).chainIdentifier(chainIdentifier).parse().getAllLeafSubstructures();
            domain.removeIf(LEAF_SUBSTRUCTURE_FILTER);
            domain.removeIf(StructuralEntityFilter.LeafFilter.isWithinRange(startPdb, endPdb).negate());
            if (!domain.isEmpty()) {
                domains.add(domain);
                continue;
            }
            logger.warn("domain range of {}_{} contains no residues and is skipped", (Object)pdbIdentifier, (Object)chainIdentifier);
        }
        this.domains = domains;
    }

    private void parseChains() {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        for (String relevantLine : this.relevantLines) {
            String pdbIdentifier = PfamToken.PDBToken.PDB_IDENTIFIER.extract(relevantLine).toLowerCase();
            String chainIdentifier = PfamToken.PDBToken.CHAIN_IDENTIFIER.extract(relevantLine);
            logger.info("parsing Pfam chain {}_{}", (Object)pdbIdentifier, (Object)chainIdentifier);
            Chain chain = this.structureParserOptions != null ? StructureParser.pdb().pdbIdentifier(pdbIdentifier).chainIdentifier(chainIdentifier).setOptions(this.structureParserOptions).parse().getFirstModel().getFirstChain() : StructureParser.pdb().pdbIdentifier(pdbIdentifier).chainIdentifier(chainIdentifier).parse().getFirstModel().getFirstChain();
            chains.add(chain);
        }
        this.chains = chains;
    }

    private void fetchMappingFile() {
        try {
            logger.info("creating temporary file to store mapping file Pfam version {}", (Object)this.version);
            Path temporaryZippedFile = Files.createTempFile("singa_", ".txt.gz", new FileAttribute[0]);
            URL website = new URL(this.version.pfamMappingLocation);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(temporaryZippedFile.toFile());
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            rbc.close();
            logger.info("unzipping mapping file {}", (Object)temporaryZippedFile);
            try (GZIPInputStream zip = new GZIPInputStream(new FileInputStream(temporaryZippedFile.toFile()));
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)zip, "UTF-8"));){
                this.relevantLines = reader.lines().filter(line -> PfamToken.IdentifierToken.PFAM_IDENTIFIER.extract((String)line).equals(this.pfamIdentifier.getIdentifier())).collect(Collectors.toList());
                logger.info("Pfam {} has {} entries", (Object)this.pfamIdentifier, (Object)this.relevantLines.size());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<List<LeafSubstructure<?>>> getDomains() {
        return this.domains;
    }

    public List<Chain> getChains() {
        return this.chains;
    }

    public static class Builder
    implements VersionStep,
    FamilyStep,
    ChainStep,
    DomainStep {
        public StructureParserOptions structureParserOptions;
        private PfamVersion version;
        private PfamIdentifier pfamIdentifier;
        private Path chainListPath;
        private String chainListSeparator;
        private boolean parseChains;

        @Override
        public FamilyStep version(PfamVersion version) {
            Objects.requireNonNull(version);
            this.version = version;
            return this;
        }

        @Override
        public ChainStep pfamIdentifier(String pfamIdentifier) {
            Objects.requireNonNull(pfamIdentifier);
            this.pfamIdentifier = new PfamIdentifier(pfamIdentifier);
            return this;
        }

        @Override
        public DomainStep all() {
            return this;
        }

        @Override
        public DomainStep chainList(Path chainListPath) {
            Objects.requireNonNull(chainListPath);
            this.chainListPath = chainListPath;
            return this;
        }

        @Override
        public DomainStep chainList(Path chainListPath, String chainListSeparator) {
            Objects.requireNonNull(chainListPath);
            Objects.requireNonNull(chainListSeparator);
            this.chainListPath = chainListPath;
            this.chainListSeparator = chainListSeparator;
            return this;
        }

        @Override
        public DomainStep structureParserOptions(StructureParserOptions structureParserOptions) {
            Objects.requireNonNull(structureParserOptions);
            this.structureParserOptions = structureParserOptions;
            return this;
        }

        @Override
        public List<List<LeafSubstructure<?>>> domains() {
            return new PfamParser(this).getDomains();
        }

        @Override
        public List<Chain> chains() {
            this.parseChains = true;
            return new PfamParser(this).getChains();
        }
    }

    public static interface DomainStep {
        public DomainStep structureParserOptions(StructureParserOptions var1);

        public List<List<LeafSubstructure<?>>> domains();

        public List<Chain> chains();
    }

    public static interface ChainStep {
        public DomainStep all();

        public DomainStep chainList(Path var1);

        public DomainStep chainList(Path var1, String var2);
    }

    public static interface FamilyStep {
        public ChainStep pfamIdentifier(String var1);
    }

    public static interface VersionStep {
        public FamilyStep version(PfamVersion var1);
    }

    public static enum PfamVersion {
        V31("http://ftp.ebi.ac.uk/pub/databases/Pfam/releases/Pfam31.0/database_files/pdb_pfamA_reg.txt.gz");

        private final String pfamMappingLocation;

        private PfamVersion(String pfamMappingLocation) {
            this.pfamMappingLocation = pfamMappingLocation;
        }
    }
}

