/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.pfam.tokens;

public interface PfamToken {
    public static final String PFAM_MAPPING_FILE_SEPARATOR = "\t";

    public static String extractValueFromPfamLine(String line, PfamToken token) {
        return line.split(PFAM_MAPPING_FILE_SEPARATOR)[token.getColumn()].trim();
    }

    public int getColumn();

    default public String extract(String line) {
        return PfamToken.extractValueFromPfamLine(line, this);
    }

    public static enum IdentifierToken implements PfamToken
    {
        PFAM_IDENTIFIER(3),
        UNIPROT_IDENTIFIER(4);

        private final int column;

        private IdentifierToken(int column) {
            this.column = column;
        }

        @Override
        public int getColumn() {
            return this.column;
        }
    }

    public static enum PDBToken implements PfamToken
    {
        PDB_IDENTIFIER(2),
        CHAIN_IDENTIFIER(5),
        PDB_RESIDUE_START(10),
        PDB_RESIDUE_END(11);

        private final int column;

        private PDBToken(int column) {
            this.column = column;
        }

        @Override
        public int getColumn() {
            return this.column;
        }
    }
}

