/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.plip;

import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.structure.model.families.LigandFamily;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.identifiers.UniqueAtomIdentifer;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.oak.OakChain;
import de.bioforscher.singa.structure.model.oak.OakStructure;
import de.bioforscher.singa.structure.parser.plip.HydrogenBond;
import de.bioforscher.singa.structure.parser.plip.HydrophobicInteraction;
import de.bioforscher.singa.structure.parser.plip.Interaction;
import de.bioforscher.singa.structure.parser.plip.InteractionType;
import de.bioforscher.singa.structure.parser.plip.PiCation;
import de.bioforscher.singa.structure.parser.plip.PiStacking;
import de.bioforscher.singa.structure.parser.plip.SaltBridge;
import de.bioforscher.singa.structure.parser.plip.WaterBridge;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractionContainer {
    private static final Logger logger = LoggerFactory.getLogger(InteractionContainer.class);
    private final List<Interaction> interactions = new ArrayList<Interaction>();
    private final List<Interaction> ligandInteractions = new ArrayList<Interaction>();

    private static boolean interactionPairEquals(LeafIdentifier firstSource, LeafIdentifier firstTarget, LeafIdentifier secondSource, LeafIdentifier secondTarget) {
        if (firstSource.equals(secondSource)) {
            return firstTarget.equals(secondTarget);
        }
        return firstSource.equals(secondTarget) && firstTarget.equals(secondSource);
    }

    private static boolean atomsOverlap(List<Integer> firstList, List<Integer> secondList) {
        for (int first : firstList) {
            for (int second : secondList) {
                if (first != second) continue;
                return true;
            }
        }
        return false;
    }

    public List<Interaction> getInteractionsBetween(LeafIdentifier first, LeafIdentifier second) {
        return Stream.concat(this.interactions.stream(), this.ligandInteractions.stream()).filter(interaction -> InteractionContainer.interactionPairEquals(interaction.getSource(), interaction.getTarget(), first, second)).collect(Collectors.toList());
    }

    public boolean hasInteractions(LeafIdentifier first, LeafIdentifier second) {
        return Stream.concat(this.interactions.stream(), this.ligandInteractions.stream()).anyMatch(interaction -> InteractionContainer.interactionPairEquals(interaction.getSource(), interaction.getTarget(), first, second));
    }

    public void mapToPseudoAtoms(OakStructure structure) {
        Stream.concat(this.interactions.stream(), this.ligandInteractions.stream()).forEach(interaction -> {
            Vector3D centroid = new Vector3D(interaction.getLigandCoordinate()).add(new Vector3D(interaction.getProteinCoordinate())).multiply(0.5);
            structure.addAtom(interaction.getSource().getChainIdentifier(), InteractionType.getThreeLetterCode(interaction.getClass()), centroid);
        });
    }

    public List<Interaction> getInteractions() {
        return this.interactions;
    }

    public List<Interaction> getLigandInteractions() {
        return this.ligandInteractions;
    }

    public void addInteraction(Interaction interaction) {
        logger.debug("Handling interaction between: {} and {}", (Object)interaction.getSource(), (Object)interaction.getTarget());
        List<Interaction> presentInteractions = this.getInteractionsBetween(interaction.getSource(), interaction.getTarget());
        if (presentInteractions.size() > 0) {
            logger.trace("There are already interactions annotated between those leaves.");
            boolean allAreDifferent = true;
            boolean symmetricEntriesFound = false;
            boolean uncertainInteraction = false;
            for (Interaction presentInteraction : presentInteractions) {
                Interaction iNew;
                Interaction iPresent;
                if (!presentInteraction.getClass().equals(interaction.getClass())) continue;
                allAreDifferent = false;
                logger.trace("There is already an interaction of the same kind.");
                if (interaction instanceof HydrogenBond) {
                    iPresent = (HydrogenBond)presentInteraction;
                    iNew = (HydrogenBond)interaction;
                    if (((HydrogenBond)iPresent).getAcceptor() == ((HydrogenBond)iNew).getAcceptor() && ((HydrogenBond)iPresent).getDonor() == ((HydrogenBond)iNew).getDonor()) {
                        logger.trace("The hydrogen bond (id {}) is the symmetric version of the already added hydrogen bond {}.", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                        logger.trace("Present : {}", (Object)presentInteraction);
                        symmetricEntriesFound = true;
                        break;
                    }
                    if (((HydrogenBond)iPresent).getAcceptor() == ((HydrogenBond)iNew).getDonor() && ((HydrogenBond)iPresent).getDonor() == ((HydrogenBond)iNew).getAcceptor()) {
                        logger.info("The hydrogen bond (id {}) has swapped donor and acceptor with hydrogen bond {}.", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                        logger.info("Present : {}", (Object)presentInteraction);
                        uncertainInteraction = true;
                        symmetricEntriesFound = true;
                        break;
                    }
                    logger.trace("The hydrophobic interaction (id {}) is not the symmetric version of.", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                    logger.trace("Present : {}", (Object)presentInteraction);
                    continue;
                }
                if (interaction instanceof HydrophobicInteraction) {
                    iPresent = (HydrophobicInteraction)presentInteraction;
                    iNew = (HydrophobicInteraction)interaction;
                    if (((HydrophobicInteraction)iPresent).getAtom1() == ((HydrophobicInteraction)iNew).getAtom1() && ((HydrophobicInteraction)iPresent).getAtom2() == ((HydrophobicInteraction)iNew).getAtom2()) {
                        logger.trace("The hydrophobic interaction (id {}) is the symmetric version of the already added hydrophobic interaction {}.", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                        logger.trace("Present : {}", (Object)presentInteraction);
                        symmetricEntriesFound = true;
                        break;
                    }
                    logger.trace("The the hydrophobic interaction (id {}) is not the symmetric version of the hydrophobic interaction (id {}).", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                    logger.trace("Present : {}", (Object)presentInteraction);
                    continue;
                }
                if (interaction instanceof WaterBridge) {
                    iPresent = (WaterBridge)presentInteraction;
                    iNew = (WaterBridge)interaction;
                    if (((WaterBridge)iPresent).getAcceptor() == ((WaterBridge)iNew).getAcceptor() && ((WaterBridge)iPresent).getDonor() == ((WaterBridge)iNew).getDonor() || ((WaterBridge)iPresent).getDonor() == ((WaterBridge)iNew).getAcceptor() && ((WaterBridge)iPresent).getAcceptor() == ((WaterBridge)iNew).getDonor()) {
                        logger.trace("The water bridge (id {}) is the symmetric version of the already added water bridge {}.", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                        logger.trace("Present : {}", (Object)presentInteraction);
                        symmetricEntriesFound = true;
                        break;
                    }
                    logger.trace("The water bridge (id {}) is not the symmetric version of the water bridge (id {}).", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                    logger.trace("Present : {}", (Object)presentInteraction);
                    continue;
                }
                if (interaction instanceof SaltBridge) continue;
                if (interaction instanceof PiStacking) {
                    iPresent = (PiStacking)presentInteraction;
                    iNew = (PiStacking)interaction;
                    if (((PiStacking)iPresent).getAtoms2().equals(((PiStacking)iNew).getAtoms2())) {
                        logger.trace("The pi stack (id {}) is the identical version of the already added pi stack {}.", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                        logger.trace("Present : {}", (Object)presentInteraction);
                        symmetricEntriesFound = true;
                        break;
                    }
                    logger.trace("The pi stack (id {}) is not the symmetric version of the pi stack (id {}).", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                    logger.trace("Present : {}", (Object)presentInteraction);
                    continue;
                }
                if (interaction instanceof PiCation) {
                    iPresent = (PiCation)presentInteraction;
                    iNew = (PiCation)interaction;
                    if (((PiCation)iPresent).getAtoms2().equals(((PiCation)iNew).getAtoms2())) {
                        logger.trace("The pi-cation interaction (id {}) is the identical version of the already added pi-cation interaction  {}.", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                        logger.trace("Present : {}", (Object)presentInteraction);
                        symmetricEntriesFound = true;
                        break;
                    }
                    logger.trace("The pi-cation interaction  (id {}) is not the symmetric version of the pi-cation interaction  (id {}).", (Object)iNew.getPlipIdentifier(), (Object)iPresent.getPlipIdentifier());
                    logger.trace("Present : {}", (Object)presentInteraction);
                    continue;
                }
                logger.info("Interaction of {} (id={}) is a possible duplicate of {} with (id={}). Don't know what to do yet. ", new Object[]{interaction.getClass().getSimpleName(), interaction.getPlipIdentifier(), presentInteraction.getClass().getSimpleName(), presentInteraction.getPlipIdentifier()});
                uncertainInteraction = true;
                logger.info("Present : {}", (Object)presentInteraction);
            }
            if (!symmetricEntriesFound && !uncertainInteraction) {
                logger.trace("Adding  : {}", (Object)interaction);
                this.interactions.add(interaction);
                return;
            }
            if (uncertainInteraction) {
                logger.debug("Skipping uncertain interaction: {}", (Object)interaction);
            } else {
                logger.trace("Skipping: {}", (Object)interaction);
            }
            if (allAreDifferent) {
                logger.trace("This kind of interaction is not present between the leaves.");
                logger.trace("Adding  : {}", (Object)interaction);
                this.interactions.add(interaction);
            }
        } else {
            logger.trace("There are no interactions annotated between those leaves.");
            logger.trace("Adding  : {}", (Object)interaction);
            this.interactions.add(interaction);
        }
    }

    public void validateWithStructure(OakStructure structure) {
        ListIterator<Interaction> interactionListIterator = this.interactions.listIterator();
        while (interactionListIterator.hasNext()) {
            Interaction interaction = interactionListIterator.next();
            boolean sourceIsLigand = false;
            boolean targetIsLigand = false;
            LeafIdentifier source = interaction.getSource();
            Optional<LeafSubstructure<?>> optionalSourceLeaf = structure.getLeafSubstructure(source);
            if (!optionalSourceLeaf.isPresent()) {
                logger.debug("Bad leaf reference for source {} in {}.", (Object)source, (Object)interaction);
                this.fixBrokenSourceIdentifier(interaction, structure);
            } else {
                LeafSubstructure<?> leafSubstructure = optionalSourceLeaf.get();
                sourceIsLigand = this.determineLigandInteraction(leafSubstructure, structure);
            }
            LeafIdentifier target = interaction.getTarget();
            Optional<LeafSubstructure<?>> optionalTargetLeaf = structure.getLeafSubstructure(target);
            if (!optionalTargetLeaf.isPresent()) {
                logger.debug("Bad leaf reference for target {} in {}.", (Object)target, (Object)interaction);
                this.fixBrokenTargetIdentifier(interaction, structure);
            } else {
                LeafSubstructure<?> leafSubstructure = optionalTargetLeaf.get();
                targetIsLigand = this.determineLigandInteraction(leafSubstructure, structure);
            }
            if (!targetIsLigand && !sourceIsLigand) continue;
            this.ligandInteractions.add(interaction);
            interactionListIterator.remove();
        }
    }

    private void fixBrokenSourceIdentifier(Interaction interaction, OakStructure structure) {
        int firstSourceAtom = interaction.getFirstSourceAtom();
        Optional<Map.Entry<UniqueAtomIdentifer, Atom>> sourceEntry = structure.getUniqueAtomEntry(firstSourceAtom);
        if (sourceEntry.isPresent()) {
            UniqueAtomIdentifer atomIdentifer = sourceEntry.get().getKey();
            LeafIdentifier leafIdentifier = new LeafIdentifier(atomIdentifer.getPdbIdentifier(), atomIdentifer.getModelIdentifier(), atomIdentifer.getChainIdentifier(), atomIdentifer.getLeafSerial(), atomIdentifer.getLeafInsertionCode());
            logger.debug("Fixed to leaf identifier {}.", (Object)leafIdentifier);
            interaction.setSource(leafIdentifier);
        } else {
            logger.warn("Unable to fix {}.", (Object)interaction);
        }
    }

    private void fixBrokenTargetIdentifier(Interaction interaction, OakStructure structure) {
        Optional<Map.Entry<UniqueAtomIdentifer, Atom>> targetEntry = structure.getUniqueAtomEntry(interaction.getFirstTargetAtom());
        if (targetEntry.isPresent()) {
            UniqueAtomIdentifer atomIdentifer = targetEntry.get().getKey();
            LeafIdentifier leafIdentifier = new LeafIdentifier(atomIdentifer.getPdbIdentifier(), atomIdentifer.getModelIdentifier(), atomIdentifer.getChainIdentifier(), atomIdentifer.getLeafSerial(), atomIdentifer.getLeafInsertionCode());
            logger.debug("Fixed to leaf identifier {}.", (Object)leafIdentifier);
            interaction.setTarget(leafIdentifier);
        } else {
            logger.warn("Unable to fix {}.", (Object)interaction);
        }
    }

    private boolean determineLigandInteraction(LeafSubstructure leafSubstructure, Structure structure) {
        Optional<Chain> optionalChain;
        if (leafSubstructure.getFamily() instanceof LigandFamily && (optionalChain = structure.getFirstModel().getChain(leafSubstructure.getIdentifier().getChainIdentifier())).isPresent()) {
            OakChain chain = (OakChain)optionalChain.get();
            if (!chain.getConsecutivePart().contains(leafSubstructure)) {
                logger.debug("{} is an interaction to a ligand", (Object)leafSubstructure);
                return true;
            }
            logger.debug("{} seems to be a ligand but is in the consecutive part of the chain", (Object)leafSubstructure);
        }
        return false;
    }
}

