/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.plip;

import de.bioforscher.singa.core.parser.AbstractXMLParser;
import de.bioforscher.singa.structure.parser.plip.InteractionContainer;
import de.bioforscher.singa.structure.parser.plip.PlipContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PlipParser
extends AbstractXMLParser<InteractionContainer> {
    private static final Logger logger = LoggerFactory.getLogger(PlipParser.class);

    private PlipParser(String pdbIdentifier, InputStream inputStream) {
        logger.info("Parsing interactions for {}", (Object)pdbIdentifier);
        this.getXmlReader().setContentHandler(new PlipContentHandler(pdbIdentifier));
        this.setFetchResult(inputStream);
    }

    private PlipParser(String pdbIdentifier) {
        logger.info("Parsing interactions for {}", (Object)pdbIdentifier);
        this.getXmlReader().setContentHandler(new PlipContentHandler(pdbIdentifier));
    }

    public static InteractionContainer parse(String pdbIdentifier, String plipXml) {
        PlipParser parser = new PlipParser(pdbIdentifier);
        try {
            parser.getXmlReader().parse(new InputSource(new StringReader(plipXml)));
            return ((PlipContentHandler)parser.getXmlReader().getContentHandler()).getInteractionContainer();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not parse XML from fetch result, the server seems to be unavailable.", e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Could not parse XML from fetch result, the XML seems to be malformed.", e);
        }
    }

    public static InteractionContainer parse(String pdbIdentifier, InputStream inputStream) {
        PlipParser parser = new PlipParser(pdbIdentifier, inputStream);
        try {
            parser.getXmlReader().parse(new InputSource(parser.getFetchResult()));
            return ((PlipContentHandler)parser.getXmlReader().getContentHandler()).getInteractionContainer();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not parse XML from fetch result, the server seems to be unavailable.", e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Could not parse XML from fetch result, the XML seems to be malformed.", e);
        }
    }

    public InteractionContainer parse() {
        this.parseXML();
        return ((PlipContentHandler)this.getXmlReader().getContentHandler()).getInteractionContainer();
    }

    private void parseXML() {
        this.fetchResource();
        try {
            this.getXmlReader().parse(new InputSource(this.getFetchResult()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not parse xml from fetch result, the server seems to be unavailable.", e);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

