/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.parser.sifts;

import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class ResidueMapContentHandler
implements ContentHandler {
    public Map<LeafIdentifier, Integer> mapping;
    private static final Pattern insertionCode = Pattern.compile("(\\d+)(\\p{Alpha}*)");
    private String currentTag;
    private String currentPdbid;
    private int currentModel = 1;
    private String currentChain;
    private int currentResidue;
    private int mappedResidue;
    private char currentInsertionCode;
    private boolean inResidue;
    private boolean skip;

    public ResidueMapContentHandler(String currentPdbid) {
        this.currentPdbid = currentPdbid;
        this.mapping = new HashMap<LeafIdentifier, Integer>();
    }

    public Map<LeafIdentifier, Integer> getMapping() {
        return this.mapping;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (!this.skip) {
            switch (qName) {
                case "residue": {
                    this.inResidue = true;
                }
                case "crossRefDb": {
                    if (!this.inResidue) break;
                    String dbSource = atts.getValue("dbSource");
                    if (dbSource.equals("PDB")) {
                        String dbResNum = atts.getValue("dbResNum");
                        this.currentChain = atts.getValue("dbChainId");
                        if (dbResNum.equals("null")) {
                            this.skip = true;
                            break;
                        }
                        Matcher matcher = insertionCode.matcher(dbResNum);
                        if (!matcher.matches()) break;
                        this.currentResidue = Integer.valueOf(matcher.group(1));
                        this.currentInsertionCode = matcher.group(2).isEmpty() ? (char)'\u0000' : matcher.group(2).charAt(0);
                        break;
                    }
                    if (!dbSource.equals("UniProt")) break;
                    String dbResNum = atts.getValue("dbResNum");
                    this.mappedResidue = Integer.valueOf(dbResNum);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (qName) {
            case "residue": {
                if (this.skip) {
                    this.skip = false;
                } else {
                    this.mapping.put(new LeafIdentifier(this.currentPdbid, this.currentModel, this.currentChain, this.currentResidue, this.currentInsertionCode), this.mappedResidue);
                }
                this.inResidue = false;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
    }
}

