/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz;

import de.bottlecaps.markup.Blitz;
import de.bottlecaps.markup.BlitzException;
import de.bottlecaps.markup.BlitzIxmlException;
import de.bottlecaps.markup.BlitzParseException;
import de.bottlecaps.markup.blitz.Errors;
import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.codepoints.RangeSet;
import de.bottlecaps.markup.blitz.codepoints.UnicodeCategory;
import de.bottlecaps.markup.blitz.grammar.Mark;
import de.bottlecaps.markup.blitz.parser.ReduceArgument;
import de.bottlecaps.markup.blitz.transform.CompressedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;

public class Parser {
    public static final String IXML_NAMESPACE = "http://invisiblexml.org/NS";
    private static int STALL_THRESHOLD = 8;
    private BottomUpEventHandler eventHandler;
    private String input = null;
    private int size = 0;
    private int maxId = 0;
    private Writer err = new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8);
    private boolean trace;
    private final Set<Blitz.Option> defaultOptions;
    private final int[] asciiMap;
    private final CompressedMap bmpMap;
    private final int[] smpMap;
    private final CompressedMap terminalTransitions;
    private final int numberOfTokens;
    private final CompressedMap nonterminalTransitions;
    private final int numberOfNonterminals;
    private final ReduceArgument[] reduceArguments;
    private final String[] nonterminal;
    private final RangeSet[] terminal;
    private final int[] forks;
    private final BitSet[] expectedTokens;
    private final boolean isVersionMismatch;

    public Parser(Set<Blitz.Option> defaultOptions, int[] asciiMap, CompressedMap bmpMap, int[] smpMap, CompressedMap terminalTransitions, int numberOfTokens, CompressedMap nonterminalTransitions, int numberOfNonterminals, ReduceArgument[] reduceArguments, String[] nonterminal, RangeSet[] terminal, int[] forks, BitSet[] expectedTokens, boolean isVersionMismatch) {
        this.defaultOptions = defaultOptions;
        this.asciiMap = asciiMap;
        this.bmpMap = bmpMap;
        this.smpMap = smpMap;
        this.terminalTransitions = terminalTransitions;
        this.numberOfTokens = numberOfTokens;
        this.nonterminalTransitions = nonterminalTransitions;
        this.numberOfNonterminals = numberOfNonterminals;
        this.reduceArguments = reduceArguments;
        this.nonterminal = nonterminal;
        this.terminal = terminal;
        this.forks = forks;
        this.expectedTokens = expectedTokens;
        this.isVersionMismatch = isVersionMismatch;
    }

    public RangeSet getOffendingToken(ParseException e) {
        return e.getOffending() < 0 ? null : this.terminal[e.getOffending()];
    }

    public String[] getExpectedTokenSet(ParseException e) {
        return this.getTokenSet(e.getState());
    }

    public String getErrorMessage(ParseException e) {
        Object message = e.getMessage();
        Object[] tokenSet = this.getExpectedTokenSet(e);
        String found = e.getOffending() < 0 ? null : this.terminal[e.getOffending()].shortName();
        int size = e.getEnd() - e.getBegin();
        message = (String)message + (String)(found == null ? "" : ", found " + found) + "\nwhile expecting " + (String)(tokenSet.length == 1 ? tokenSet[0] : Arrays.toString(tokenSet)) + "\n" + (String)(size == 0 || found != null ? "" : "after successfully scanning " + size + " characters beginning ");
        message = (String)message + "at " + this.lineAndColumn(e.getBegin()) + ":\n..." + this.input.subSequence(e.getBegin(), Math.min(this.input.length(), e.getBegin() + 64)) + "...";
        if (e.wasStalled()) {
            message = (String)message + "\nHowever, some alternatives were discarded while parsing because they weresuspected to be involved in infinite ambiguity.";
        }
        return message;
    }

    private String lineAndColumn(int pos) {
        String prefix = this.input.subSequence(0, pos).toString();
        int line = prefix.replaceAll("[^\n]", "").length() + 1;
        int column = prefix.length() - prefix.lastIndexOf(10);
        return "line " + line + ", column " + column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parse(String input, Blitz.Option ... options) {
        Set<Blitz.Option> currentOptions = options.length == 0 ? this.defaultOptions : Set.of(options);
        long t0 = System.currentTimeMillis();
        boolean indent = currentOptions.contains((Object)Blitz.Option.INDENT);
        StringWriter w = new StringWriter(input.length());
        XmlSerializer s = new XmlSerializer(w, indent);
        ParseTreeBuilder b = new ParseTreeBuilder();
        this.trace = currentOptions.contains((Object)Blitz.Option.TRACE);
        if (this.trace) {
            this.writeTrace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<trace>\n");
        }
        this.eventHandler = b;
        this.input = input;
        this.size = input.length();
        this.maxId = 0;
        try {
            ParsingThread thread;
            try {
                thread = this.parse();
            }
            catch (ParseException pe) {
                int begin = pe.getBegin();
                String prefix = input.substring(0, begin);
                int offending = pe.getOffending();
                int line = prefix.replaceAll("[^\n]", "").length() + 1;
                int column = prefix.length() - prefix.lastIndexOf(10);
                throw new BlitzParseException("Failed to parse input:\n" + this.getErrorMessage(pe), (String)(offending >= 0 ? this.terminal[offending].shortName() : (begin < input.length() ? "'" + Character.toString(input.codePointAt(begin)) + "'" : "$")), line, column);
            }
            finally {
                if (this.trace) {
                    this.writeTrace("</trace>\n");
                    try {
                        this.err.flush();
                    }
                    catch (IOException iOException) {}
                }
                w.flush();
            }
            Nonterminal startSymbol = (Nonterminal)b.stack[0];
            if (startSymbol.children == null || startSymbol.children.length == 0) {
                Errors.D01.thro(new String[0]);
            }
            if (!(startSymbol.children[0] instanceof Nonterminal)) {
                Errors.D06.thro(new String[0]);
            }
            Nonterminal nonterminal = (Nonterminal)startSymbol.children[0];
            if (nonterminal.isAttribute) {
                Errors.D05.thro(new String[0]);
            }
            if (startSymbol.children.length != 1) {
                Errors.D06.thro(new String[0]);
            }
            if (thread.isAmbiguous || this.isVersionMismatch) {
                nonterminal.addChildren(this.attribute("xmlns:ixml", IXML_NAMESPACE));
                ArrayList<String> state = new ArrayList<String>();
                if (thread.isAmbiguous) {
                    state.add("ambiguous");
                }
                if (this.isVersionMismatch) {
                    state.add("version-mismatch");
                }
                nonterminal.addChildren(this.attribute("ixml:state", String.join((CharSequence)" ", state)));
            }
        }
        catch (BlitzIxmlException e) {
            if (currentOptions.contains((Object)Blitz.Option.FAIL_ON_ERROR)) {
                throw e;
            }
            Nonterminal ixml = new Nonterminal("ixml", new Symbol[]{new Insertion(e.getMessage().codePoints().toArray())});
            ixml.addChildren(this.attribute("xmlns:ixml", IXML_NAMESPACE));
            ixml.addChildren(this.attribute("ixml:state", "failed"));
            ixml.addChildren(this.attribute("ixml:error-code", e.getError().name()));
            b.stack[0] = new Nonterminal("root", new Symbol[]{ixml});
        }
        catch (BlitzException e) {
            if (currentOptions.contains((Object)Blitz.Option.FAIL_ON_ERROR)) {
                throw e;
            }
            Nonterminal ixml = new Nonterminal("ixml", new Symbol[]{new Insertion(e.getMessage().codePoints().toArray())});
            ixml.addChildren(this.attribute("xmlns:ixml", IXML_NAMESPACE));
            ixml.addChildren(this.attribute("ixml:state", "failed"));
            b.stack[0] = new Nonterminal("root", new Symbol[]{ixml});
        }
        finally {
            if (currentOptions.contains((Object)Blitz.Option.TIMING)) {
                long t1 = System.currentTimeMillis();
                System.err.println("        ixml parsing time: " + (t1 - t0) + " msec");
            }
        }
        b.serialize(s);
        return w.toString();
    }

    private Nonterminal attribute(String name, String value) {
        Nonterminal attribute = new Nonterminal(name, (Symbol[])value.codePoints().mapToObj(x$0 -> new Terminal(x$0)).toArray(Symbol[]::new));
        attribute.setAttribute(true);
        return attribute;
    }

    private ParsingThread parse() throws ParseException {
        LinkedList<ParsingThread> currentThreads = new LinkedList<ParsingThread>();
        PriorityQueue<ParsingThread> otherThreads = new PriorityQueue<ParsingThread>();
        ParsingThread thread = new ParsingThread();
        int pos = 0;
        boolean stalled = false;
        while (true) {
            if (thread.equals(otherThreads.peek())) {
                if (this.trace) {
                    this.writeTrace("  <parse thread=\"" + thread.id + "\" offset=\"" + thread.e0 + "\" state=\"" + thread.state + "\" action=\"discard\"/>\n");
                }
                ParsingThread t = (ParsingThread)otherThreads.remove();
                if (t.deferredEvent == null || t.deferredEvent.queueSize < thread.deferredEvent.queueSize) {
                    thread = t;
                }
                thread.isAmbiguous = true;
                t = (ParsingThread)otherThreads.peek();
                continue;
            }
            boolean isUnambiguous = otherThreads.isEmpty();
            if (isUnambiguous && thread.deferredEvent != null) {
                thread.deferredEvent.release(this.eventHandler);
                thread.deferredEvent = null;
            }
            if (thread.status == Status.ACCEPTED) {
                if (!isUnambiguous) {
                    throw new IllegalStateException();
                }
                return thread;
            }
            Arrays.fill(thread.forkCount, (byte)0);
            int repeatedForks = 0;
            do {
                int fork;
                if ((fork = thread.parse(isUnambiguous)) >= 0) {
                    isUnambiguous = false;
                    thread.action = this.forks[2 * fork];
                    if (thread.e0 > pos) {
                        otherThreads.add(thread);
                        otherThreads.add(new ParsingThread(thread, this.forks[2 * fork + 1]));
                        continue;
                    }
                    if (thread.forkCount[fork] > 0 && repeatedForks >= STALL_THRESHOLD) {
                        stalled = true;
                        if (!this.trace) continue;
                        this.writeTrace("  <parse thread=\"" + thread.id + "\" offset=\"" + thread.e0 + "\" state=\"" + thread.state + "\" action=\"stalled\"/>\n");
                        continue;
                    }
                    int n = fork;
                    byte by = thread.forkCount[n];
                    thread.forkCount[n] = (byte)(by + 1);
                    if (by > 1) {
                        ++repeatedForks;
                    }
                    currentThreads.add(thread);
                    currentThreads.add(new ParsingThread(thread, this.forks[2 * fork + 1]));
                    continue;
                }
                if (thread.status != Status.ERROR) {
                    otherThreads.add(thread);
                    continue;
                }
                if (!otherThreads.isEmpty() || !currentThreads.isEmpty()) continue;
                throw new ParseException(thread.b1, thread.e1, thread.state, thread.l1, stalled);
            } while ((thread = (ParsingThread)currentThreads.poll()) != null);
            thread = (ParsingThread)otherThreads.remove();
            if (thread.e0 <= pos) continue;
            pos = thread.e0;
        }
    }

    private static String xmlEscape(String s) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void setTraceWriter(Writer w) {
        this.err = w;
    }

    private void writeTrace(String content) {
        try {
            this.err.write(content);
        }
        catch (IOException e) {
            throw new BlitzException(e);
        }
    }

    private String[] getTokenSet(int tokenSetId) {
        ArrayList<String> expected = new ArrayList<String>();
        BitSet tokens = this.expectedTokens[tokenSetId];
        int i = tokens.nextSetBit(0);
        while (i >= 0) {
            expected.add(this.terminal[i].shortName());
            i = tokens.nextSetBit(i + 1);
        }
        return (String[])expected.toArray(String[]::new);
    }

    private class ParsingThread
    implements Comparable<ParsingThread> {
        private byte[] forkCount;
        public Status status;
        public StackNode stack;
        public int state;
        public int action;
        public DeferredEvent deferredEvent;
        public int id;
        public boolean isAmbiguous;
        public int group;
        private int b0;
        private int e0;
        private int b1;
        private int e1;
        private int c1;
        private int l1;
        private int begin;
        private int end;

        public ParsingThread() {
            this.forkCount = new byte[Parser.this.forks.length / 2];
            this.b0 = 0;
            this.e0 = 0;
            this.b1 = 0;
            this.e1 = 0;
            this.l1 = 0;
            this.end = 0;
            this.id = Parser.this.maxId = 0;
            this.isAmbiguous = false;
            this.status = Status.PARSING;
            this.deferredEvent = null;
            this.stack = new StackNode(-1, null);
            this.state = 0;
            this.action = this.predict(this.state);
            this.group = this.id;
        }

        public ParsingThread(ParsingThread other, int action) {
            this.forkCount = Arrays.copyOf(other.forkCount, other.forkCount.length);
            this.action = action;
            this.status = other.status;
            this.deferredEvent = other.deferredEvent;
            this.id = ++Parser.this.maxId;
            this.state = other.state;
            this.stack = other.stack;
            this.b0 = other.b0;
            this.e0 = other.e0;
            this.c1 = other.c1;
            this.l1 = other.l1;
            this.b1 = other.b1;
            this.e1 = other.e1;
            this.end = other.end;
            this.isAmbiguous = other.isAmbiguous;
            this.group = other.group;
        }

        @Override
        public int compareTo(ParsingThread other) {
            if (this.status != other.status) {
                return this.status == Status.ACCEPTED ? 1 : -1;
            }
            int comp = this.e0 - other.e0;
            if (comp != 0) {
                return comp;
            }
            comp = this.group - other.group;
            if (comp != 0) {
                return comp;
            }
            return other.id - this.id;
        }

        public boolean equals(Object obj) {
            ParsingThread other = (ParsingThread)obj;
            if (other == null) {
                return false;
            }
            if (this.status != other.status) {
                return false;
            }
            if (this.b1 != other.b1) {
                return false;
            }
            if (this.e1 != other.e1) {
                return false;
            }
            if (this.l1 != other.l1) {
                return false;
            }
            if (this.state != other.state) {
                return false;
            }
            if (this.action != other.action) {
                return false;
            }
            return this.stack.equals(other.stack);
        }

        public int parse(boolean isUnambiguous) throws ParseException {
            int pos;
            int nonterminalId = -1;
            int n = pos = isUnambiguous ? Integer.MAX_VALUE : this.e0;
            while (true) {
                if (Parser.this.trace) {
                    Parser.this.writeTrace("  <parse thread=\"" + this.id + "\" offset=\"" + this.e0 + "\" state=\"" + this.state + "\" input=\"");
                    if (nonterminalId >= 0) {
                        Parser.this.writeTrace(Parser.xmlEscape(Parser.this.nonterminal[nonterminalId]));
                        if (this.l1 != 0) {
                            Parser.this.writeTrace(" ");
                        }
                    }
                    Parser.this.writeTrace(Parser.xmlEscape(this.lookaheadString()) + "\" action=\"");
                }
                int argument = this.action >> 3;
                int shift = -1;
                int reduce = -1;
                switch (this.action & 7) {
                    case 1: {
                        shift = argument;
                        break;
                    }
                    case 2: {
                        shift = this.state;
                    }
                    case 3: {
                        reduce = argument;
                        break;
                    }
                    case 4: {
                        if (Parser.this.trace) {
                            Parser.this.writeTrace("fork\"/>\n");
                        }
                        return argument;
                    }
                    case 5: {
                        if (Parser.this.trace) {
                            Parser.this.writeTrace("accept\"/>\n");
                        }
                        this.status = Status.ACCEPTED;
                        this.action = 0;
                        return -1;
                    }
                    default: {
                        if (Parser.this.trace) {
                            Parser.this.writeTrace("fail\"/>\n");
                        }
                        this.status = Status.ERROR;
                        return -1;
                    }
                }
                if (shift >= 0) {
                    if (Parser.this.trace) {
                        Parser.this.writeTrace("shift");
                    }
                    if (nonterminalId < 0) {
                        if (Parser.this.eventHandler != null) {
                            if (isUnambiguous) {
                                Parser.this.eventHandler.terminal(this.c1);
                            } else {
                                this.deferredEvent = new TerminalEvent(this.deferredEvent, this.c1);
                            }
                        }
                        this.stack = new StackNode(this.state, this.stack);
                        this.b0 = this.b1;
                        this.e0 = this.e1;
                        this.c1 = -1;
                        this.l1 = 0;
                    } else {
                        this.stack = new StackNode(this.state, this.stack);
                    }
                    this.state = shift;
                }
                if (reduce < 0) {
                    if (Parser.this.trace) {
                        Parser.this.writeTrace("\"/>\n");
                    }
                    this.action = this.predict(this.state);
                    if (this.e0 > pos) {
                        return -1;
                    }
                    nonterminalId = -1;
                    continue;
                }
                ReduceArgument reduceArgument = Parser.this.reduceArguments[reduce];
                int symbols = reduceArgument.getMarks().length;
                nonterminalId = reduceArgument.getNonterminalId();
                if (Parser.this.trace) {
                    if (shift >= 0) {
                        Parser.this.writeTrace(" ");
                    }
                    Parser.this.writeTrace("reduce\" nonterminal=\"" + Parser.xmlEscape(Parser.this.nonterminal[nonterminalId]) + "\" count=\"" + symbols + "\"/>\n");
                }
                if (symbols > 0) {
                    for (int i = 1; i < symbols; ++i) {
                        this.stack = this.stack.link;
                    }
                    this.state = this.stack.state;
                    this.stack = this.stack.link;
                }
                if (Parser.this.eventHandler != null) {
                    if (isUnambiguous) {
                        Parser.this.eventHandler.nonterminal(reduceArgument);
                    } else {
                        this.deferredEvent = new NonterminalEvent(this.deferredEvent, reduceArgument);
                    }
                }
                this.action = Parser.this.nonterminalTransitions.get(this.state * Parser.this.numberOfNonterminals + nonterminalId);
            }
        }

        private String lookaheadString() {
            Object result = "";
            if (this.l1 > 0) {
                result = (String)result + Parser.this.terminal[this.l1].shortName();
            }
            return result;
        }

        public int predict(int state) {
            if (this.l1 == 0) {
                this.l1 = this.match();
                this.b1 = this.begin;
                this.e1 = this.end;
            }
            return this.l1 < 0 ? 0 : Parser.this.terminalTransitions.get(state * Parser.this.numberOfTokens + this.l1);
        }

        private int match() {
            int charclass;
            if (Parser.this.trace) {
                Parser.this.writeTrace("  <tokenize thread=\"" + this.id + "\" offset=\"" + this.end + "\"");
            }
            this.begin = this.end;
            if (this.end >= Parser.this.size) {
                this.c1 = -1;
                charclass = 0;
            } else {
                this.c1 = Parser.this.input.charAt(this.end++);
                if (this.c1 < 128) {
                    if (Parser.this.trace && this.c1 >= 32 && this.c1 <= 126) {
                        Parser.this.writeTrace(" char=\"" + Parser.xmlEscape(String.valueOf((char)this.c1)) + "\"");
                    }
                    charclass = Parser.this.asciiMap[this.c1];
                } else if (this.c1 < 55296) {
                    charclass = Parser.this.bmpMap.get(this.c1);
                } else {
                    if (this.c1 < 56320) {
                        int lowSurrogate;
                        int n = lowSurrogate = this.end < Parser.this.size ? (int)Parser.this.input.charAt(this.end) : 0;
                        if (lowSurrogate >= 56320 && lowSurrogate < 57344) {
                            ++this.end;
                            this.c1 = ((this.c1 & 0x3FF) << 10) + (lowSurrogate & 0x3FF) + 65536;
                        }
                    }
                    int smpMapSize = Parser.this.smpMap.length / 3;
                    int lo = 0;
                    int hi = smpMapSize - 1;
                    int m = hi >> 1;
                    while (true) {
                        if (Parser.this.smpMap[m] > this.c1) {
                            hi = m - 1;
                        } else if (Parser.this.smpMap[smpMapSize + m] < this.c1) {
                            lo = m + 1;
                        } else {
                            charclass = Parser.this.smpMap[2 * smpMapSize + m];
                            break;
                        }
                        if (lo > hi) {
                            charclass = -1;
                            break;
                        }
                        m = hi + lo >> 1;
                    }
                }
                if (Parser.this.trace && this.c1 >= 0) {
                    Parser.this.writeTrace(" codepoint=\"" + this.c1 + "\"");
                }
                if (charclass <= 0) {
                    if (Parser.this.trace) {
                        Parser.this.writeTrace(" status=\"fail\" end=\"" + this.end + "\"/>\n");
                    }
                    this.end = this.begin;
                    return -1;
                }
            }
            if (Parser.this.trace) {
                Parser.this.writeTrace(" class=\"" + charclass + "\"");
                Parser.this.writeTrace(" status=\"success\" result=\"");
                Parser.this.writeTrace(Parser.xmlEscape(Parser.this.terminal[charclass].shortName()));
                Parser.this.writeTrace("\" end=\"" + this.end + "\"/>\n");
            }
            return charclass;
        }
    }

    private static enum Status {
        PARSING,
        ACCEPTED,
        ERROR;

    }

    public static class NonterminalEvent
    extends DeferredEvent {
        public ReduceArgument reduceArgument;

        public NonterminalEvent(DeferredEvent link, ReduceArgument reduceArgument) {
            super(link, 0, 0);
            this.reduceArgument = reduceArgument;
        }

        @Override
        public void execute(BottomUpEventHandler eventHandler) {
            eventHandler.nonterminal(this.reduceArgument);
        }
    }

    public static class TerminalEvent
    extends DeferredEvent {
        private int codepoint;

        public TerminalEvent(DeferredEvent link, int codepoint) {
            super(link, 0, 0);
            this.codepoint = codepoint;
        }

        @Override
        public void execute(BottomUpEventHandler eventHandler) {
            eventHandler.terminal(this.codepoint);
        }
    }

    private static abstract class DeferredEvent {
        public DeferredEvent link;
        public int queueSize;
        public int begin;
        public int end;

        public DeferredEvent(DeferredEvent link, int begin, int end) {
            this.link = link;
            this.queueSize = link == null ? 0 : link.queueSize + 1;
            this.begin = begin;
            this.end = end;
        }

        public abstract void execute(BottomUpEventHandler var1);

        public void release(BottomUpEventHandler eventHandler) {
            DeferredEvent current = this;
            DeferredEvent predecessor = current.link;
            current.link = null;
            while (predecessor != null) {
                DeferredEvent next = predecessor.link;
                predecessor.link = current;
                current = predecessor;
                predecessor = next;
            }
            do {
                current.execute(eventHandler);
            } while ((current = current.link) != null);
        }

        public void show(BottomUpEventHandler eventHandler) {
            Stack<DeferredEvent> stack = new Stack<DeferredEvent>();
            DeferredEvent current = this;
            while (current != null) {
                stack.push(current);
                current = current.link;
            }
            while (!stack.isEmpty()) {
                ((DeferredEvent)stack.pop()).execute(eventHandler);
            }
        }
    }

    private static class StackNode {
        public int state;
        public StackNode link;

        public StackNode(int state, StackNode link) {
            this.state = state;
            this.link = link;
        }

        public boolean equals(Object obj) {
            StackNode lhs = this;
            StackNode rhs = (StackNode)obj;
            while (lhs != null && rhs != null) {
                if (lhs == rhs) {
                    return true;
                }
                if (lhs.state != rhs.state) {
                    return false;
                }
                lhs = lhs.link;
                rhs = rhs.link;
            }
            return lhs == rhs;
        }
    }

    public class ParseTreeBuilder
    implements BottomUpEventHandler {
        public Symbol[] stack = new Symbol[64];
        public int top = -1;

        @Override
        public void nonterminal(ReduceArgument reduceArgument) {
            Mark[] marks = reduceArgument.getMarks();
            int[] aliases = reduceArgument.getAliases();
            int count = marks.length;
            this.top -= count;
            int from = this.top + 1;
            int to = this.top + count + 1;
            ArrayList<Insertion> children = null;
            block11: for (int i = from; i < to; ++i) {
                Symbol symbol = this.stack[i];
                Mark mark = marks[i - this.top - 1];
                if (symbol instanceof Terminal) {
                    switch (mark) {
                        case NODE: {
                            if (children == null) {
                                children = new ArrayList();
                            }
                            children.add((Insertion)symbol);
                            continue block11;
                        }
                        case DELETE: {
                            continue block11;
                        }
                        case ATTRIBUTE: {
                            throw new IllegalStateException("cannot promote a terminal to an attribute");
                        }
                        default: {
                            throw new IllegalStateException("unexpected mark: " + mark);
                        }
                    }
                }
                Nonterminal n = (Nonterminal)symbol;
                int alias = aliases[i - this.top - 1];
                if (alias >= 0) {
                    n.setName(Parser.this.nonterminal[alias]);
                }
                switch (mark) {
                    case ATTRIBUTE: {
                        n.setAttribute(true);
                    }
                    case NODE: {
                        if (children == null) {
                            children = new ArrayList();
                        }
                        children.add((Insertion)((Object)n));
                        continue block11;
                    }
                    case DELETE: {
                        if (children == null) {
                            children = new ArrayList();
                        }
                        children.addAll(Arrays.asList(n.children));
                        continue block11;
                    }
                    case NONE: {
                        throw new IllegalStateException();
                    }
                }
            }
            int[] insertion = reduceArgument.getInsertion();
            if (insertion != null) {
                if (children == null) {
                    children = new ArrayList<Insertion>();
                }
                children.add(new Insertion(insertion));
            }
            this.push(new Nonterminal(Parser.this.nonterminal[reduceArgument.getNonterminalId()], children == null ? new Symbol[]{} : (Symbol[])children.toArray(Symbol[]::new)));
        }

        @Override
        public void terminal(int codepoint) {
            this.push(new Terminal(codepoint));
        }

        public void serialize(EventHandler e) {
            ((Nonterminal)this.stack[0]).children[0].send(e);
        }

        public void push(Symbol s) {
            if (++this.top >= this.stack.length) {
                this.stack = Arrays.copyOf(this.stack, this.stack.length << 1);
            }
            this.stack[this.top] = s;
        }
    }

    public static class XmlSerializer
    implements EventHandler {
        private String delayedTag;
        private Writer out;
        private boolean indent;
        private boolean hasChildElement;
        private int depth;
        private int attributeLevel;

        public XmlSerializer(Writer w, boolean indent) {
            this.indent = indent;
            this.delayedTag = null;
            this.out = w;
            this.hasChildElement = false;
            this.depth = 0;
        }

        @Override
        public void startNonterminal(String name) {
            if (this.attributeLevel == 0) {
                if (this.delayedTag != null) {
                    this.writeOutput(">");
                }
                this.delayedTag = name;
                if (this.indent && this.depth > 0) {
                    this.writeOutput("\n");
                    for (int i = 0; i < this.depth; ++i) {
                        this.writeOutput("   ");
                    }
                }
                this.writeOutput("<");
                this.writeOutput(name);
                this.hasChildElement = false;
                ++this.depth;
            }
        }

        @Override
        public void endNonterminal(String name) {
            if (this.attributeLevel == 0) {
                --this.depth;
                if (this.delayedTag != null) {
                    this.delayedTag = null;
                    this.writeOutput("/>");
                } else {
                    if (this.indent && this.hasChildElement) {
                        this.writeOutput("\n");
                        for (int i = 0; i < this.depth; ++i) {
                            this.writeOutput("   ");
                        }
                    }
                    this.writeOutput("</");
                    this.writeOutput(name);
                    this.writeOutput(">");
                }
                this.hasChildElement = true;
            }
        }

        @Override
        public void startAttribute(String name) {
            ++this.attributeLevel;
            this.writeOutput(" ");
            this.writeOutput(name);
            this.writeOutput("=\"");
        }

        @Override
        public void endAttribute(String name) {
            this.writeOutput("\"");
            --this.attributeLevel;
        }

        @Override
        public void terminal(int codepoint) {
            if (!UnicodeCategory.xmlChar.containsCodepoint(codepoint)) {
                Errors.D04.thro(Codepoint.toString(codepoint));
            }
            if (this.attributeLevel > 0) {
                switch (codepoint) {
                    case 38: {
                        this.writeOutput("&amp;");
                        break;
                    }
                    case 60: {
                        this.writeOutput("&lt;");
                        break;
                    }
                    case 62: {
                        this.writeOutput("&gt;");
                        break;
                    }
                    case 34: {
                        this.writeOutput("&quot;");
                        break;
                    }
                    case 10: {
                        this.writeOutput("\n");
                        break;
                    }
                    default: {
                        if (codepoint >= 32) {
                            this.writeOutput(Character.toString(codepoint));
                            break;
                        }
                        this.writeOutput("&x");
                        this.writeOutput(Integer.toString(codepoint, 16).toUpperCase());
                        this.writeOutput(";");
                        break;
                    }
                }
            } else {
                if (this.delayedTag != null) {
                    this.writeOutput(">");
                    this.delayedTag = null;
                }
                switch (codepoint) {
                    case 38: {
                        this.writeOutput("&amp;");
                        break;
                    }
                    case 60: {
                        this.writeOutput("&lt;");
                        break;
                    }
                    case 62: {
                        this.writeOutput("&gt;");
                        break;
                    }
                    case 10: {
                        this.writeOutput("\n");
                        break;
                    }
                    default: {
                        if (codepoint >= 32) {
                            this.writeOutput(Character.toString(codepoint));
                            break;
                        }
                        this.writeOutput("&#x");
                        this.writeOutput(Integer.toString(codepoint, 16).toUpperCase());
                        this.writeOutput(";");
                    }
                }
            }
        }

        public void writeOutput(String content) {
            try {
                this.out.write(content);
            }
            catch (IOException e) {
                throw new BlitzException(e);
            }
        }
    }

    public static interface BottomUpEventHandler {
        public void nonterminal(ReduceArgument var1);

        public void terminal(int var1);
    }

    public static class Nonterminal
    extends Symbol {
        private String name;
        private Symbol[] children;
        private boolean isAttribute;

        public Nonterminal(String name, Symbol[] children) {
            this.name = name;
            this.children = children;
            this.isAttribute = false;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAttribute(boolean isAttribute) {
            this.isAttribute = isAttribute;
        }

        @Override
        public void send(EventHandler e) {
            if (this.isAttribute) {
                e.startAttribute(this.name);
                for (Symbol c : this.children) {
                    c.sendContent(e);
                }
                e.endAttribute(this.name);
            } else {
                if (this.name.charAt(0) == ' ') {
                    Errors.D03.thro(this.name);
                }
                e.startNonterminal(this.name);
                HashSet<String> names = new HashSet<String>();
                for (Symbol c : this.children) {
                    if (!(c instanceof Nonterminal)) continue;
                    Nonterminal nonterminal = (Nonterminal)c;
                    if (!nonterminal.isAttribute) continue;
                    String attributeName = nonterminal.name;
                    if (attributeName.equals("xmlns")) {
                        Errors.D07.thro(new String[0]);
                    }
                    if (!names.add(attributeName)) {
                        Errors.D02.thro(attributeName);
                    }
                    if (attributeName.charAt(0) == ' ') {
                        Errors.D03.thro(attributeName);
                    }
                    c.send(e);
                }
                for (Symbol c : this.children) {
                    if (c instanceof Nonterminal && ((Nonterminal)c).isAttribute) continue;
                    c.send(e);
                }
                e.endNonterminal(this.name);
            }
        }

        @Override
        public void sendContent(EventHandler e) {
            for (Symbol c : this.children) {
                if (c instanceof Nonterminal && ((Nonterminal)c).isAttribute) continue;
                c.sendContent(e);
            }
        }

        public void addChildren(Symbol ... newChildren) {
            int length = this.children.length;
            this.children = Arrays.copyOf(this.children, length + newChildren.length);
            System.arraycopy(newChildren, 0, this.children, length, newChildren.length);
        }
    }

    public class Insertion
    extends Symbol {
        public int[] codepoints;

        public Insertion(int[] codepoints) {
            this.codepoints = codepoints;
        }

        @Override
        public void send(EventHandler e) {
            for (int codepoint : this.codepoints) {
                e.terminal(codepoint);
            }
        }

        @Override
        public void sendContent(EventHandler e) {
            for (int codepoint : this.codepoints) {
                e.terminal(codepoint);
            }
        }
    }

    public class Terminal
    extends Symbol {
        public int codepoint;

        public Terminal(int codepoint) {
            this.codepoint = codepoint;
        }

        @Override
        public void send(EventHandler e) {
            e.terminal(this.codepoint);
        }

        @Override
        public void sendContent(EventHandler e) {
            e.terminal(this.codepoint);
        }
    }

    public static abstract class Symbol {
        public abstract void send(EventHandler var1);

        public abstract void sendContent(EventHandler var1);
    }

    public static interface EventHandler {
        public void startNonterminal(String var1);

        public void startAttribute(String var1);

        public void endAttribute(String var1);

        public void endNonterminal(String var1);

        public void terminal(int var1);
    }

    private static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int begin;
        private int end;
        private int offending;
        private int state;
        private boolean wasStalled;

        public ParseException(int begin, int end, int state, int offending, boolean wasStalled) {
            this.begin = begin;
            this.end = end;
            this.state = state;
            this.offending = offending;
            this.wasStalled = wasStalled;
        }

        @Override
        public String getMessage() {
            return this.offending < 0 ? "lexical analysis failed" : "syntax error";
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        public int getState() {
            return this.state;
        }

        public int getOffending() {
            return this.offending;
        }

        public boolean wasStalled() {
            return this.wasStalled;
        }
    }
}

