/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.codepoints;

import de.bottlecaps.markup.blitz.Errors;
import de.bottlecaps.markup.blitz.codepoints.Codepoint;

public class Range
implements Comparable<Range> {
    private final int firstCodepoint;
    private final int lastCodepoint;

    public Range(int firstCodepoint, int lastCodepoint) {
        this.firstCodepoint = firstCodepoint;
        this.lastCodepoint = lastCodepoint;
        if (firstCodepoint > lastCodepoint) {
            Errors.S09.thro(this.toString());
        }
    }

    public Range(int codepoint) {
        this(codepoint, codepoint);
    }

    public int getFirstCodepoint() {
        return this.firstCodepoint;
    }

    public int getLastCodepoint() {
        return this.lastCodepoint;
    }

    public boolean isSingleton() {
        return this.firstCodepoint == this.lastCodepoint;
    }

    public boolean overlaps(Range other) {
        return this.firstCodepoint <= other.lastCodepoint && this.lastCodepoint >= other.firstCodepoint;
    }

    public String toString() {
        return this.firstCodepoint == this.lastCodepoint ? Codepoint.toString(this.firstCodepoint) : Codepoint.toString(this.firstCodepoint) + "-" + Codepoint.toString(this.lastCodepoint);
    }

    public String toJava() {
        return ".add(" + Codepoint.toJava(this.firstCodepoint) + (String)(this.firstCodepoint == this.lastCodepoint ? "" : ", " + Codepoint.toJava(this.lastCodepoint)) + ")";
    }

    public String toREx() {
        if (this.size() > 1 && "[^-]".indexOf(this.firstCodepoint) >= 0) {
            return new Range(this.firstCodepoint).toREx() + " | " + new Range(this.firstCodepoint + 1, this.lastCodepoint).toREx();
        }
        if (this.size() > 1 && "[^-]".indexOf(this.lastCodepoint) >= 0) {
            return new Range(this.firstCodepoint, this.lastCodepoint - 1).toREx() + " | " + new Range(this.lastCodepoint).toREx();
        }
        if (this.size() == 1) {
            return !Codepoint.isAscii(this.firstCodepoint) ? "#x" + Integer.toHexString(this.firstCodepoint) : (this.firstCodepoint == 39 ? "\"" + (char)this.firstCodepoint + "\"" : "'" + (char)this.firstCodepoint + "'");
        }
        if (Codepoint.isAscii(this.firstCodepoint) && Codepoint.isAscii(this.lastCodepoint)) {
            return "[" + (char)this.firstCodepoint + "-" + (char)this.lastCodepoint + "]";
        }
        return "[#x" + Integer.toHexString(this.firstCodepoint) + "-#x" + Integer.toHexString(this.lastCodepoint) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.firstCodepoint;
        result = 31 * result + this.lastCodepoint;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (this.firstCodepoint != other.firstCodepoint) {
            return false;
        }
        return this.lastCodepoint == other.lastCodepoint;
    }

    @Override
    public int compareTo(Range other) {
        if (this.firstCodepoint < other.firstCodepoint) {
            return -1;
        }
        if (this.firstCodepoint > other.firstCodepoint) {
            return 1;
        }
        if (this.lastCodepoint < other.lastCodepoint) {
            return -1;
        }
        if (this.lastCodepoint > other.lastCodepoint) {
            return 1;
        }
        return 0;
    }

    public int size() {
        return this.lastCodepoint - this.firstCodepoint + 1;
    }
}

