/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.Blitz;
import de.bottlecaps.markup.blitz.codepoints.Range;
import de.bottlecaps.markup.blitz.codepoints.RangeSet;
import de.bottlecaps.markup.blitz.grammar.Alt;
import de.bottlecaps.markup.blitz.grammar.Alts;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Control;
import de.bottlecaps.markup.blitz.grammar.Grammar;
import de.bottlecaps.markup.blitz.grammar.Insertion;
import de.bottlecaps.markup.blitz.grammar.Literal;
import de.bottlecaps.markup.blitz.grammar.Mark;
import de.bottlecaps.markup.blitz.grammar.Node;
import de.bottlecaps.markup.blitz.grammar.Nonterminal;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.Copy;
import de.bottlecaps.markup.blitz.transform.PostProcess;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;

public class ClassifyCharacters
extends Copy {
    private Set<RangeSet> allSets;
    private Queue<String> todo;
    private Set<String> done;
    private CharsetCollector charsetCollector;

    public ClassifyCharacters(Grammar g) {
        super(g);
    }

    public Grammar combine(Grammar g, Set<Blitz.Option> options) {
        ArrayList<Long> t = new ArrayList<Long>();
        t.add(System.currentTimeMillis());
        this.todo = new LinkedList<String>();
        this.done = new HashSet<String>();
        this.charsetCollector = new CharsetCollector();
        this.allSets = new HashSet<RangeSet>();
        g.setAdditionalNames(new HashMap<Term, String[]>());
        t.add(System.currentTimeMillis());
        String firstRuleName = g.getRules().values().iterator().next().getName();
        this.todo.add(firstRuleName);
        this.done.add(firstRuleName);
        while (!this.todo.isEmpty()) {
            String name = this.todo.poll();
            this.visit(g.getRule(name));
        }
        t.add(System.currentTimeMillis());
        this.copy.setAdditionalNames(g.getAdditionalNames());
        PostProcess.process(this.copy);
        t.add(System.currentTimeMillis());
        Set<RangeSet> charClasses = ClassifyCharacters.classify(this.allSets);
        t.add(System.currentTimeMillis());
        HashMap<RangeSet, Set<RangeSet>> charsetToClasses = ClassifyCharacters.mapToClasses(this.allSets, charClasses);
        t.add(System.currentTimeMillis());
        Grammar result = ReplaceCharsets.process(this.copy, charsetToClasses);
        t.add(System.currentTimeMillis());
        if (options.contains((Object)Blitz.Option.TIMING)) {
            for (int i = 1; i < t.size(); ++i) {
                System.err.println("                                                                   time: " + ((Long)t.get(i) - (Long)t.get(i - 1)) + " msec");
            }
        }
        return result;
    }

    @Override
    public void visit(Charset c) {
        super.visit(c);
        this.allSets.add(c.getRangeSet());
    }

    @Override
    public void visit(Nonterminal n) {
        Charset charset = this.charsetCollector.collectCharset(n);
        if (charset != null) {
            ((Alts)this.alts.peek()).last().getTerms().add(charset);
            this.allSets.add(charset.getRangeSet());
            n.getGrammar().getAdditionalNames().put(charset, new String[]{n.getName()});
        } else {
            if (!this.done.contains(n.getName())) {
                this.done.add(n.getName());
                this.todo.offer(n.getName());
            }
            super.visit(n);
        }
    }

    @Override
    public void visit(Alts a) {
        boolean hasDeletedChars = false;
        RangeSet deletedChars = RangeSet.EMPTY;
        boolean hasPreservedChars = false;
        RangeSet preservedChars = RangeSet.EMPTY;
        Alts other = new Alts();
        for (Alt alt : a.getAlts()) {
            Charset charset = this.charsetCollector.collectCharset(alt);
            if (charset == null) {
                other.addAlt(alt);
                continue;
            }
            if (charset.isDeleted()) {
                hasDeletedChars = true;
                deletedChars = deletedChars.union(charset.getRangeSet());
                continue;
            }
            hasPreservedChars = true;
            preservedChars = preservedChars.union(charset.getRangeSet());
        }
        if (other.equals(a)) {
            super.visit(a);
        } else {
            Charset charset;
            Alts replacement = new Alts();
            if (hasDeletedChars) {
                charset = new Charset(true, deletedChars);
                replacement.addAlt(new Alt().addCharset(charset));
                this.allSets.add(deletedChars);
            }
            if (hasPreservedChars) {
                charset = new Charset(false, preservedChars);
                replacement.addAlt(new Alt().addCharset(charset));
                this.allSets.add(preservedChars);
            }
            boolean topLevel = this.alts.isEmpty();
            this.alts.push(replacement);
            for (Alt alt : other.getAlts()) {
                alt.accept(this);
            }
            if (!topLevel) {
                Alts nested = (Alts)this.alts.pop();
                ((Alts)this.alts.peek()).last().addAlts(nested);
            }
        }
    }

    @Override
    public void visit(Alt alt) {
        ((Alts)this.alts.peek()).addAlt(new Alt());
        List<Term> terms = alt.getTerms();
        for (int t = 0; t < terms.size(); ++t) {
            Term term = terms.get(t);
            if (term instanceof Literal) {
                List<Charset> charsets = this.literalToCharsets((Literal)term);
                ((Alts)this.alts.peek()).last().getTerms().addAll(charsets);
                continue;
            }
            if (term instanceof Insertion && term.getNext() instanceof Insertion) {
                Insertion i = (Insertion)term;
                int[] ic = i.getCodepoints();
                while (i.getNext() instanceof Insertion) {
                    ++t;
                    Insertion n = (Insertion)i.getNext();
                    int[] nc = n.getCodepoints();
                    int[] cc = Arrays.copyOf(ic, ic.length + nc.length);
                    System.arraycopy(nc, 0, cc, ic.length, nc.length);
                    i = n;
                    ic = cc;
                }
                Insertion combinedInsertion = new Insertion(ic);
                ((Alts)this.alts.peek()).last().getTerms().add(combinedInsertion);
                continue;
            }
            term.accept(this);
        }
    }

    private List<Charset> literalToCharsets(Literal l) {
        ArrayList<Charset> charsets = new ArrayList<Charset>();
        for (int codepoint : l.getCodepoints()) {
            RangeSet rangeSet = RangeSet.builder().add(codepoint).build();
            Charset charset = new Charset(l.isDeleted(), rangeSet);
            this.allSets.add(rangeSet);
            charsets.add(charset);
        }
        return charsets;
    }

    private Term literalToTerm(Literal l) {
        List<Charset> charsets = this.literalToCharsets(l);
        if (charsets.size() == 1) {
            return charsets.get(0);
        }
        Alts alts = new Alts();
        charsets.stream().forEach(c -> alts.addAlt(new Alt().addCharset((Charset)c)));
        return alts;
    }

    @Override
    public void visit(Literal l) {
        throw new IllegalStateException();
    }

    @Override
    public void visit(Control c) {
        if (c.getTerm() instanceof Literal) {
            ((Alts)this.alts.peek()).last().getTerms().add(this.literalToTerm((Literal)c.getTerm()));
        } else {
            c.getTerm().accept(this);
        }
        if (c.getSeparator() instanceof Literal) {
            ((Alts)this.alts.peek()).last().getTerms().add(this.literalToTerm((Literal)c.getSeparator()));
        } else if (c.getSeparator() != null) {
            c.getSeparator().accept(this);
        }
        Term separator = c.getSeparator() == null ? null : ((Alts)this.alts.peek()).last().removeLast();
        Term term = ((Alts)this.alts.peek()).last().removeLast();
        ((Alts)this.alts.peek()).last().getTerms().add(new Control(c.getOccurrence(), this.term(term), this.term(separator)));
    }

    private Term term(Term term) {
        while (term instanceof Alts && ((Alts)term).getAlts().size() == 1 && ((Alts)term).getAlts().get(0).getTerms().size() == 1) {
            term = ((Alts)term).getAlts().get(0).getTerms().get(0);
        }
        return term;
    }

    public static Set<RangeSet> classify(Collection<RangeSet> allRangeSets) {
        if (allRangeSets.isEmpty()) {
            return Collections.emptySet();
        }
        RangeSet.Builder builder = RangeSet.builder();
        allRangeSets.forEach(builder::add);
        RangeSet[] charClasses = new RangeSet[allRangeSets.size()];
        int classCount = 1;
        charClasses[0] = builder.build();
        Iterator<RangeSet> iterator = allRangeSets.iterator();
        block0: while (iterator.hasNext()) {
            RangeSet rangeSet;
            RangeSet divisor = rangeSet = iterator.next();
            int classesToCheck = classCount;
            for (int i = 0; i < classesToCheck; ++i) {
                RangeSet intersection = divisor.intersection(charClasses[i]);
                if (intersection.isEmpty()) continue;
                if (!intersection.equals(charClasses[i])) {
                    if (classCount == charClasses.length) {
                        charClasses = Arrays.copyOf(charClasses, charClasses.length << 1);
                    }
                    charClasses[classCount++] = intersection;
                    charClasses[i] = charClasses[i].minus(intersection);
                }
                if ((divisor = divisor.minus(intersection)).isEmpty()) continue block0;
            }
        }
        return new TreeSet<RangeSet>(Arrays.asList(charClasses).subList(0, classCount));
    }

    private static HashMap<RangeSet, Set<RangeSet>> mapToClasses(Set<RangeSet> allSets, Set<RangeSet> charClasses) {
        HashMap<RangeSet, Set<RangeSet>> charsetToClasses = new HashMap<RangeSet, Set<RangeSet>>();
        allSets.forEach(s -> charsetToClasses.put((RangeSet)s, ClassifyCharacters.charClasses(s, charClasses)));
        return charsetToClasses;
    }

    public static Set<RangeSet> charClasses(RangeSet characters, Set<RangeSet> charClasses) {
        if (characters.isEmpty()) {
            return Collections.emptySet();
        }
        Iterator<Range> iterator = characters.iterator();
        Range firstRange = iterator.next();
        int firstCodepoint = firstRange.getFirstCodepoint();
        if (firstCodepoint == firstRange.getLastCodepoint() && !iterator.hasNext()) {
            return Set.of(characters);
        }
        TreeSet<RangeSet> result = new TreeSet<RangeSet>();
        for (RangeSet charClass : charClasses) {
            if (!charClass.containsCodepoint(firstCodepoint)) continue;
            result.add(charClass);
            characters = characters.minus(charClass);
            if (characters.isEmpty()) {
                return result;
            }
            firstCodepoint = characters.iterator().next().getFirstCodepoint();
        }
        throw new IllegalStateException();
    }

    private static class ReplaceCharsets
    extends Copy {
        private Map<RangeSet, Set<RangeSet>> charsetToCharclasses;

        private ReplaceCharsets(Grammar grammar) {
            super(grammar);
        }

        public static Grammar process(Grammar g, Map<RangeSet, Set<RangeSet>> charsetToCharclasses) {
            ReplaceCharsets rc = new ReplaceCharsets(new Grammar(g));
            rc.charsetToCharclasses = charsetToCharclasses;
            rc.visit(g);
            rc.copy.setAdditionalNames(g.getAdditionalNames());
            PostProcess.process(rc.copy);
            return rc.copy;
        }

        @Override
        public void visit(Charset c) {
            Set<RangeSet> charClass = this.charsetToCharclasses.get(c.getRangeSet());
            if (charClass.size() <= 1) {
                ((Alts)this.alts.peek()).last().getTerms().add(c.copy());
            } else {
                Alts a = new Alts();
                for (RangeSet rangeSet : charClass) {
                    Alt alt = new Alt();
                    alt.getTerms().add(rangeSet.toCharset(c.isDeleted()));
                    a.addAlt(alt);
                }
                ((Alts)this.alts.peek()).last().getTerms().add(a);
                String[] name = c.getGrammar().getAdditionalNames().get(c);
                if (name != null) {
                    c.getGrammar().getAdditionalNames().put(a, name);
                }
            }
        }
    }

    private static class CharsetCollector
    extends Visitor {
        private boolean isDeleted;
        private boolean isPreserved;
        private RangeSet rangeSet;
        private Set<String> active = new HashSet<String>();

        private CharsetCollector() {
        }

        public Charset collectCharset(Node node) {
            this.isDeleted = true;
            this.isPreserved = true;
            this.rangeSet = RangeSet.EMPTY;
            this.active.clear();
            node.accept(this);
            Charset charset = this.rangeSet == null || this.isPreserved == this.isDeleted ? null : new Charset(this.isDeleted, this.rangeSet);
            return charset;
        }

        @Override
        public void visit(Alt a) {
            if (a.getTerms().size() != 1) {
                this.rangeSet = null;
            } else {
                super.visit(a);
            }
        }

        @Override
        public void visit(Alts a) {
            super.visit(a);
        }

        @Override
        public void visit(Charset c) {
            if (this.rangeSet != null) {
                this.rangeSet = this.rangeSet.union(c.getRangeSet());
                this.isPreserved = this.isPreserved && !c.isDeleted();
                this.isDeleted = this.isDeleted && c.isDeleted();
            }
        }

        @Override
        public void visit(Control c) {
            this.rangeSet = null;
        }

        @Override
        public void visit(Grammar g) {
            this.rangeSet = null;
        }

        @Override
        public void visit(Insertion i) {
            this.rangeSet = null;
        }

        @Override
        public void visit(Literal l) {
            if (this.rangeSet != null) {
                int[] codepoints = l.getCodepoints();
                if (codepoints.length == 1) {
                    this.rangeSet = this.rangeSet.union(RangeSet.builder().add(codepoints[0]).build());
                    this.isPreserved = this.isPreserved && !l.isDeleted();
                    this.isDeleted = this.isDeleted && l.isDeleted();
                } else {
                    this.rangeSet = null;
                }
            }
        }

        @Override
        public void visit(Nonterminal n) {
            if (this.active.contains(n.getName())) {
                this.rangeSet = null;
                return;
            }
            this.active.add(n.getName());
            if (this.rangeSet != null) {
                if (n.getEffectiveMark() != Mark.DELETE) {
                    this.rangeSet = null;
                } else {
                    n.getGrammar().getRule(n.getName()).getAlts().accept(this);
                }
            }
            this.active.remove(n.getName());
        }

        @Override
        public void visit(Rule r) {
            this.rangeSet = null;
        }
    }
}

