/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.codepoints.Range;
import de.bottlecaps.markup.blitz.codepoints.RangeSet;
import de.bottlecaps.markup.blitz.grammar.Alt;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Grammar;
import de.bottlecaps.markup.blitz.grammar.Literal;
import de.bottlecaps.markup.blitz.grammar.Nonterminal;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ToREx
extends Visitor {
    private final String padding = "                ";
    private StringBuilder sb = new StringBuilder();
    private Map<String, String> charsets = new LinkedHashMap<String, String>();
    private Grammar grammar;

    private ToREx() {
    }

    public static String process(Grammar g) {
        ToREx toREx = new ToREx();
        toREx.grammar = g;
        toREx.visit(Charset.END);
        toREx.sb.setLength(0);
        toREx.visit(g);
        if (!toREx.charsets.isEmpty()) {
            toREx.sb.append("\n\n<?TOKENS?>\n");
            toREx.charsets.values().forEach(toREx.sb::append);
        }
        return toREx.sb.toString();
    }

    @Override
    public void visit(Rule r) {
        Rule firstRule = r.getGrammar().getRules().values().iterator().next();
        if (r != firstRule) {
            this.sb.append("\n");
        }
        String name = r.getName();
        this.sb.append(name);
        int paddingLength = "                ".length() - name.length() - 2;
        if (paddingLength < 1) {
            this.sb.append("\n");
            paddingLength = "                ".length() - 2;
        }
        this.sb.append("                ".substring(0, paddingLength));
        this.sb.append("::=");
        super.visit(r);
        if (r == firstRule) {
            this.sb.append(" ").append(this.grammar.getAdditionalNames().get(Charset.END)[0]);
        }
    }

    @Override
    public void visit(Alt a) {
        if (a != a.getRule().getAlts().getAlts().iterator().next()) {
            this.sb.append("\n").append("                ").append("|");
        }
        super.visit(a);
    }

    @Override
    public void visit(Charset c) {
        this.sb.append(" ");
        RangeSet rangeSet = c.getRangeSet();
        if (rangeSet.isSingleton() && Codepoint.isAscii(rangeSet.iterator().next().getFirstCodepoint())) {
            this.sb.append(rangeSet.iterator().next().toREx());
        } else {
            String[] name = this.grammar.getAdditionalNames().get(c);
            this.sb.append(name[0]);
            if (!this.charsets.containsKey(name[0])) {
                StringBuilder tb = new StringBuilder("\n").append(name[0]);
                int paddingLength = "                ".length() - name[0].length() - 2;
                if (paddingLength < 1) {
                    tb.append("\n");
                    paddingLength = "                ".length() - 2;
                }
                tb.append("                ".substring(0, paddingLength));
                tb.append("::= ");
                if (c == Charset.END) {
                    tb.append("$");
                } else {
                    tb.append(rangeSet.stream().map(Range::toREx).collect(Collectors.joining("\n                | ")));
                }
                this.charsets.put(name[0], tb.toString());
            }
        }
    }

    @Override
    public void visit(Nonterminal n) {
        this.sb.append(" ").append(n.getName());
    }

    @Override
    public void visit(Literal l) {
        throw new IllegalStateException();
    }
}

