/*
 * Decompiled with CFR 0.152.
 */
package de.breakpointsec.pushdown.fsm;

import de.breakpointsec.pushdown.Configuration;

public class Transition<Loc, State> {
    private final State s1;
    private final Loc l1;
    private final State s2;
    private int hashCode;

    public Transition(State s1, Loc l1, State s2) {
        assert (s1 != null);
        assert (s2 != null);
        assert (l1 != null);
        this.s1 = s1;
        this.l1 = l1;
        this.s2 = s2;
    }

    public Configuration<Loc, State> getStartConfig() {
        return new Configuration<Loc, State>(this.l1, this.s1);
    }

    public State getTarget() {
        return this.s2;
    }

    public State getStart() {
        return this.s1;
    }

    public Loc getString() {
        return this.l1;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.l1 == null ? 0 : this.l1.hashCode());
        result = 31 * result + (this.s1 == null ? 0 : this.s1.hashCode());
        this.hashCode = result = 31 * result + (this.s2 == null ? 0 : this.s2.hashCode());
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transition other = (Transition)obj;
        if (this.l1 == null ? other.l1 != null : !this.l1.equals(other.l1)) {
            return false;
        }
        if (this.s1 == null ? other.s1 != null : !this.s1.equals(other.s1)) {
            return false;
        }
        return !(this.s2 == null ? other.s2 != null : !this.s2.equals(other.s2));
    }

    public String toString() {
        return this.s1 + " ~" + this.l1 + "~> " + this.s2;
    }

    public Loc getLabel() {
        return this.l1;
    }
}

