/*
 * Decompiled with CFR 0.152.
 */
package de.breakpointsec.pushdown.weights;

import de.breakpointsec.pushdown.weights.Semiring;

public class NumSemiring
extends Semiring<Integer> {
    private int i;
    private static NumSemiring one;
    private static NumSemiring zero;

    public NumSemiring(int i) {
        this.i = i;
    }

    private NumSemiring() {
    }

    @Override
    public Semiring extendWith(Semiring other) {
        if (this.equals(NumSemiring.one())) {
            return other;
        }
        if (other.equals(NumSemiring.one())) {
            return this;
        }
        if (this.equals(NumSemiring.zero()) || other.equals(NumSemiring.zero())) {
            return NumSemiring.zero();
        }
        NumSemiring o = (NumSemiring)other;
        return new NumSemiring(o.i + this.i);
    }

    @Override
    public Semiring combineWith(Semiring other) {
        if (other.equals(NumSemiring.zero())) {
            return this;
        }
        if (this.equals(NumSemiring.zero())) {
            return other;
        }
        NumSemiring o = (NumSemiring)other;
        if (o.i == this.i) {
            return o;
        }
        return NumSemiring.zero();
    }

    @Override
    public Integer value() {
        return this.i;
    }

    public static <N> NumSemiring one() {
        if (one == null) {
            one = new NumSemiring(){

                @Override
                public String toString() {
                    return "<ONE>";
                }

                @Override
                public boolean equals(Object obj) {
                    return obj == this;
                }
            };
        }
        return one;
    }

    public static <N> NumSemiring zero() {
        if (zero == null) {
            zero = new NumSemiring(){

                @Override
                public String toString() {
                    return "<ZERO>";
                }

                @Override
                public boolean equals(Object obj) {
                    return obj == this;
                }
            };
        }
        return zero;
    }

    public String toString() {
        return Integer.toString(this.i);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.i;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumSemiring other = (NumSemiring)obj;
        return this.i == other.i;
    }
}

